/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptGeneration;
import org.faktorips.devtools.model.internal.productcmpt.PropertyValueContainerToTypeDelta;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.InvalidGenerationsDeltaEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.MissingPropertyValueEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.ValueWithoutPropertyEntry;
import org.faktorips.devtools.model.ipsobject.IFixDifferencesComposite;
import org.faktorips.devtools.model.ipsobject.IIpsObjectGeneration;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IDeltaEntry;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainerToTypeDelta;

public class ProductCmptToTypeDelta
extends PropertyValueContainerToTypeDelta {
    public ProductCmptToTypeDelta(IProductCmpt productCmpt, IIpsProject ipsProject) {
        super(productCmpt, productCmpt, ipsProject);
    }

    @Override
    public IProductCmpt getPropertyValueContainer() {
        return (IProductCmpt)super.getPropertyValueContainer();
    }

    @Override
    protected void createAdditionalEntriesAndChildren() {
        this.checkInvalidGenerations();
        IIpsObjectGeneration[] iIpsObjectGenerationArray = this.getPropertyValueContainer().getGenerationsOrderedByValidDate();
        int n = iIpsObjectGenerationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectGeneration generation = iIpsObjectGenerationArray[n2];
            ProductCmptGeneration productCmptGen = (ProductCmptGeneration)generation;
            IPropertyValueContainerToTypeDelta computeDeltaToModel = productCmptGen.computeDeltaToModel(this.getIpsProject());
            this.addChild(computeDeltaToModel);
            ++n2;
        }
        this.findAndSetPredecessors();
    }

    private void checkInvalidGenerations() {
        if (!this.getPropertyValueContainer().allowGenerations() && this.getPropertyValueContainer().getGenerations().size() > 1) {
            this.addEntry(new InvalidGenerationsDeltaEntry(this.getPropertyValueContainer()));
        }
    }

    private void findAndSetPredecessors() {
        ArrayList<ValueWithoutPropertyEntry> valueWithoutPropertyEntries = new ArrayList<ValueWithoutPropertyEntry>();
        ArrayList<MissingPropertyValueEntry> missingPropertyValueEntries = new ArrayList<MissingPropertyValueEntry>();
        this.addEntries(this.getEntries(), valueWithoutPropertyEntries, missingPropertyValueEntries);
        for (IFixDifferencesComposite fixDifferencesComposite : this.getChildren()) {
            PropertyValueContainerToTypeDelta propertyValueContainerToTypeDelta = (PropertyValueContainerToTypeDelta)fixDifferencesComposite;
            this.addEntries(propertyValueContainerToTypeDelta.getEntries(), valueWithoutPropertyEntries, missingPropertyValueEntries);
        }
        for (ValueWithoutPropertyEntry valueWithoutPropertyEntry : valueWithoutPropertyEntries) {
            for (MissingPropertyValueEntry missingPropertyValueEntry : missingPropertyValueEntries) {
                if (!this.isMatchingPropertyValue(valueWithoutPropertyEntry, missingPropertyValueEntry)) continue;
                missingPropertyValueEntry.setPredecessor(valueWithoutPropertyEntry);
            }
        }
    }

    private boolean isMatchingPropertyValue(ValueWithoutPropertyEntry valueWithoutPropertyEntry, MissingPropertyValueEntry missingPropertyValueEntry) {
        return valueWithoutPropertyEntry.getPropertyName().equals(missingPropertyValueEntry.getPropertyName()) && valueWithoutPropertyEntry.getPropertyType().equals((Object)missingPropertyValueEntry.getPropertyType());
    }

    protected void addEntries(IDeltaEntry[] entries, List<ValueWithoutPropertyEntry> valueWithoutPropertyEntries, List<MissingPropertyValueEntry> missingPropertyEntries) {
        IDeltaEntry[] iDeltaEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IDeltaEntry entry = iDeltaEntryArray[n2];
            if (entry instanceof ValueWithoutPropertyEntry) {
                valueWithoutPropertyEntries.add((ValueWithoutPropertyEntry)entry);
            }
            if (entry instanceof MissingPropertyValueEntry) {
                missingPropertyEntries.add((MissingPropertyValueEntry)entry);
            }
            ++n2;
        }
    }
}

