/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.text.MessageFormat;
import org.faktorips.devtools.model.internal.ipsobject.DeprecationValidation;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.Messages;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;

public class ProductCmptValidations {
    private ProductCmptValidations() {
    }

    public static final IProductCmptType validateProductCmptType(IProductCmpt productCmpt, String productCmptTypeName, MessageList list, IIpsProject ipsProject) {
        IProductCmptType type = ProductCmptValidations.findProductCmptType(productCmptTypeName, ipsProject);
        if (type == null) {
            String text = MessageFormat.format(Messages.ProductCmptValidations_typeDoesNotExist, productCmptTypeName);
            list.add(new Message("PRODUCT_CMPT-MissingProductCmptType", text, Message.ERROR, (Object)productCmpt, new String[]{"productCmptType"}));
            return null;
        }
        if (!productCmpt.isProductTemplate() && type.isAbstract()) {
            String text = MessageFormat.format(Messages.ProductCmptValidations_typeIsAbstract, productCmptTypeName);
            list.add(new Message("PRODUCT_CMPT-AbstractProductCmptType", text, Message.ERROR, (Object)productCmpt, new String[]{"productCmptType"}));
            return null;
        }
        DeprecationValidation.validateProductCmptTypeIsNotDeprecated(productCmpt, productCmpt.getQualifiedName(), type, ipsProject, list);
        return type;
    }

    public static final IProductCmpt validateTemplate(IProductCmpt productCmpt, IProductCmptType productCmptType, MessageList list, IIpsProject ipsProject) {
        String templateName = productCmpt.getTemplate();
        if (IpsStringUtils.isNotEmpty((String)templateName)) {
            IProductCmpt template = ipsProject.findProductTemplate(templateName);
            if (template != null) {
                ObjectProperty typeProperty = new ObjectProperty((Object)productCmpt, "productCmptType");
                ObjectProperty templateProperty = new ObjectProperty((Object)productCmpt, "template");
                ProductCmptValidations.validateTemplateType(productCmptType, list, ipsProject, template, typeProperty, templateProperty);
                ProductCmptValidations.validateValidFrom(list, template, productCmpt);
            } else {
                String text = MessageFormat.format(Messages.ProductCmptValidations_error_invalidTemplate, templateName);
                list.newError("PRODUCT_CMPT-InvalidTemplate", text, (Object)productCmpt, new String[]{"template"});
            }
            return template;
        }
        return null;
    }

    private static void validateTemplateType(IProductCmptType productCmptType, MessageList list, IIpsProject ipsProject, IProductCmpt template, ObjectProperty ... invalidProperties) {
        IProductCmptType templateCmptType = ProductCmptValidations.findProductCmptType(template.getProductCmptType(), ipsProject);
        if (templateCmptType != null && !ProductCmptValidations.isSubtypeOrSame(productCmptType, templateCmptType, ipsProject)) {
            list.newError("PRODUCT_CMPT-InconsistTemplateType", Messages.ProductCmptValidations_error_inconsistentTemplateType, invalidProperties);
        }
    }

    protected static void validateValidFrom(MessageList list, IProductCmpt template, IProductCmpt productCmpt) {
        if (productCmpt.getValidFrom().before(template.getValidFrom())) {
            list.newError("PRODUCT_CMPT-InconsistTemplateValidFrom", Messages.ProductCmptValidations_error_validFromTemplate, (Object)productCmpt, new String[]{"template"});
        }
    }

    private static boolean isSubtypeOrSame(IProductCmptType productCmptType, IProductCmptType templateCmptType, IIpsProject ipsProject) {
        return productCmptType.isSubtypeOrSameType(templateCmptType, ipsProject);
    }

    private static IProductCmptType findProductCmptType(String productCmptTypeName, IIpsProject ipsProject) {
        return ipsProject.findProductCmptType(productCmptTypeName);
    }
}

