/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.faktorips.devtools.model.internal.productcmpt.LegacyConfigElement;
import org.faktorips.devtools.model.internal.productcmpt.PropertyValueComparator;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.util.ClassToInstancesMap;

public class PropertyValueCollection {
    private static final PropertyValueComparator COMPARATOR = new PropertyValueComparator();
    private final ClassToInstancesMap<IPropertyValue> classToInstancesMap;
    private final IPropertyValueContainer propertyValueContainer;

    public PropertyValueCollection(IPropertyValueContainer propertyValueContainer) {
        this.propertyValueContainer = propertyValueContainer;
        this.classToInstancesMap = new ClassToInstancesMap();
    }

    public <T extends IPropertyValue> T getPropertyValue(IProductCmptProperty property, Class<T> type) {
        if (property == null) {
            return null;
        }
        return this.getPropertyValue(property.getPropertyName(), type);
    }

    public List<IPropertyValue> getPropertyValues(IProductCmptProperty property) {
        if (property == null) {
            return Collections.emptyList();
        }
        return property.getPropertyValueTypes().stream().filter(t -> t != null).map(type -> this.getPropertyValue(property, type.getInterfaceClass())).filter(value -> value != null).collect(Collectors.toList());
    }

    public <T extends IPropertyValue> T getPropertyValue(String propertyName, Class<T> type) {
        List list = this.classToInstancesMap.get(type);
        for (IPropertyValue propertyValue : list) {
            if (!propertyValue.getPropertyName().equals(propertyName)) continue;
            return (T)propertyValue;
        }
        return null;
    }

    public <T extends IPropertyValue> List<T> getPropertyValues(String propertyName) {
        List<IPropertyValue> allValues = this.getAllPropertyValues();
        return PropertyValueCollection.getPropertyValuesFromList(allValues, propertyName);
    }

    private static <T extends IPropertyValue> List<T> getPropertyValuesFromList(List<IPropertyValue> valueList, String propertyName) {
        ArrayList<IPropertyValue> result = new ArrayList<IPropertyValue>();
        if (propertyName == null || valueList == null) {
            return result;
        }
        for (IPropertyValue value : valueList) {
            if (!propertyName.equals(value.getPropertyName())) continue;
            IPropertyValue castedValue = value;
            result.add(castedValue);
        }
        return result;
    }

    public <T extends IPropertyValue> List<T> getPropertyValues(Class<T> clazz) {
        return new ArrayList(this.classToInstancesMap.get(clazz));
    }

    public List<IPropertyValue> newPropertyValues(IPropertyValueContainer container, IProductCmptProperty property, String partId) {
        ArrayList<IPropertyValue> result = new ArrayList<IPropertyValue>();
        for (PropertyValueType valueType : property.getPropertyValueTypes()) {
            IPropertyValue propertyValue = this.newPropertyValue(property, partId, valueType.getInterfaceClass());
            result.add(propertyValue);
        }
        return result;
    }

    public IIpsObjectPart newPropertyValue(String xmlTagName, String partId) {
        PropertyValueType propertyType = PropertyValueType.getTypeForXmlTag(xmlTagName);
        if (propertyType != null) {
            return this.newPropertyValue(partId, propertyType.getInterfaceClass());
        }
        if ("ConfigElement".equals(xmlTagName)) {
            return new LegacyConfigElement(this);
        }
        return null;
    }

    public <T extends IPropertyValue> T newPropertyValue(String partId, Class<T> type) {
        return this.newPropertyValue(null, partId, type);
    }

    public <T extends IPropertyValue> T newPropertyValue(IProductCmptProperty property, String partId, Class<T> clazz) {
        T propertyValue = PropertyValueType.createPropertyValue(this.getPropertyValueContainer(), property, partId, clazz);
        this.addPropertyValue((IPropertyValue)propertyValue);
        return propertyValue;
    }

    public boolean addPropertyValue(IPropertyValue value) {
        Class<? extends IPropertyValue> interfaceClass = value.getPropertyValueType().getInterfaceClass();
        List list = this.classToInstancesMap.get(interfaceClass);
        if (list.contains(value)) {
            return true;
        }
        return this.classToInstancesMap.putWithRuntimeCheck(interfaceClass, (Object)value) != null;
    }

    public boolean removePropertyValue(IPropertyValue value) {
        return this.classToInstancesMap.remove(value.getPropertyValueType().getInterfaceClass(), (Object)value);
    }

    public List<IPropertyValue> getAllPropertyValues() {
        return this.classToInstancesMap.values().stream().sorted(COMPARATOR).collect(Collectors.toList());
    }

    public void clear() {
        this.classToInstancesMap.clear();
    }

    public IPropertyValueContainer getPropertyValueContainer() {
        return this.propertyValueContainer;
    }
}

