/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ipsobject.AbstractFixDifferencesComposite;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.DatatypeMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.HiddenAttributeMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.InheritedLinkTemplateMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.InheritedPropertyTemplateMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.InheritedUndefinedLinkTemplateMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.InheritedUndefinedPropertyTemplateMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.LinkChangingOverTimeMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.LinkWithoutAssociationEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.MissingPropertyValueEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.MissingTemplateLinkEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.MultilingualMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.PropertyTypeMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.RemovedTemplateLinkEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.ValueHolderMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.ValueSetMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.ValueWithoutPropertyEntry;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.WrongRuntimeIdForLinkEntry;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpt.Cardinality;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IConfiguredValueSet;
import org.faktorips.devtools.model.productcmpt.IDeltaEntry;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainerToTypeDelta;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpttype.ITableStructureUsage;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.value.ValueType;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.util.ArgumentCheck;

public abstract class PropertyValueContainerToTypeDelta
extends AbstractFixDifferencesComposite
implements IPropertyValueContainerToTypeDelta {
    private final IIpsProject ipsProject;
    private final IPropertyValueContainer propertyValueContainer;
    private final IProductCmptType productCmptType;
    private final List<IDeltaEntry> entries = new ArrayList<IDeltaEntry>();
    private final IProductCmptLinkContainer linkContainer;

    public PropertyValueContainerToTypeDelta(IPropertyValueContainer propertyValueContainer, IProductCmptLinkContainer linkContainer, IIpsProject ipsProject) {
        this.linkContainer = linkContainer;
        ArgumentCheck.notNull((Object)propertyValueContainer);
        ArgumentCheck.notNull((Object)ipsProject);
        this.propertyValueContainer = propertyValueContainer;
        this.ipsProject = ipsProject;
        this.productCmptType = propertyValueContainer.findProductCmptType(ipsProject);
        if (this.productCmptType == null) {
            return;
        }
        this.createEntriesForProperties();
        this.createEntriesForLinks();
        if (this.getLinkContainer().isUsingTemplate()) {
            this.createEntriesForTemplateLinks();
        }
        this.createAdditionalEntriesAndChildren();
    }

    protected void createEntriesForLinks() {
        List<IProductCmptLink> links = this.getLinkContainer().getLinksAsList();
        for (IProductCmptLink link : links) {
            IProductCmptTypeAssociation association = (IProductCmptTypeAssociation)this.getProductCmptType().findAssociation(link.getAssociation(), this.getIpsProject());
            if (association == null) {
                LinkWithoutAssociationEntry linkWithoutAssociationEntry = new LinkWithoutAssociationEntry(link);
                this.addEntry(linkWithoutAssociationEntry);
            } else if (!link.getProductCmptLinkContainer().isContainerFor(association)) {
                LinkChangingOverTimeMismatchEntry entry = new LinkChangingOverTimeMismatchEntry(association, link);
                this.addEntry(entry);
            }
            IProductCmpt target = link.findTarget(this.ipsProject);
            if (target == null || Objects.equals(link.getTargetRuntimeId(), target.getRuntimeId())) continue;
            WrongRuntimeIdForLinkEntry entry = new WrongRuntimeIdForLinkEntry(link);
            this.addEntry(entry);
        }
    }

    public void createEntriesForTemplateLinks() {
        IProductCmptLinkContainer templateContainer = this.getLinkContainer().findTemplate(this.getIpsProject());
        if (templateContainer == null) {
            return;
        }
        for (IProductCmptLink templateLink : templateContainer.getLinksAsList()) {
            if (!this.isLinkAbsent(templateLink, this.getLinkContainer())) continue;
            this.addEntry(new MissingTemplateLinkEntry(templateLink, this.getLinkContainer()));
        }
        for (IProductCmptLink link : this.getLinkContainer().getLinksAsList()) {
            if (link.getTemplateValueStatus() != TemplateValueStatus.DEFINED && this.isLinkAbsent(link, templateContainer)) {
                this.addEntry(new RemovedTemplateLinkEntry(link));
            }
            this.checkInheritedFromTemplateMismatch(link);
        }
    }

    private void checkInheritedFromTemplateMismatch(IProductCmptLink link) {
        if (link.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
            Cardinality internalValue = (Cardinality)link.getInternalValueGetter().apply(link);
            IProductCmptLink templatePropertyValue = link.findTemplateProperty(this.ipsProject);
            if (templatePropertyValue != null) {
                Cardinality templateValue = templatePropertyValue.getCardinality();
                if (internalValue.compareTo(templateValue) != 0) {
                    IProductCmptTypeAssociation association = (IProductCmptTypeAssociation)this.getProductCmptType().findAssociation(link.getAssociation(), this.getIpsProject());
                    InheritedLinkTemplateMismatchEntry valueSetTemplateMismatchEntry = new InheritedLinkTemplateMismatchEntry(association, link, internalValue, templateValue);
                    this.addEntry(valueSetTemplateMismatchEntry);
                }
            } else {
                IProductCmptTypeAssociation association = (IProductCmptTypeAssociation)this.getProductCmptType().findAssociation(link.getAssociation(), this.getIpsProject());
                InheritedUndefinedLinkTemplateMismatchEntry undefinedLinkTemplateMismatchEntry = new InheritedUndefinedLinkTemplateMismatchEntry(association, link);
                this.addEntry(undefinedLinkTemplateMismatchEntry);
            }
        }
    }

    private boolean isLinkAbsent(IProductCmptLink templateLink, IProductCmptLinkContainer container) {
        return templateLink.getTemplateValueStatus() != TemplateValueStatus.UNDEFINED && this.matchingLinkIsMissing(templateLink, container);
    }

    private boolean matchingLinkIsMissing(IProductCmptLink linkToFind, IProductCmptLinkContainer container) {
        return !container.getLinksAsList(linkToFind.getAssociation()).stream().anyMatch(link -> link != null && Objects.equals(linkToFind.getTarget(), link.getTarget()));
    }

    protected IProductCmptLinkContainer getLinkContainer() {
        return this.linkContainer;
    }

    @Override
    public IIpsElement getCorrespondingIpsElement() {
        return this.propertyValueContainer;
    }

    protected abstract void createAdditionalEntriesAndChildren() throws IpsException;

    private void createEntriesForProperties() {
        Map<String, IProductCmptProperty> propertiesMap = ((ProductCmptType)this.productCmptType).findProductCmptPropertyMap(this.getIpsProject());
        this.checkForMissingPropertyValues(propertiesMap);
        this.checkForInconsistentPropertyValues(propertiesMap);
    }

    private void checkForMissingPropertyValues(Map<String, IProductCmptProperty> propertiesMap) {
        for (IProductCmptProperty property : propertiesMap.values()) {
            if (!this.propertyValueContainer.isContainerFor(property) || !this.propertyValueContainer.getPropertyValues(property.getPropertyName()).isEmpty()) continue;
            this.createMissingEntry(property);
        }
    }

    private void createMissingEntry(IProductCmptProperty property) {
        for (PropertyValueType type : property.getPropertyValueTypes()) {
            MissingPropertyValueEntry missingPropertyValueEntry = new MissingPropertyValueEntry(this.propertyValueContainer, property, type);
            this.addEntry(missingPropertyValueEntry);
        }
    }

    private void checkForInconsistentPropertyValues(Map<String, IProductCmptProperty> propertiesMap) {
        List<IPropertyValue> propertyValues = this.propertyValueContainer.getAllPropertyValues();
        for (IPropertyValue propertyValue : propertyValues) {
            IProductCmptProperty property = propertiesMap.get(propertyValue.getPropertyName());
            if (property == null || !this.propertyValueContainer.isContainerFor(property)) {
                ValueWithoutPropertyEntry valueWithoutPropertyEntry = new ValueWithoutPropertyEntry(propertyValue);
                this.addEntry(valueWithoutPropertyEntry);
                continue;
            }
            PropertyValueType propertyValueType = propertyValue.getPropertyValueType();
            this.checkInheritedFromTemplateMismatch(propertyValueType, property, propertyValue);
            if (!property.getPropertyValueTypes().contains((Object)propertyValueType)) {
                PropertyTypeMismatchEntry propertyTypeMismatchEntry = new PropertyTypeMismatchEntry(this.propertyValueContainer, property, propertyValue);
                this.addEntry(propertyTypeMismatchEntry);
                continue;
            }
            if (PropertyValueType.CONFIGURED_VALUESET.equals((Object)propertyValueType)) {
                this.checkForValueSetMismatch((IPolicyCmptTypeAttribute)property, (IConfiguredValueSet)propertyValue);
            }
            if (!PropertyValueType.ATTRIBUTE_VALUE.equals((Object)propertyValueType)) continue;
            this.checkForValueMismatch((IProductCmptTypeAttribute)property, (IAttributeValue)propertyValue);
            this.checkForMultilingualMismatch((IProductCmptTypeAttribute)property, (IAttributeValue)propertyValue);
            this.checkForHiddenAttributeMismatch((IProductCmptTypeAttribute)property, (IAttributeValue)propertyValue);
        }
        this.entries.addAll(DatatypeMismatchEntry.forEachMismatch(propertyValues));
    }

    private void checkInheritedFromTemplateMismatch(PropertyValueType propertyValueType, IProductCmptProperty property, IPropertyValue propertyValue) {
        if (propertyValue.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
            Object internalValue = propertyValueType.getInternalValueGetter().apply(propertyValue);
            IPropertyValue templatePropertyValue = propertyValue.findTemplateProperty(this.ipsProject);
            if (templatePropertyValue != null) {
                Object templateValue = propertyValueType.getValueGetter().apply(templatePropertyValue);
                Comparator<Object> valueComparator = propertyValueType.getValueComparator();
                if (valueComparator.compare(internalValue, templateValue) != 0) {
                    InheritedPropertyTemplateMismatchEntry valueSetTemplateMismatchEntry = new InheritedPropertyTemplateMismatchEntry(property, propertyValue, templatePropertyValue, internalValue, templateValue);
                    this.addEntry(valueSetTemplateMismatchEntry);
                }
            } else {
                InheritedUndefinedPropertyTemplateMismatchEntry undefinedPropertyTemplateMismatchEntry = new InheritedUndefinedPropertyTemplateMismatchEntry(property, propertyValue);
                this.addEntry(undefinedPropertyTemplateMismatchEntry);
            }
        }
    }

    private void checkForValueSetMismatch(IPolicyCmptTypeAttribute attribute, IConfiguredValueSet element) {
        IValueSet valueSet = element.getValueSet();
        if (attribute.getValueSet().isUnrestricted() || attribute.getValueSet().isDerived() || attribute.getValueSet().isStringLength() || element.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return;
        }
        if (!valueSet.isSameTypeOfValueSet(attribute.getValueSet())) {
            ValueSetMismatchEntry valueSetMismatchEntry = new ValueSetMismatchEntry(attribute, element);
            this.addEntry(valueSetMismatchEntry);
        }
    }

    void checkForValueMismatch(IProductCmptTypeAttribute attribute, IAttributeValue value) {
        if (attribute.isMultiValueAttribute() != value.getValueHolder().isMultiValue()) {
            this.addEntry(new ValueHolderMismatchEntry(value, attribute));
        }
    }

    private void checkForMultilingualMismatch(IProductCmptTypeAttribute attribute, IAttributeValue value) {
        if (attribute.isMultilingual() != value.getValueHolder().getValueType().equals((Object)ValueType.INTERNATIONAL_STRING)) {
            this.addEntry(new MultilingualMismatchEntry(value, attribute));
        }
    }

    protected void checkForHiddenAttributeMismatch(IProductCmptTypeAttribute attribute, IAttributeValue value) {
        HiddenAttributeMismatchEntry mismatchEntry = new HiddenAttributeMismatchEntry(value, attribute);
        if (mismatchEntry.isMismatch()) {
            this.addEntry(mismatchEntry);
        }
    }

    protected void addEntry(IDeltaEntry newEntry) {
        this.entries.add(newEntry);
    }

    @Override
    public IPropertyValueContainer getPropertyValueContainer() {
        return this.propertyValueContainer;
    }

    @Override
    public IProductCmptType getProductCmptType() {
        return this.productCmptType;
    }

    @Override
    protected boolean isEmptyThis() {
        return this.entries.isEmpty();
    }

    @Override
    public IDeltaEntry[] getEntries() {
        return this.entries.toArray(new IDeltaEntry[this.entries.size()]);
    }

    @Override
    public IDeltaEntry[] getEntries(DeltaType type) {
        ArrayList<IDeltaEntry> result = new ArrayList<IDeltaEntry>(this.entries.size());
        for (IDeltaEntry entry : this.entries) {
            if (!entry.getDeltaType().equals((Object)type)) continue;
            result.add(entry);
        }
        return result.toArray(new IDeltaEntry[result.size()]);
    }

    @Override
    protected void fix() {
        for (IDeltaEntry entry : this.entries) {
            entry.fix();
        }
    }

    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    class HierarchyVisitor
    extends TypeHierarchyVisitor<IProductCmptType> {
        private List<ITableStructureUsage> tableStructureUsages;
        private List<IProductCmptTypeAttribute> attributes;

        public HierarchyVisitor(IIpsProject ipsProject) {
            super(ipsProject);
            this.tableStructureUsages = new ArrayList<ITableStructureUsage>();
            this.attributes = new ArrayList<IProductCmptTypeAttribute>();
        }

        @Override
        protected boolean visit(IProductCmptType currentType) {
            List<ITableStructureUsage> tsu = currentType.getTableStructureUsages();
            for (ITableStructureUsage element : tsu) {
                this.tableStructureUsages.add(element);
            }
            List<IProductCmptTypeAttribute> attr = currentType.getProductCmptTypeAttributes();
            for (IProductCmptTypeAttribute element : attr) {
                this.attributes.add(element);
            }
            return true;
        }

        boolean containsTableStructureUsage(String rolename) {
            for (ITableStructureUsage tsu : this.tableStructureUsages) {
                if (!tsu.getRoleName().equals(rolename)) continue;
                return true;
            }
            return false;
        }

        boolean containsAttribute(String name) {
            for (IProductCmptTypeAttribute attribute : this.attributes) {
                if (!attribute.getName().equals(name)) continue;
                return true;
            }
            return false;
        }
    }
}

