/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.internal.productcmpt.AbstractValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.SingleValueHolderValidator;
import org.faktorips.devtools.model.internal.value.StringValue;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.AttributeValueType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IAttributeValueHolderFactory;
import org.faktorips.devtools.model.productcmpt.ISingleValueHolder;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.devtools.model.value.ValueFactory;
import org.faktorips.devtools.model.value.ValueType;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SingleValueHolder
extends AbstractValueHolder<IValue<?>>
implements ISingleValueHolder {
    public static final String DEFAULT_XML_TYPE_NAME = "SingleValue";
    private IValue<?> value;
    private final PropertyChangeListener propertyChangeListener = evt -> this.objectHasChanged(null, evt.getNewValue());

    public SingleValueHolder(IAttributeValue parent) {
        this(parent, SingleValueHolder.createValueInternal(parent));
    }

    public SingleValueHolder(IAttributeValue parent, String value) {
        this(parent, ValueFactory.createStringValue(value));
    }

    public SingleValueHolder(IAttributeValue parent, IValue<?> value) {
        super(parent);
        this.setValueInternal(value);
    }

    private static IValue<?> createValueInternal(IAttributeValue parent) {
        IProductCmptTypeAttribute attribute = SingleValueHolder.findAttribute(parent);
        if (attribute != null) {
            return ValueFactory.createValue(attribute.isMultilingual(), null);
        }
        return ValueFactory.createStringValue(null);
    }

    private static IProductCmptTypeAttribute findAttribute(IAttributeValue parent) {
        if (parent != null && parent.getIpsProject() != null) {
            return parent.findAttribute(parent.getIpsProject());
        }
        return null;
    }

    private void setValueInternal(IValue<?> value) {
        if (this.value != null) {
            this.value.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.value = value;
        if (this.value != null) {
            this.value.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    protected AttributeValueType getType() {
        return AttributeValueType.SINGLE_VALUE;
    }

    @Override
    public IValue<?> getValue() {
        return this.value;
    }

    @Override
    public void setValue(IValue<?> value) {
        IValue<?> oldValue = this.value;
        this.setValueInternal(value);
        this.objectHasChanged(oldValue, value);
    }

    @Override
    public List<IValue<?>> getValueList() {
        ArrayList result = new ArrayList(1);
        result.add((IValue<?>)this.getValue());
        return result;
    }

    @Override
    public void setValueList(List<IValue<?>> values) {
        if (values.isEmpty()) {
            this.setValue(new StringValue(null));
        } else if (values.size() == 1) {
            this.setValue(values.get(0));
        } else {
            throw new IllegalArgumentException("Cannot set multiple values in a SingleValueHolder");
        }
    }

    @Override
    public ValueType getValueType() {
        return ValueType.getValueType(this.getValue());
    }

    @Override
    public boolean isMultiValue() {
        return false;
    }

    @Override
    public MessageList validate(IIpsProject ipsProject) {
        return new SingleValueHolderValidator(this, this.getParent(), ipsProject).validate();
    }

    @Override
    protected void contentToXml(Element valueEl, Document doc) {
        if (this.value != null && this.value.getContent() != null) {
            valueEl.appendChild(this.value.toXml(doc));
        }
    }

    @Override
    public void initFromXml(Element element) {
        this.setValueInternal(ValueFactory.createValue(element));
    }

    @Override
    public String getStringValue() {
        if (this.value != null) {
            return this.value.getContentAsString();
        }
        return null;
    }

    @Override
    public boolean isNullValue() {
        boolean isNull = true;
        if (this.getValue() != null) {
            isNull = this.getValue().getContent() == null;
        }
        return isNull;
    }

    @Override
    protected SingleValueHolderValidator newValidator(IAttributeValue parent, IIpsProject ipsProject) {
        return new SingleValueHolderValidator(this, parent, ipsProject);
    }

    @Override
    public int compareTo(IValueHolder<IValue<?>> o) {
        if (o == null) {
            return -1;
        }
        if (this.equals(o)) {
            return 0;
        }
        if (this.value == null) {
            return ObjectUtils.compare(null, (Comparable)((Object)o.getStringValue()));
        }
        ValueDatatype datatype = this.getParent().findAttribute(this.getIpsProject()).findValueDatatype(this.getIpsProject());
        return this.value.compare(o.getValue(), datatype);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleValueHolder other = (SingleValueHolder)obj;
        return Objects.equals(this.value, other.value);
    }

    public static class Factory
    implements IAttributeValueHolderFactory<IValue<?>> {
        @Override
        public IValueHolder<IValue<?>> createValueHolder(IAttributeValue parent) {
            return new SingleValueHolder(parent);
        }

        @Override
        public IValueHolder<IValue<?>> createValueHolder(IAttributeValue parent, IValue<?> defaultValue) {
            return new SingleValueHolder(parent, defaultValue);
        }
    }
}

