/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.text.MessageFormat;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.InternationalString;
import org.faktorips.devtools.model.internal.productcmpt.IValueHolderValidator;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.SingleValueHolder;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.devtools.model.value.ValueType;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.values.LocalizedString;

public class SingleValueHolderValidator
implements IValueHolderValidator {
    private final SingleValueHolder valueHolder;
    private final IAttributeValue parent;
    private final IIpsProject ipsProject;
    private final ObjectProperty[] invalidObjectProperties;

    public SingleValueHolderValidator(SingleValueHolder valueHolder, IAttributeValue parent, IIpsProject ipsProject) {
        this.valueHolder = valueHolder;
        this.parent = parent;
        this.ipsProject = ipsProject;
        this.invalidObjectProperties = new ObjectProperty[]{new ObjectProperty((Object)parent, "valueHolder"), new ObjectProperty((Object)valueHolder, "value")};
    }

    @Override
    public MessageList validate() {
        MessageList messages = new MessageList();
        Object value = this.valueHolder.getValue();
        IProductCmptTypeAttribute attribute = this.parent.findAttribute(this.ipsProject);
        if (attribute == null || value == null) {
            return messages;
        }
        ValueDatatype datatype = attribute.findDatatype(this.ipsProject);
        value.validate(datatype, attribute.getDatatype(), this.ipsProject, messages, this.invalidObjectProperties);
        if (this.isMessageListNotEmptyBesidesMultilingualWarning(messages)) {
            return messages;
        }
        if (ValueType.STRING.equals((Object)this.valueHolder.getValueType())) {
            this.validateForValueTypeString(messages, (IValue<?>)value, attribute, datatype);
        } else if (ValueType.INTERNATIONAL_STRING.equals((Object)this.valueHolder.getValueType())) {
            this.validateForValueTypeInternationalString(messages, (IValue<?>)value, attribute);
        }
        return messages;
    }

    private void validateForValueTypeInternationalString(MessageList messages, IValue<?> value, IProductCmptTypeAttribute attribute) {
        if (!attribute.isMultilingual()) {
            String text = MessageFormat.format(Messages.AttributeValue_NotMultiLingual, this.parent.getAttribute());
            messages.newError("ATTRIBUTEVALUE-InvalidValueType", text, this.invalidObjectProperties);
        } else if (!attribute.getValueSet().isContainsNull()) {
            String nullPresentation = IIpsModelExtensions.get().getModelPreferences().getNullPresentation();
            InternationalString content = (InternationalString)value.getContent();
            for (LocalizedString localizedString : content.values()) {
                if (!IpsStringUtils.trimEquals((String)nullPresentation, (String)localizedString.getValue()) && !IpsStringUtils.isBlank((String)localizedString.getValue())) continue;
                String text = MessageFormat.format(Messages.AttributeValue_ValueEmptyOrNull, this.parent.getName(), this.getFormattedValue(localizedString.getValue()));
                messages.newError("ATTRIBUTEVALUE-ValueNotInSet", text, this.invalidObjectProperties);
                break;
            }
        }
    }

    private void validateForValueTypeString(MessageList messages, IValue<?> value, IProductCmptTypeAttribute attribute, ValueDatatype datatype) {
        String contentAsString;
        String contentValue;
        if (attribute.isMultilingual()) {
            String text = MessageFormat.format(Messages.AttributeValue_MultiLingual, this.parent.getAttribute());
            messages.newError("ATTRIBUTEVALUE-InvalidValueType", text, this.invalidObjectProperties);
        }
        String string = contentValue = IpsStringUtils.isBlank((String)(contentAsString = value.getContentAsString())) ? null : contentAsString;
        if (!attribute.getValueSet().containsValue(contentValue, this.ipsProject)) {
            String formattedValue = this.getFormattedValue(contentAsString, datatype);
            String text = attribute.getValueSet().getValueSetType() == ValueSetType.RANGE ? MessageFormat.format(Messages.AttributeValue_AllowedValuesAre, formattedValue, attribute.getValueSet().toShortString()) : MessageFormat.format(Messages.AttributeValue_ValueEmptyOrNull, this.parent.getName(), formattedValue);
            messages.newError("ATTRIBUTEVALUE-ValueNotInSet", text, this.invalidObjectProperties);
        }
    }

    private boolean isMessageListNotEmptyBesidesMultilingualWarning(MessageList messages) {
        return !messages.isEmpty() && messages.stream().filter(c -> !"ATTRIBUTEVALUE-MultilingualNotSet".equals(c.getCode())).count() > 0L;
    }

    private String getFormattedValue(String value, ValueDatatype datatype) {
        if (value != null && value.isBlank() && Datatype.STRING.equals((Object)datatype)) {
            return String.valueOf('\"') + value + '\"';
        }
        return IIpsModelExtensions.get().getModelPreferences().getDatatypeFormatter().formatValue(datatype, value);
    }

    private String getFormattedValue(String value) {
        return value != null && value.isBlank() ? String.valueOf('\"') + value + '\"' : value;
    }
}

