/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.model.internal.productcmpt.AbstractSimplePropertyValue;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueFinder;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueSettings;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.ITableContentUsage;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.ITableStructureUsage;
import org.faktorips.devtools.model.tablecontents.ITableContents;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableContentUsage
extends AbstractSimplePropertyValue
implements ITableContentUsage {
    public static final String TAG_NAME = "TableContentUsage";
    private String tableContentName = "";
    private String structureUsage = "";
    private final TemplateValueSettings templateValueSettings;

    public TableContentUsage(IPropertyValueContainer parent, String id) {
        this(parent, id, "");
    }

    public TableContentUsage(IPropertyValueContainer parent, String id, String structureUsage) {
        super(parent, id);
        this.structureUsage = structureUsage;
        this.templateValueSettings = new TemplateValueSettings(this);
    }

    @Override
    public String getPropertyName() {
        return this.structureUsage;
    }

    @Override
    public IProductCmptProperty findProperty(IIpsProject ipsProject) {
        return this.findTableStructureUsage(ipsProject);
    }

    @Override
    public PropertyValueType getPropertyValueType() {
        return PropertyValueType.TABLE_CONTENT_USAGE;
    }

    @Override
    public String getPropertyValue() {
        return this.getTableContentName();
    }

    @Override
    public IProductCmpt getProductCmpt() {
        return this.getPropertyValueContainer().getProductCmpt();
    }

    private IProductCmptType getProductCmptType(IIpsProject ipsProject) {
        return this.getPropertyValueContainer().findProductCmptType(ipsProject);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    public void setStructureUsage(String structureUsage) {
        this.structureUsage = structureUsage;
        this.objectHasChanged();
    }

    @Override
    public String getStructureUsage() {
        return this.structureUsage;
    }

    @Override
    public void setTableContentName(String tableContentName) {
        this.tableContentName = tableContentName;
        this.objectHasChanged();
    }

    @Override
    public String getName() {
        return this.getTableContentName();
    }

    @Override
    public String getTableContentName() {
        if (this.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
            return this.findTemplateTableContentName();
        }
        if (this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return "";
        }
        return this.tableContentName;
    }

    public String getInternalTableContentName() {
        return this.tableContentName;
    }

    private String findTemplateTableContentName() {
        ITableContentUsage templateContentUsage = this.findTemplateProperty(this.getIpsProject());
        if (templateContentUsage == null) {
            return this.tableContentName;
        }
        return templateContentUsage.getTableContentName();
    }

    @Override
    public ITableContents findTableContents(IIpsProject ipsProject) {
        return (ITableContents)ipsProject.findIpsObject(IpsObjectType.TABLE_CONTENTS, this.getTableContentName());
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        String tableContentNameToValidate = this.getTableContentName();
        IProductCmptType type = this.getProductCmptType(ipsProject);
        if (type == null) {
            list.add(new Message("TABLECONTENT-USAGENoProductCmptType", Messages.TableContentUsage_msgNoType, Message.WARNING, (Object)this));
            return;
        }
        ITableStructureUsage tsu = type.findTableStructureUsage(this.structureUsage, ipsProject);
        if (tsu == null) {
            String text = MessageFormat.format(Messages.TableContentUsage_msgUnknownStructureUsage, this.structureUsage);
            list.add(new Message("TABLECONTENT-USAGEUnknownStructureUsage", text, Message.ERROR, (Object)this, new String[]{"structureUsage"}));
            return;
        }
        list.add(this.templateValueSettings.validate(this, ipsProject));
        ITableContents content = null;
        if (tableContentNameToValidate != null) {
            content = this.findTableContents(ipsProject);
        }
        if (content == null) {
            if (!this.isNullContentAllowed(tsu)) {
                String text = MessageFormat.format(Messages.TableContentUsage_msgUnknownTableContent, tableContentNameToValidate);
                list.add(new Message("TABLECONTENT-USAGEUnknownTableContent", text, Message.ERROR, (Object)this, new String[]{"tableContentName"}));
            }
            return;
        }
        String usedStructure = content.getTableStructure();
        if (!tsu.isUsed(usedStructure)) {
            String text = MessageFormat.format(Messages.TableContentUsage_msgInvalidTableContent, tableContentNameToValidate, usedStructure, this.structureUsage);
            list.add(new Message("TABLECONTENT-USAGEInvalidTableContent", text, Message.ERROR, (Object)this, new String[]{"tableContentName"}));
        }
    }

    private boolean isNullContentAllowed(ITableStructureUsage tsu) {
        if (this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return true;
        }
        return IpsStringUtils.isEmpty((String)this.getTableContentName()) && !tsu.isMandatoryTableContent();
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.structureUsage = element.getAttribute("structureUsage");
        this.tableContentName = ValueToXmlHelper.getValueFromElement((Element)element, (String)"TableContentName");
        this.templateValueSettings.initPropertiesFromXml(element);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("structureUsage", this.structureUsage);
        ValueToXmlHelper.addValueToElement((String)this.getTableContentName(), (Element)element, (String)"TableContentName");
        this.templateValueSettings.propertiesToXml(element);
    }

    @Override
    public ITableStructureUsage findTableStructureUsage(IIpsProject ipsProject) {
        IProductCmptType type = this.getProductCmptType(ipsProject);
        if (type == null) {
            return null;
        }
        return type.findTableStructureUsage(this.structureUsage, ipsProject);
    }

    @Override
    public String getCaption(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        ITableStructureUsage currentStructureUsage = this.findTableStructureUsage(this.getIpsProject());
        if (currentStructureUsage != null) {
            return currentStructureUsage.getLabelValue(locale);
        }
        return null;
    }

    @Override
    public String getLastResortCaption() {
        return StringUtils.capitalize((String)this.structureUsage);
    }

    @Override
    public void setTemplateValueStatus(TemplateValueStatus newStatus) {
        if (newStatus == TemplateValueStatus.DEFINED) {
            this.tableContentName = this.getTableContentName();
        }
        TemplateValueStatus oldStatus = this.templateValueSettings.getStatus();
        this.templateValueSettings.setStatus(newStatus);
        this.objectHasChanged(new PropertyChangeEvent(this, "templateValueStatus", (Object)oldStatus, (Object)newStatus));
    }

    @Override
    public TemplateValueStatus getTemplateValueStatus() {
        return this.templateValueSettings.getStatus();
    }

    @Override
    public ITableContentUsage findTemplateProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.findTemplateValue(this, ITableContentUsage.class);
    }

    @Override
    public boolean hasTemplateForProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.hasTemplateForValue(this, ITableContentUsage.class);
    }
}

