/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.beans.PropertyChangeEvent;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.model.internal.productcmpt.AbstractSimplePropertyValue;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueFinder;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueSettings;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.IValidationRuleConfig;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ValidationRuleConfig
extends AbstractSimplePropertyValue
implements IValidationRuleConfig {
    public static final String TAG_NAME = "ValidationRuleConfig";
    public static final String TAG_NAME_ACTIVE = "active";
    public static final String TAG_NAME_RULE_NAME = "ruleName";
    private boolean isActive = false;
    private String validationRuleName;
    private final TemplateValueSettings templateValueSettings;

    public ValidationRuleConfig(IPropertyValueContainer parent, String id, String ruleName) {
        super(parent, id);
        this.validationRuleName = ruleName;
        this.templateValueSettings = new TemplateValueSettings(this);
    }

    @Override
    public boolean isActive() {
        if (this.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
            return this.findTemplateActiveState();
        }
        if (this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return false;
        }
        return this.isActive;
    }

    public boolean isActiveInternal() {
        return this.isActive;
    }

    private boolean findTemplateActiveState() {
        IValidationRuleConfig template = this.findTemplateProperty(this.getIpsProject());
        if (template == null) {
            return this.isActive;
        }
        return template.isActive();
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.validationRuleName = element.getAttribute(TAG_NAME_RULE_NAME);
        this.isActive = XmlUtil.getBooleanAttributeOrFalse(element, TAG_NAME_ACTIVE);
        this.templateValueSettings.initPropertiesFromXml(element);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute(TAG_NAME_RULE_NAME, this.validationRuleName);
        if (this.isActive()) {
            element.setAttribute(TAG_NAME_ACTIVE, Boolean.toString(this.isActive()));
        }
        this.templateValueSettings.propertiesToXml(element);
    }

    @Override
    public IValidationRule findValidationRule(IIpsProject ipsProject) {
        IPropertyValueContainer propertyValueContainer = (IPropertyValueContainer)this.getParent();
        IPolicyCmptType pcType = propertyValueContainer.findPolicyCmptType(ipsProject);
        if (pcType != null) {
            return pcType.findValidationRule(this.validationRuleName, ipsProject);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.validationRuleName;
    }

    @Override
    public void setValidationRuleName(String validationRuleName) {
        String oldValue = this.validationRuleName;
        this.validationRuleName = validationRuleName;
        this.valueChanged(oldValue, validationRuleName);
    }

    @Override
    public String getValidationRuleName() {
        return this.validationRuleName;
    }

    @Override
    public void setActive(boolean active) {
        boolean oldValue = this.isActive;
        this.isActive = active;
        this.valueChanged(oldValue, active);
    }

    @Override
    public String getCaption(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        String caption = null;
        IValidationRule rule = this.findValidationRule(this.getIpsProject());
        if (rule != null) {
            caption = rule.getLabelValue(locale);
        }
        return caption;
    }

    @Override
    public String getLastResortCaption() {
        return StringUtils.capitalize((String)this.validationRuleName);
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public IProductCmptProperty findProperty(IIpsProject ipsProject) {
        return this.findValidationRule(ipsProject);
    }

    @Override
    public PropertyValueType getPropertyValueType() {
        return PropertyValueType.VALIDATION_RULE_CONFIG;
    }

    @Override
    public Boolean getPropertyValue() {
        return this.isActive();
    }

    @Override
    public void setTemplateValueStatus(TemplateValueStatus newStatus) {
        if (newStatus == TemplateValueStatus.DEFINED) {
            this.isActive = this.isActive();
        }
        TemplateValueStatus oldStatus = this.templateValueSettings.getStatus();
        this.templateValueSettings.setStatus(newStatus);
        this.objectHasChanged(new PropertyChangeEvent(this, "templateValueStatus", (Object)oldStatus, (Object)newStatus));
    }

    @Override
    public TemplateValueStatus getTemplateValueStatus() {
        return this.templateValueSettings.getStatus();
    }

    @Override
    public IValidationRuleConfig findTemplateProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.findTemplateValue(this, IValidationRuleConfig.class);
    }

    @Override
    public boolean hasTemplateForProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.hasTemplateForValue(this, IValidationRuleConfig.class);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        list.add(this.templateValueSettings.validate(this, ipsProject));
    }
}

