/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForProperty;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.ValueConverter;
import org.faktorips.devtools.model.internal.value.StringValue;
import org.faktorips.devtools.model.internal.valueset.EnumValueSet;
import org.faktorips.devtools.model.internal.valueset.RangeValueSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IConfiguredDefault;
import org.faktorips.devtools.model.productcmpt.IConfiguredValueSet;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.devtools.model.valueset.IValueSet;

public class DatatypeMismatchEntry
extends AbstractDeltaEntryForProperty {
    private final List<String> oldValues;
    private final ValueConverter converter;
    private final Consumer<List<String>> valueConsumer;

    DatatypeMismatchEntry(IPropertyValue propertyValue, List<String> oldValues, ValueConverter converter, Consumer<List<String>> valueConsumer) {
        super(propertyValue);
        this.oldValues = oldValues;
        this.converter = converter;
        this.valueConsumer = valueConsumer;
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.DATATYPE_MISMATCH;
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(Messages.DatatypeMismatchEntry_datatypeMissmatchDescription, String.join((CharSequence)", ", this.oldValues), String.join((CharSequence)", ", this.convertedValues()));
    }

    @Override
    public void fix() {
        List<String> converted = this.convertedValues();
        this.valueConsumer.accept(converted);
    }

    private List<String> convertedValues() {
        return this.oldValues.stream().map(input -> this.converter.convert((String)input, this.getPropertyValue().getIpsProject())).collect(Collectors.toList());
    }

    public static List<DatatypeMismatchEntry> forEachMismatch(List<? extends IPropertyValue> values) {
        return values.stream().map(DatatypeMismatchEntry::createPossibleMismatch).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Optional<DatatypeMismatchEntry> createPossibleMismatch(IPropertyValue propertyValue) {
        ValueDatatype datatype;
        ValueConverter converter;
        if (DatatypeMismatchEntry.isConversionNeeded(propertyValue) && (converter = ValueConverter.getByTargetType(datatype = DatatypeMismatchEntry.findDatatype(propertyValue))) != null) {
            Optional<DatatypeMismatch<IPropertyValue>> mismatch = DatatypeMismatchEntry.createMismatch(propertyValue);
            Function<DatatypeMismatch, DatatypeMismatchEntry> datatypeMismatchEntry = dataTypeMismatch -> new DatatypeMismatchEntry(propertyValue, dataTypeMismatch.getValues(), converter, dataTypeMismatch.getValueConsumer());
            return mismatch.map(datatypeMismatchEntry);
        }
        return Optional.empty();
    }

    private static boolean isConversionNeeded(IPropertyValue attributeValue) {
        try {
            return attributeValue.validate(attributeValue.getIpsProject()).getMessageByCode("ValueIsNotInstanceOfValueDatatype") != null;
        }
        catch (IpsException e) {
            return false;
        }
    }

    private static ValueDatatype findDatatype(IPropertyValue attributeValue) {
        IIpsProject ipsProject = attributeValue.getIpsProject();
        IProductCmptProperty property = attributeValue.findProperty(ipsProject);
        String datatype = property.getPropertyDatatype();
        return ipsProject.findValueDatatype(datatype);
    }

    /*
     * WARNING - void declaration
     */
    private static <P extends IPropertyValue> Optional<DatatypeMismatch<P>> createMismatch(P propertyValue) {
        if (propertyValue instanceof IAttributeValue) {
            return Optional.of(new AttributeValueDatatypeMismatch((IAttributeValue)propertyValue));
        }
        if (propertyValue instanceof IConfiguredDefault) {
            return Optional.of(new ConfiguredDefaultDatatypeMismatch((IConfiguredDefault)propertyValue));
        }
        P p = propertyValue;
        if (p instanceof IConfiguredValueSet) {
            void configuredValueSet;
            IConfiguredValueSet iConfiguredValueSet = (IConfiguredValueSet)p;
            IConfiguredValueSet cfr_ignored_0 = (IConfiguredValueSet)p;
            IValueSet valueSet = configuredValueSet.getValueSet();
            if (valueSet.isEnum()) {
                return Optional.of(new EnumValueSetDatatypeMismatch((IConfiguredValueSet)configuredValueSet));
            }
            if (valueSet.isRange()) {
                return Optional.of(new RangeValueSetDatatypeMismatch((IConfiguredValueSet)configuredValueSet));
            }
        }
        return Optional.empty();
    }

    private static class AttributeValueDatatypeMismatch
    extends DatatypeMismatch<IAttributeValue> {
        public AttributeValueDatatypeMismatch(IAttributeValue attributeValue) {
            super(attributeValue);
        }

        @Override
        public List<String> getValues() {
            List<IValue<?>> valueList = ((IAttributeValue)this.getPropertyValue()).getValueHolder().getValueList();
            return valueList.stream().map(IValue::getContentAsString).collect(Collectors.toList());
        }

        @Override
        public Consumer<List<String>> getValueConsumer() {
            return t -> {
                List<IValue<?>> newValueList = t.stream().map(StringValue::new).collect(Collectors.toList());
                ((IAttributeValue)this.getPropertyValue()).getValueHolder().setValueList(newValueList);
            };
        }
    }

    private static class ConfiguredDefaultDatatypeMismatch
    extends DatatypeMismatch<IConfiguredDefault> {
        public ConfiguredDefaultDatatypeMismatch(IConfiguredDefault propertyValue) {
            super(propertyValue);
        }

        @Override
        public List<String> getValues() {
            return Collections.singletonList(((IConfiguredDefault)this.getPropertyValue()).getValue());
        }

        @Override
        public Consumer<List<String>> getValueConsumer() {
            return t -> ((IConfiguredDefault)this.getPropertyValue()).setValue((String)t.get(0));
        }
    }

    private static abstract class ConfiguredValueSetDatatypeMismatch<S extends IValueSet>
    extends DatatypeMismatch<IConfiguredValueSet> {
        private final S valueSet;

        public ConfiguredValueSetDatatypeMismatch(IConfiguredValueSet propertyValue) {
            super(propertyValue);
            this.valueSet = propertyValue.getValueSet();
        }

        public S getValueSet() {
            return this.valueSet;
        }
    }

    private static abstract class DatatypeMismatch<P extends IPropertyValue> {
        private final P propertyValue;

        public DatatypeMismatch(P propertyValue) {
            this.propertyValue = propertyValue;
        }

        public P getPropertyValue() {
            return this.propertyValue;
        }

        public abstract List<String> getValues();

        public abstract Consumer<List<String>> getValueConsumer();
    }

    private static class EnumValueSetDatatypeMismatch
    extends ConfiguredValueSetDatatypeMismatch<EnumValueSet> {
        public EnumValueSetDatatypeMismatch(IConfiguredValueSet propertyValue) {
            super(propertyValue);
        }

        @Override
        public List<String> getValues() {
            return Arrays.asList(((EnumValueSet)this.getValueSet()).getValues());
        }

        @Override
        public Consumer<List<String>> getValueConsumer() {
            return values -> {
                int i = 0;
                for (String value : values) {
                    ((EnumValueSet)this.getValueSet()).setValue(i++, value);
                }
            };
        }
    }

    private static class RangeValueSetDatatypeMismatch
    extends ConfiguredValueSetDatatypeMismatch<RangeValueSet> {
        public RangeValueSetDatatypeMismatch(IConfiguredValueSet propertyValue) {
            super(propertyValue);
        }

        @Override
        public List<String> getValues() {
            String lowerBound = ((RangeValueSet)this.getValueSet()).getLowerBound();
            String upperBound = ((RangeValueSet)this.getValueSet()).getUpperBound();
            String step = ((RangeValueSet)this.getValueSet()).getStep();
            return Arrays.asList(lowerBound, upperBound, step);
        }

        @Override
        public Consumer<List<String>> getValueConsumer() {
            return t -> {
                ((RangeValueSet)this.getValueSet()).setUpperBound((String)t.get(1));
                ((RangeValueSet)this.getValueSet()).setLowerBound((String)t.get(0));
                ((RangeValueSet)this.getValueSet()).setStep((String)t.get(2));
            };
        }
    }
}

