/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForProperty;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.productcmpt.AttributeValueType;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.devtools.model.value.ValueFactory;
import org.faktorips.util.ArgumentCheck;

public class HiddenAttributeMismatchEntry
extends AbstractDeltaEntryForProperty {
    private IProductCmptTypeAttribute attribute;

    public HiddenAttributeMismatchEntry(IAttributeValue attributeValue, IProductCmptTypeAttribute attribute) {
        super(attributeValue);
        this.attribute = attribute;
        ArgumentCheck.notNull((Object)attributeValue);
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.HIDDEN_ATTRIBUTE_MISMATCH;
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(Messages.HiddenAttributeMismatchEntry_desc, this.getPropertyName(), this.getCurrentAttributeValue(), this.attribute.getDefaultValue());
    }

    public String getCurrentAttributeValue() {
        return this.getAttributeValue().getValueHolder().getStringValue();
    }

    private IAttributeValue getAttributeValue() {
        return (IAttributeValue)this.getPropertyValue();
    }

    @Override
    public void fix() {
        this.setAttributeValueToDefault();
    }

    private void setAttributeValueToDefault() {
        IAttributeValue attributeValue = this.getAttributeValue();
        attributeValue.setValueHolder(this.createDefaultValueHolder());
    }

    private IValueHolder<?> createDefaultValueHolder() {
        IValue<?> defaultValue = ValueFactory.createValue(this.attribute.isMultilingual(), this.attribute.getDefaultValue());
        return this.createValueHolderFor(defaultValue);
    }

    private IValueHolder<?> createValueHolderFor(IValue<?> defaultValue) {
        AttributeValueType attributeValueType = AttributeValueType.getTypeFor(this.attribute);
        return attributeValueType.newHolderInstance(this.getAttributeValue(), defaultValue);
    }

    public boolean isMismatch() {
        return this.isAttributeHidden() && this.valuesDiffer();
    }

    private boolean valuesDiffer() {
        IAttributeValue attributeValue = this.getAttributeValue();
        IValueHolder<?> valueHolder = this.createDefaultValueHolder();
        return attributeValue.getValueHolder() == null || !attributeValue.getValueHolder().equalsValueHolder(valueHolder);
    }

    private boolean isAttributeHidden() {
        return !this.attribute.isVisible();
    }
}

