/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import java.util.function.Function;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForProperty;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.type.IProductCmptProperty;

public class InheritedPropertyTemplateMismatchEntry
extends AbstractDeltaEntryForProperty {
    private IProductCmptProperty property;
    private IPropertyValue propertyValue;
    private IPropertyValue templatePropertyValue;
    private Object internalValue;
    private Object templateValue;
    private PropertyValueType propertyValueType;

    public InheritedPropertyTemplateMismatchEntry(IProductCmptProperty property, IPropertyValue propertyValue, IPropertyValue templatePropertyValue, Object internalValue, Object templateValue) {
        super(propertyValue);
        this.property = property;
        this.propertyValue = propertyValue;
        this.templatePropertyValue = templatePropertyValue;
        this.internalValue = internalValue;
        this.templateValue = templateValue;
        this.propertyValueType = propertyValue.getPropertyValueType();
    }

    @Override
    public void fix() {
        this.propertyValueType.copyValue(this.templatePropertyValue, this.propertyValue);
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.INHERITED_TEMPLATE_MISMATCH;
    }

    @Override
    public String getDescription() {
        Function<Object, String> valueToString = this.propertyValueType.getValueToString();
        return MessageFormat.format(Messages.InheritedTemplateMismatchEntry_desc, IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(this.property), valueToString.apply(this.internalValue), valueToString.apply(this.templateValue));
    }
}

