/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptGeneration;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsObjectGeneration;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IDeltaEntry;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;

public class InvalidGenerationsDeltaEntry
implements IDeltaEntry {
    private IProductCmpt productCmpt;

    public InvalidGenerationsDeltaEntry(IProductCmpt productCmpt) {
        this.productCmpt = productCmpt;
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.INVALID_GENERATIONS;
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(Messages.InvalidGenerationsDeltaEntry_description, IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNamePlural(true));
    }

    @Override
    public void fix() {
        IIpsObjectGeneration[] generationsOrderedByValidDate = this.productCmpt.getGenerationsOrderedByValidDate();
        int i = 1;
        while (i < generationsOrderedByValidDate.length) {
            generationsOrderedByValidDate[i].delete();
            ++i;
        }
    }

    public Class<ProductCmptGeneration> getPartType() {
        return ProductCmptGeneration.class;
    }
}

