/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForLinks;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.util.StringUtil;

public class LinkChangingOverTimeMismatchEntry
extends AbstractDeltaEntryForLinks {
    private final IProductCmptTypeAssociation association;
    private final String unqualifiedTargetName;

    public LinkChangingOverTimeMismatchEntry(IProductCmptTypeAssociation association, IProductCmptLink link) {
        super(link);
        this.association = association;
        this.unqualifiedTargetName = StringUtil.unqualifiedName((String)link.getTarget());
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.LINK_CHANGING_OVER_TIME_MISMATCH;
    }

    @Override
    public String getDescription() {
        String linkCaption = IIpsModel.get().getMultiLanguageSupport().getLocalizedCaption(this.getLink());
        String generationLabelByNamingConvention = IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNameSingular(true);
        if (this.getAssociation().isChangingOverTime()) {
            return MessageFormat.format(Messages.LinkChangingOverTimeMismatchEntry_Description_GenToProdCmpt, linkCaption, this.unqualifiedTargetName, generationLabelByNamingConvention);
        }
        if (this.isLinkPartOfLatestGeneration()) {
            return MessageFormat.format(Messages.LinkChangingOverTimeMismatchEntry_Description_ProdCmptToGen, linkCaption, this.unqualifiedTargetName);
        }
        return MessageFormat.format(Messages.LinkChangingOverTimeMismatchEntry_Description_RemoveOnly, linkCaption, this.unqualifiedTargetName, generationLabelByNamingConvention);
    }

    @Override
    public void fix() {
        if (this.getAssociation().isChangingOverTime()) {
            this.moveLinkToAllGenerations();
        } else {
            this.moveLatestGenerationLinksToProdCmpt();
        }
        this.getLink().delete();
    }

    private void moveLinkToAllGenerations() {
        IProductCmptLinkContainer productCmpt = this.getLink().getProductCmptLinkContainer();
        for (IProductCmptGeneration gen : productCmpt.getProductCmpt().getProductCmptGenerations()) {
            IProductCmptLink newLink = gen.newLink(this.getAssociation());
            newLink.copyFrom(this.getLink());
        }
    }

    private void moveLatestGenerationLinksToProdCmpt() {
        if (this.isLinkPartOfLatestGeneration()) {
            IProductCmptLink newLink = this.getLink().getProductCmpt().newLink(this.getAssociation());
            newLink.copyFrom(this.getLink());
        }
    }

    private boolean isLinkPartOfLatestGeneration() {
        IProductCmptGeneration latestGeneration = this.getLink().getProductCmpt().getLatestProductCmptGeneration();
        return this.getLink().getProductCmptLinkContainer().equals(latestGeneration);
    }

    protected IProductCmptTypeAssociation getAssociation() {
        return this.association;
    }
}

