/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForProperty;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.ValueWithoutPropertyEntry;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.type.IProductCmptProperty;

public class MissingPropertyValueEntry
extends AbstractDeltaEntryForProperty {
    private final IProductCmptProperty property;
    private final IPropertyValueContainer propertyValueContainer;
    private final PropertyValueType type;
    private ValueWithoutPropertyEntry predecessor;

    public MissingPropertyValueEntry(IPropertyValueContainer propertyValueContainer, IProductCmptProperty property, PropertyValueType type) {
        super(null);
        this.propertyValueContainer = propertyValueContainer;
        this.property = property;
        this.type = type;
    }

    @Override
    public PropertyValueType getPropertyType() {
        return this.type;
    }

    @Override
    public String getPropertyName() {
        return this.property.getPropertyName();
    }

    @Override
    public String getDescription() {
        StringBuilder description = new StringBuilder(IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(this.property));
        description.append(" (");
        description.append(this.getLocalizedLabel(this.getPropertyType()));
        description.append(')');
        if (this.hasPredecessorValue()) {
            IPropertyValueContainer predecessorContainer = this.getPredecessor().getPropertyValue().getPropertyValueContainer();
            String name = predecessorContainer.getName();
            if (predecessorContainer instanceof IProductCmptGeneration) {
                name = String.valueOf(IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNameSingular()) + ' ' + name;
            }
            description.append(MessageFormat.format(Messages.MissingPropertyValueEntry_valueTransferedInformation, name));
        }
        return description.toString();
    }

    private String getLocalizedLabel(PropertyValueType propertyType) {
        return switch (propertyType) {
            case PropertyValueType.ATTRIBUTE_VALUE -> Messages.MissingPropertyValueEntry_ATTRIBUTE_VALUE;
            case PropertyValueType.CONFIGURED_DEFAULT -> Messages.MissingPropertyValueEntry_CONFIGURED_DEFAULT;
            case PropertyValueType.CONFIGURED_VALUESET -> Messages.MissingPropertyValueEntry_CONFIGURED_VALUESET;
            case PropertyValueType.FORMULA -> Messages.MissingPropertyValueEntry_FORMULA;
            case PropertyValueType.TABLE_CONTENT_USAGE -> Messages.MissingPropertyValueEntry_TABLE_CONTENT_USAGE;
            case PropertyValueType.VALIDATION_RULE_CONFIG -> Messages.MissingPropertyValueEntry_VALIDATION_RULE_CONFIG;
            default -> throw new IllegalStateException("Unknown property type: " + (Object)((Object)propertyType));
        };
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.MISSING_PROPERTY_VALUE;
    }

    public void setPredecessor(ValueWithoutPropertyEntry predecessor) {
        this.predecessor = predecessor;
    }

    public AbstractDeltaEntryForProperty getPredecessor() {
        return this.predecessor;
    }

    @Override
    public void fix() {
        IPropertyValue newPropertyValue = this.propertyValueContainer.newPropertyValue(this.property, this.type.getInterfaceClass());
        if (this.hasPredecessorValue()) {
            IPropertyValue predecessorValue = this.getPredecessor().getPropertyValue();
            newPropertyValue.copyFrom(predecessorValue);
        }
    }

    private boolean hasPredecessorValue() {
        return this.getPredecessor() != null && this.getPredecessor().getPropertyValue() != null;
    }
}

