/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForLinks;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.util.StringUtil;

public class MissingTemplateLinkEntry
extends AbstractDeltaEntryForLinks {
    private final IProductCmptLinkContainer linkContainer;

    public MissingTemplateLinkEntry(IProductCmptLink missingLink, IProductCmptLinkContainer linkContainer) {
        super(missingLink);
        this.linkContainer = linkContainer;
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.MISSING_TEMPLATE_LINK;
    }

    @Override
    public String getDescription() {
        String linkCaption = IIpsModel.get().getMultiLanguageSupport().getLocalizedCaption(this.getLink());
        String linkTarget = StringUtil.unqualifiedName((String)this.getLink().getTarget());
        String templateName = this.getLink().getProductCmpt().getName();
        return MessageFormat.format(Messages.MissingTemplateLinkEntry_missingTemplateLink, linkCaption, linkTarget, templateName);
    }

    @Override
    public void fix() {
        IProductCmptLink newLink = this.linkContainer.newLink(this.getLink().getAssociation());
        newLink.setTarget(this.getLink().getTarget());
        newLink.setTemplateValueStatus(TemplateValueStatus.INHERITED);
    }
}

