/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import org.faktorips.devtools.model.internal.InternationalString;
import org.faktorips.devtools.model.internal.productcmpt.MultiValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.SingleValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForProperty;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.internal.value.InternationalStringValue;
import org.faktorips.devtools.model.internal.value.StringValue;
import org.faktorips.devtools.model.ipsproject.ISupportedLanguage;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.ISingleValueHolder;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.devtools.model.value.ValueType;
import org.faktorips.values.LocalizedString;

public class MultilingualMismatchEntry
extends AbstractDeltaEntryForProperty {
    private final IProductCmptTypeAttribute attribute;
    private final Locale defaultLanguageLocale;

    public MultilingualMismatchEntry(IAttributeValue attributeValue, IProductCmptTypeAttribute attribute) {
        super(attributeValue);
        this.attribute = attribute;
        this.defaultLanguageLocale = this.getDefaultLanguage();
    }

    private Locale getDefaultLanguage() {
        ISupportedLanguage supportedLanguage = this.getPropertyValue().getIpsProject().getReadOnlyProperties().getDefaultLanguage();
        return supportedLanguage.getLocale();
    }

    @Override
    public IAttributeValue getPropertyValue() {
        return (IAttributeValue)super.getPropertyValue();
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.MULTILINGUAL_MISMATCH;
    }

    @Override
    public String getDescription() {
        String defaultLanguage = this.defaultLanguageLocale.getDisplayLanguage();
        String msg = this.attribute.isMultilingual() ? Messages.MultilingualMismatchEntry_convertToInternatlStringValue : Messages.MultilingualMismatchEntry_convertToStringValue;
        return MessageFormat.format(msg, this.getPropertyName(), defaultLanguage);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fix() {
        IValueHolder<?> value = this.getPropertyValue().getValueHolder();
        IValueHolder<?> iValueHolder = value;
        if (iValueHolder instanceof MultiValueHolder) {
            void multiValue;
            MultiValueHolder multiValueHolder = (MultiValueHolder)iValueHolder;
            MultiValueHolder cfr_ignored_0 = (MultiValueHolder)iValueHolder;
            Iterator iterator = multiValue.getValue().iterator();
            while (iterator.hasNext()) {
                ISingleValueHolder valueHolder = (ISingleValueHolder)iterator.next();
                this.setNewValueInSingleValueHolder(valueHolder);
            }
        } else {
            IValueHolder<?> iValueHolder2 = value;
            if (iValueHolder2 instanceof SingleValueHolder) {
                SingleValueHolder valueHolder = (SingleValueHolder)iValueHolder2;
                SingleValueHolder cfr_ignored_1 = (SingleValueHolder)iValueHolder2;
                this.setNewValueInSingleValueHolder(valueHolder);
            }
        }
    }

    private void setNewValueInSingleValueHolder(ISingleValueHolder valueHolder) {
        ValueType valueType = valueHolder.getValueType();
        if (ValueType.STRING.equals((Object)valueType)) {
            this.setNewInternationalStringValue(valueHolder);
        } else if (ValueType.INTERNATIONAL_STRING.equals((Object)valueType)) {
            this.setNewStringValue(valueHolder);
        }
    }

    private void setNewInternationalStringValue(ISingleValueHolder valueHolder) {
        String oldStringValue;
        InternationalStringValue newInternationalStringValue = new InternationalStringValue();
        if (valueHolder.getValue() != null && (oldStringValue = (String)((IValue)valueHolder.getValue()).getContent()) != null) {
            newInternationalStringValue.getContent().add(new LocalizedString(this.defaultLanguageLocale, oldStringValue));
        }
        valueHolder.setValue(newInternationalStringValue);
    }

    private void setNewStringValue(ISingleValueHolder valueHolder) {
        InternationalString oldValue;
        String newValue = null;
        if (valueHolder.getValue() != null && (oldValue = (InternationalString)((IValue)valueHolder.getValue()).getContent()) != null) {
            LocalizedString iLocalizedString = oldValue.get(this.defaultLanguageLocale);
            newValue = iLocalizedString.getValue();
        }
        valueHolder.setValue(new StringValue(newValue));
    }
}

