/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForProperty;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.type.IProductCmptProperty;

public class PropertyTypeMismatchEntry
extends AbstractDeltaEntryForProperty {
    private final IProductCmptProperty property;
    private final IPropertyValue value;
    private final IPropertyValueContainer propertyValueContainer;

    public PropertyTypeMismatchEntry(IPropertyValueContainer poIPropertyValueContainer, IProductCmptProperty property, IPropertyValue value) {
        super(value);
        this.propertyValueContainer = poIPropertyValueContainer;
        this.property = property;
        this.value = value;
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.PROPERTY_TYPE_MISMATCH;
    }

    @Override
    public String getDescription() {
        String desc = Messages.PropertyTypeMismatchEntry_desc;
        String label = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(this.property);
        return MessageFormat.format(desc, label, this.property.getProductCmptPropertyType().getName(), this.value.getProductCmptPropertyType().getName());
    }

    @Override
    public void fix() {
        this.value.delete();
        this.propertyValueContainer.newPropertyValues(this.property);
    }
}

