/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForLinks;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.util.StringUtil;

public class RemovedTemplateLinkEntry
extends AbstractDeltaEntryForLinks {
    public RemovedTemplateLinkEntry(IProductCmptLink deletedLink) {
        super(deletedLink);
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.REMOVED_TEMPLATE_LINK;
    }

    @Override
    public String getDescription() {
        String linkCaption = IIpsModel.get().getMultiLanguageSupport().getLocalizedCaption(this.getLink());
        String linkTarget = StringUtil.unqualifiedName((String)this.getLink().getTarget());
        if (this.getLink().getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return MessageFormat.format(Messages.DeletedTemplateLinkEntry_removeUndefinedTemplateLink, linkCaption, linkTarget);
        }
        return MessageFormat.format(Messages.DeletedTemplateLinkEntry_removeInheritedTemplateLink, linkCaption, linkTarget);
    }

    @Override
    public void fix() {
        this.getLink().delete();
    }
}

