/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.util.Currency;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.datatype.classtypes.MoneyDatatype;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.values.Money;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ValueConverter {
    TO_MONEY{

        @Override
        public ValueDatatype targetType() {
            return ValueDatatype.MONEY;
        }

        @Override
        public String convert(String input, IIpsProject project) {
            Currency currency = project.getReadOnlyProperties().getDefaultCurrency();
            MoneyDatatype moneyDT = ValueDatatype.MONEY;
            try {
                Money value = moneyDT.getValue(String.valueOf(input) + currency.getCurrencyCode());
                return value.toString();
            }
            catch (IllegalArgumentException e) {
                return input;
            }
        }
    };


    public abstract ValueDatatype targetType();

    public abstract String convert(String var1, IIpsProject var2);

    public static ValueConverter getByTargetType(ValueDatatype type) {
        ValueConverter[] valueConverterArray = ValueConverter.values();
        int n = valueConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValueConverter converter = valueConverterArray[n2];
            if (converter.targetType().equals(type)) {
                return converter;
            }
            ++n2;
        }
        return null;
    }
}

