/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.faktorips.devtools.model.internal.productcmpt.MultiValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.SingleValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForProperty;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.ISingleValueHolder;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.value.IValue;

public class ValueHolderMismatchEntry
extends AbstractDeltaEntryForProperty {
    private final IProductCmptTypeAttribute attribute;

    public ValueHolderMismatchEntry(IAttributeValue attributeValue, IProductCmptTypeAttribute attribute) {
        super(attributeValue);
        this.attribute = attribute;
    }

    @Override
    public IAttributeValue getPropertyValue() {
        return (IAttributeValue)super.getPropertyValue();
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.VALUE_HOLDER_MISMATCH;
    }

    @Override
    public String getDescription() {
        if (this.attribute.isMultiValueAttribute()) {
            return MessageFormat.format(Messages.ValueMismatchEntry_convertSingleToMultiValue, this.getPropertyName());
        }
        return MessageFormat.format(Messages.ValueMismatchEntry_convertMultiToSingleValue, this.getPropertyName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fix() {
        IValueHolder<?> iValueHolder;
        IValueHolder<?> value = this.getPropertyValue().getValueHolder();
        if (!this.attribute.isMultiValueAttribute() && (iValueHolder = value) instanceof MultiValueHolder) {
            void multiValue;
            MultiValueHolder multiValueHolder = (MultiValueHolder)iValueHolder;
            MultiValueHolder cfr_ignored_0 = (MultiValueHolder)iValueHolder;
            IValue oldValue = null;
            if (!multiValue.getValue().isEmpty()) {
                oldValue = (IValue)((ISingleValueHolder)multiValue.getValue().get(0)).getValue();
            }
            SingleValueHolder newValue = new SingleValueHolder(this.getPropertyValue(), oldValue);
            this.getPropertyValue().setValueHolder(newValue);
        } else if (this.attribute.isMultiValueAttribute() && value instanceof SingleValueHolder) {
            ArrayList<ISingleValueHolder> oldValueList = new ArrayList<ISingleValueHolder>();
            SingleValueHolder singleValue = (SingleValueHolder)value;
            if (singleValue.getValue() != null) {
                oldValueList.add(singleValue);
            }
            MultiValueHolder newValue = new MultiValueHolder(this.getPropertyValue(), oldValueList);
            this.getPropertyValue().setValueHolder(newValue);
        }
    }
}

