/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.deltaentries;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.AbstractDeltaEntryForProperty;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.Messages;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpt.DeltaType;
import org.faktorips.devtools.model.productcmpt.IConfiguredValueSet;

public class ValueSetMismatchEntry
extends AbstractDeltaEntryForProperty {
    private final IPolicyCmptTypeAttribute attribute;
    private final IConfiguredValueSet element;

    public ValueSetMismatchEntry(IPolicyCmptTypeAttribute attribute, IConfiguredValueSet element) {
        super(element);
        this.attribute = attribute;
        this.element = element;
    }

    @Override
    public void fix() {
        this.element.setValueSetCopy(this.attribute.getValueSet());
    }

    @Override
    public DeltaType getDeltaType() {
        return DeltaType.VALUE_SET_MISMATCH;
    }

    @Override
    public String getDescription() {
        String desc = Messages.ValueSetMismatchEntry_desc;
        String label = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(this.attribute);
        return MessageFormat.format(desc, label, this.attribute.getValueSet().getValueSetType().getName(), this.element.getValueSet().getValueSetType().getName());
    }
}

