/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.template;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.faktorips.devtools.model.internal.util.Histogram;
import org.faktorips.devtools.model.productcmpt.Cardinality;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueContainer;
import org.faktorips.values.Decimal;

public class ProductCmptLinkHistograms {
    private final Map<IProductCmptLink.LinkIdentifier, Histogram<Cardinality, IProductCmptLinkContainer>> linkHistograms = new LinkedHashMap<IProductCmptLink.LinkIdentifier, Histogram<Cardinality, IProductCmptLinkContainer>>();

    private ProductCmptLinkHistograms(Collection<IProductCmptLink.LinkIdentifier> links, Collection<? extends IProductCmptLinkContainer> container) {
        for (IProductCmptLink.LinkIdentifier linkIdentifier : links) {
            LinkContainerHistogram histogram = new LinkContainerHistogram(this.getCardinality(linkIdentifier), Collections.unmodifiableCollection(container));
            this.linkHistograms.put(linkIdentifier, histogram);
        }
    }

    public Histogram<Cardinality, IProductCmptLinkContainer> getHistogram(IProductCmptLink.LinkIdentifier linkIdentifier) {
        return this.linkHistograms.get(linkIdentifier);
    }

    public Set<Map.Entry<IProductCmptLink.LinkIdentifier, Histogram<Cardinality, IProductCmptLinkContainer>>> getEntries() {
        return this.linkHistograms.entrySet();
    }

    public int size() {
        return this.linkHistograms.size();
    }

    private Function<IProductCmptLinkContainer, Cardinality> getCardinality(IProductCmptLink.LinkIdentifier linkIdentifier) {
        return linkContainer -> {
            if (linkContainer == null) {
                return null;
            }
            IProductCmptLink link = linkIdentifier.getValueFrom((ITemplatedValueContainer)linkContainer);
            return link == null ? Cardinality.UNDEFINED : link.getCardinality();
        };
    }

    public static ProductCmptLinkHistograms createFor(Collection<? extends IProductCmptLinkContainer> containers) {
        LinkedHashSet<IProductCmptLink.LinkIdentifier> links = new LinkedHashSet<IProductCmptLink.LinkIdentifier>();
        for (IProductCmptLinkContainer iProductCmptLinkContainer : containers) {
            for (IProductCmptLink link : iProductCmptLinkContainer.getLinksAsList()) {
                links.add(new IProductCmptLink.LinkIdentifier(link));
            }
        }
        return new ProductCmptLinkHistograms(links, containers);
    }

    static class LinkContainerHistogram
    extends Histogram<Cardinality, IProductCmptLinkContainer> {
        LinkContainerHistogram(Function<IProductCmptLinkContainer, Cardinality> elementToValueFunction, Collection<IProductCmptLinkContainer> elements) {
            super(elementToValueFunction, elements);
        }

        @Override
        public Histogram.BestValue<Cardinality> getBestValue(Decimal threshold) {
            TreeMap relativeDistribution = new TreeMap(super.getRelativeDistribution());
            relativeDistribution.remove(Cardinality.UNDEFINED);
            Cardinality candidateValue = (Cardinality)relativeDistribution.firstKey();
            return this.getBestValue(threshold, relativeDistribution, candidateValue);
        }
    }
}

