/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.template;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.faktorips.devtools.model.internal.util.Histogram;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueIdentifier;
import org.faktorips.util.MultiMap;

public class PropertyValueHistograms {
    private final Map<ITemplatedValueIdentifier, Histogram<Object, IPropertyValue>> propertyValueHistorgram = new HashMap<ITemplatedValueIdentifier, Histogram<Object, IPropertyValue>>();

    private PropertyValueHistograms(MultiMap<ITemplatedValueIdentifier, IPropertyValue> propertyToValues) {
        for (Map.Entry propertyValuesEntry : propertyToValues.asMap().entrySet()) {
            ITemplatedValueIdentifier name = (ITemplatedValueIdentifier)propertyValuesEntry.getKey();
            Collection propertyValues = (Collection)propertyValuesEntry.getValue();
            this.populateHistogram(name, propertyValues);
        }
    }

    private PropertyValueType getPropertyValueType(Collection<IPropertyValue> propertyValues) {
        IPropertyValue propertyValue = propertyValues.iterator().next();
        return propertyValue.getPropertyValueType();
    }

    private void populateHistogram(ITemplatedValueIdentifier name, Collection<IPropertyValue> propertyValues) {
        if (!propertyValues.isEmpty()) {
            PropertyValueType valueType = this.getPropertyValueType(propertyValues);
            this.propertyValueHistorgram.put(name, new Histogram<Object, IPropertyValue>(valueType.getValueGetter(), valueType.getValueComparator(), propertyValues));
        }
    }

    public static PropertyValueHistograms createFor(List<IProductCmpt> cmpts) {
        MultiMap propertyToValues = MultiMap.createWithLinkedSetAsValues();
        for (IProductCmpt productCmpt : cmpts) {
            PropertyValueHistograms.addAllPropertyValues((MultiMap<ITemplatedValueIdentifier, IPropertyValue>)propertyToValues, productCmpt);
            IProductCmptGeneration productCmptGeneration = productCmpt.getLatestProductCmptGeneration();
            PropertyValueHistograms.addAllPropertyValues((MultiMap<ITemplatedValueIdentifier, IPropertyValue>)propertyToValues, productCmptGeneration);
        }
        return new PropertyValueHistograms((MultiMap<ITemplatedValueIdentifier, IPropertyValue>)propertyToValues);
    }

    private static void addAllPropertyValues(MultiMap<ITemplatedValueIdentifier, IPropertyValue> propertyToValues, IPropertyValueContainer propertyValueContainer) {
        for (IPropertyValue propertyValue : propertyValueContainer.getAllPropertyValues()) {
            propertyToValues.put((Object)propertyValue.getIdentifier(), (Object[])new IPropertyValue[]{propertyValue});
        }
    }

    public Histogram<Object, IPropertyValue> get(ITemplatedValueIdentifier propertyName) {
        return this.propertyValueHistorgram.get(propertyName);
    }

    public int size() {
        return this.propertyValueHistorgram.size();
    }
}

