/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.template;

import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.SingleEventModification;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValue;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;

public class RemoveTemplateOperation
implements ICoreRunnable {
    private final IProductCmpt productCmpt;

    public RemoveTemplateOperation(IProductCmpt productCmpt) {
        this.productCmpt = productCmpt;
    }

    public void run(IProgressMonitor monitor) {
        RemoveTemplateModification modification = new RemoveTemplateModification(this.productCmpt);
        ((IpsModel)this.productCmpt.getIpsModel()).executeModificationsWithSingleEvent(modification);
    }

    protected static class RemoveTemplateModification
    extends SingleEventModification<Object> {
        private IProductCmpt productCmpt;

        RemoveTemplateModification(IProductCmpt productCmpt) {
            super(productCmpt.getIpsSrcFile());
            this.productCmpt = productCmpt;
        }

        @Override
        protected boolean execute() {
            this.processPropertyValues(this.productCmpt);
            this.processLinks(this.productCmpt);
            for (IProductCmptGeneration container : this.productCmpt.getProductCmptGenerations()) {
                this.processPropertyValues(container);
                this.processLinks(container);
            }
            return true;
        }

        private void processPropertyValues(IPropertyValueContainer container) {
            for (IPropertyValue value : container.getAllPropertyValues()) {
                this.switchInheritedValuesToDefined(value);
            }
        }

        private void processLinks(IProductCmptLinkContainer container) {
            container.removeUndefinedLinks();
            for (IProductCmptLink link : container.getLinksAsList()) {
                this.switchInheritedValuesToDefined(link);
            }
        }

        private void switchInheritedValuesToDefined(ITemplatedValue value) {
            if (value.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
                value.setTemplateValueStatus(TemplateValueStatus.DEFINED);
            }
        }
    }
}

