/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.template;

import java.util.LinkedHashSet;
import java.util.Set;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.util.Tree;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.MultiMap;

public class TemplateHierarchyFinder {
    private TemplateHierarchyFinder() {
    }

    public static Tree<IIpsSrcFile> findTemplateHierarchyFor(IProductCmpt template, IIpsProject ipsProject) {
        if (template == null || !template.isProductTemplate()) {
            return Tree.emptyTree();
        }
        MultiMap templateMap = MultiMap.createWithLinkedSetAsValues();
        IIpsProject[] iIpsProjectArray = ipsProject.findReferencingProjectLeavesOrSelf();
        int n = iIpsProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject p = iIpsProjectArray[n2];
            templateMap.merge(TemplateHierarchyFinder.createTemplateMap(p));
            ++n2;
        }
        Tree<IIpsSrcFile> tree = new Tree<IIpsSrcFile>(template.getIpsSrcFile());
        TemplateHierarchyFinder.addTemplateReferences(tree.getRoot(), template.getQualifiedName(), (MultiMap<String, IIpsSrcFile>)templateMap);
        return tree;
    }

    private static MultiMap<String, IIpsSrcFile> createTemplateMap(IIpsProject ipsProject) {
        MultiMap templateMap = MultiMap.createWithLinkedSetAsValues();
        for (IIpsSrcFile srcFile : ipsProject.findAllIpsSrcFiles(IpsObjectType.PRODUCT_CMPT, IpsObjectType.PRODUCT_TEMPLATE)) {
            String template = srcFile.getPropertyValue("template");
            if (!IpsStringUtils.isNotBlank((String)template)) continue;
            templateMap.put((Object)template, (Object[])new IIpsSrcFile[]{srcFile});
        }
        return templateMap;
    }

    private static void addTemplateReferences(Tree.Node<IIpsSrcFile> parent, String templateQName, MultiMap<String, IIpsSrcFile> templateMap) {
        Set<Tree.Node<IIpsSrcFile>> children = TemplateHierarchyFinder.addDirectTemplateReferences(parent, templateQName, templateMap);
        for (Tree.Node<IIpsSrcFile> child : children) {
            IIpsSrcFile srcFile = child.getElement();
            if (!TemplateHierarchyFinder.isTemplate(srcFile)) continue;
            String subTemplateQName = srcFile.getQualifiedNameType().getName();
            TemplateHierarchyFinder.addTemplateReferences(child, subTemplateQName, templateMap);
        }
    }

    private static Set<Tree.Node<IIpsSrcFile>> addDirectTemplateReferences(Tree.Node<IIpsSrcFile> parent, String templateQName, MultiMap<String, IIpsSrcFile> templateMap) {
        LinkedHashSet<Tree.Node<IIpsSrcFile>> addedNodes = new LinkedHashSet<Tree.Node<IIpsSrcFile>>();
        for (IIpsSrcFile srcFile : templateMap.get((Object)templateQName)) {
            addedNodes.add(parent.addChild(srcFile));
        }
        return addedNodes;
    }

    private static boolean isTemplate(IIpsSrcFile srcFile) {
        return IpsObjectType.PRODUCT_TEMPLATE.equals(srcFile.getIpsObjectType());
    }
}

