/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.template;

import java.text.MessageFormat;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.Messages;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueContainer;
import org.faktorips.devtools.model.productcmpt.template.TemplateHierarchyVisitor;
import org.faktorips.runtime.MessageList;

public class TemplateValidations {
    private TemplateValidations() {
    }

    public static void validateTemplateCycle(IProductCmpt template, MessageList list, IIpsProject ipsProject) {
        if (template == null || !template.isProductTemplate()) {
            return;
        }
        TemplateCycleDetectionVisitor visitor = new TemplateCycleDetectionVisitor(ipsProject);
        visitor.start(template);
        if (visitor.cycleDetected()) {
            String text = MessageFormat.format(Messages.TemplateValidations_error_templateCycle, template);
            list.newError("PRODUCT_CMPT-TemplateCycle", text, (Object)template, new String[]{"template"});
        }
    }

    private static class TemplateCycleDetectionVisitor
    extends TemplateHierarchyVisitor<ITemplatedValueContainer> {
        public TemplateCycleDetectionVisitor(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(ITemplatedValueContainer currentType) {
            return true;
        }
    }
}

