/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.template;

import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValue;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueContainer;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueIdentifier;
import org.faktorips.devtools.model.productcmpt.template.TemplateHierarchyVisitor;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;

public class TemplateValueFinder<V extends ITemplatedValue, C extends ITemplatedValueContainer>
extends TemplateHierarchyVisitor<C> {
    private final V originalValue;
    private final Class<V> valueClass;
    private V resultingValue;
    private boolean knownInTemplate;
    private final ITemplatedValueIdentifier valueIdentifier;

    public TemplateValueFinder(V originalPropertyValue, Class<V> valueClass, ITemplatedValueIdentifier valueIdentifier, IIpsProject ipsProject) {
        super(ipsProject);
        this.originalValue = originalPropertyValue;
        this.valueClass = valueClass;
        this.valueIdentifier = valueIdentifier;
    }

    @Override
    protected boolean visit(C currentValueContainer) {
        if (this.originalValue.getTemplatedValueContainer() == currentValueContainer) {
            return true;
        }
        ITemplatedValue currentValue = (ITemplatedValue)this.valueClass.cast(this.valueIdentifier.getValueFrom((ITemplatedValueContainer)currentValueContainer));
        if (currentValue == null || this.isInherited(currentValue)) {
            return true;
        }
        if (this.isDefined(currentValue)) {
            this.resultingValue = currentValue;
            this.knownInTemplate = true;
        } else if (this.isUndefined(currentValue)) {
            this.knownInTemplate = true;
        }
        return false;
    }

    private boolean isDefined(V value) {
        return value.getTemplateValueStatus() == TemplateValueStatus.DEFINED;
    }

    private boolean isUndefined(V value) {
        return value.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED;
    }

    private boolean isInherited(V value) {
        return value.getTemplateValueStatus() == TemplateValueStatus.INHERITED;
    }

    public V getTemplateValue() {
        return this.resultingValue;
    }

    public boolean isKnownInTemplate() {
        return this.knownInTemplate;
    }

    public static <U extends ITemplatedValue> U findTemplateValue(U originalValue, Class<U> valueClass) {
        TemplateValueFinder finder = new TemplateValueFinder(originalValue, valueClass, originalValue.getIdentifier(), originalValue.getIpsProject());
        finder.start(originalValue.getTemplatedValueContainer());
        return finder.getTemplateValue();
    }

    public static <U extends ITemplatedValue> boolean hasTemplateForValue(U originalValue, Class<U> valueClass) {
        TemplateValueFinder finder = new TemplateValueFinder(originalValue, valueClass, originalValue.getIdentifier(), originalValue.getIpsProject());
        finder.start(originalValue.getTemplatedValueContainer());
        return finder.isKnownInTemplate();
    }
}

