/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.template;

import java.text.MessageFormat;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValue;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Element;

public class TemplateValueSettings {
    private final ITemplatedValue parent;
    private TemplateValueStatus status = TemplateValueStatus.DEFINED;

    public TemplateValueSettings(ITemplatedValue parent) {
        this.parent = parent;
        ITemplatedValue templateValue = parent.findTemplateProperty(parent.getIpsProject());
        if (templateValue != null) {
            this.status = TemplateValueStatus.INHERITED;
        }
    }

    public void setStatus(TemplateValueStatus status) {
        this.status = status;
    }

    public TemplateValueStatus getStatus() {
        if (this.parent.isPartOfTemplateHierarchy()) {
            return this.status;
        }
        return TemplateValueStatus.DEFINED;
    }

    public MessageList validate(IPropertyValue value, IIpsProject ipsProject) {
        MessageList messageList = new MessageList();
        if (this.isUndefinedInProductCmpt(value)) {
            String message = MessageFormat.format(Messages.TemplateValueSettings_msgExcludeNotAllowedInProductCmpt, new Object[]{TemplateValueStatus.UNDEFINED, value});
            messageList.newError("TEMPLATEDPROPERTY-InvalidTemplateValueStatus", message, (Object)value, new String[]{"templateValueStatus"});
        }
        return messageList;
    }

    public MessageList validate(IProductCmptLink link, IIpsProject ipsProject) {
        String message;
        MessageList messageList = new MessageList();
        if (this.noInheritablePropertyFound(link, ipsProject)) {
            message = MessageFormat.format(Messages.TemplateValueSettings_msgNoInheritableLinkFound, link.getTarget());
            messageList.newError("TEMPLATEDPROPERTY-InvalidTemplateValueStatus", message, (Object)link, new String[]{"templateValueStatus"});
        }
        if (this.noDeletableLinkFound(link, ipsProject)) {
            message = MessageFormat.format(Messages.TemplateValueSettings_msgNoDeletableLinkFound, link.getTarget());
            messageList.newError("TEMPLATEDPROPERTY-InvalidTemplateValueStatus", message, (Object)link, new String[]{"templateValueStatus"});
        }
        return messageList;
    }

    private boolean isUndefinedInProductCmpt(IPropertyValue propertyValue) {
        return propertyValue.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED && !propertyValue.getPropertyValueContainer().isProductTemplate();
    }

    private boolean noInheritablePropertyFound(ITemplatedValue property, IIpsProject ipsProject) {
        return property.getTemplateValueStatus() == TemplateValueStatus.INHERITED && property.findTemplateProperty(ipsProject) == null;
    }

    private boolean noDeletableLinkFound(IProductCmptLink link, IIpsProject ipsProject) {
        return link.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED && link.findTemplateProperty(ipsProject) == null;
    }

    public void initPropertiesFromXml(Element element) {
        if (element.hasAttribute("templateValueStatus")) {
            String statusString = element.getAttribute("templateValueStatus");
            this.status = TemplateValueStatus.valueOfXml(statusString, TemplateValueStatus.DEFINED);
        } else {
            this.status = TemplateValueStatus.DEFINED;
        }
    }

    public void propertiesToXml(Element element) {
        if (!TemplateValueStatus.DEFINED.equals((Object)this.status)) {
            element.setAttribute("templateValueStatus", this.status.getXmlValue());
        }
    }
}

