/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.treestructure;

import java.util.GregorianCalendar;
import org.faktorips.devtools.model.internal.productcmpt.treestructure.ProductCmptStructureReference;
import org.faktorips.devtools.model.internal.productcmpt.treestructure.ProductCmptTypeAssociationReference;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.treestructure.CycleInProductStructureException;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptReference;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptTreeStructure;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptTypeAssociationReference;

public class ProductCmptReference
extends ProductCmptStructureReference
implements IProductCmptReference {
    private final IProductCmpt cmpt;
    private final IProductCmptLink link;

    public ProductCmptReference(IProductCmptTreeStructure structure, ProductCmptTypeAssociationReference parent, IProductCmpt cmpt, IProductCmptLink link) throws CycleInProductStructureException {
        super(structure, parent);
        this.cmpt = cmpt;
        this.link = link;
    }

    @Override
    public IProductCmptTypeAssociationReference getParent() {
        return (IProductCmptTypeAssociationReference)super.getParent();
    }

    @Override
    public IProductCmpt getProductCmpt() {
        return this.cmpt;
    }

    @Override
    public IIpsObjectPart getWrapped() {
        return this.link;
    }

    @Override
    public IIpsObject getWrappedIpsObject() {
        return this.cmpt;
    }

    @Override
    public IProductCmptLink getLink() {
        return this.link;
    }

    @Override
    public GregorianCalendar getValidTo() {
        GregorianCalendar validTo = this.getValidToForCmptOrGeneration();
        return this.getMostRestrictiveValidToInChildren(validTo);
    }

    protected GregorianCalendar getMostRestrictiveValidToInChildren(GregorianCalendar validTo) {
        IProductCmptReference[] childProductCmptReferences;
        GregorianCalendar mostRestrictiveValidTo = validTo;
        IProductCmptReference[] iProductCmptReferenceArray = childProductCmptReferences = this.getStructure().getChildProductCmptReferences(this);
        int n = childProductCmptReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IProductCmptReference productCmptReference = iProductCmptReferenceArray[n2];
            GregorianCalendar childValidTo = productCmptReference.getValidTo();
            if (mostRestrictiveValidTo == null || childValidTo != null && childValidTo.before(mostRestrictiveValidTo)) {
                mostRestrictiveValidTo = childValidTo;
            }
            ++n2;
        }
        return mostRestrictiveValidTo;
    }

    protected GregorianCalendar getValidToForCmptOrGeneration() {
        IProductCmptGeneration generation = this.cmpt.getGenerationEffectiveOn(this.getStructure().getValidAt());
        GregorianCalendar validTo = generation == null ? this.cmpt.getValidTo() : generation.getValidTo();
        return validTo;
    }

    @Override
    public IProductCmptReference findProductCmptReference(String prodCmptQualifiedName) {
        IProductCmptReference[] childProductCmptReferences;
        if (this.getProductCmpt().getQualifiedName().equals(prodCmptQualifiedName)) {
            return this;
        }
        IProductCmptReference[] iProductCmptReferenceArray = childProductCmptReferences = this.getStructure().getChildProductCmptReferences(this);
        int n = childProductCmptReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IProductCmptReference childRef = iProductCmptReferenceArray[n2];
            IProductCmptReference foundRef = childRef.findProductCmptReference(prodCmptQualifiedName);
            if (foundRef != null) {
                return foundRef;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean hasAssociationChildren() {
        return this.getStructure().getChildProductCmptTypeAssociationReferences(this).length > 0;
    }
}

