/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.treestructure;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.core.runtime.PlatformObject;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.treestructure.CycleInProductStructureException;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptStructureReference;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptTreeStructure;

public abstract class ProductCmptStructureReference
extends PlatformObject
implements IProductCmptStructureReference {
    private final IProductCmptTreeStructure structure;
    private final ProductCmptStructureReference parent;
    private ProductCmptStructureReference[] children;

    public ProductCmptStructureReference(IProductCmptTreeStructure structure, ProductCmptStructureReference parent) throws CycleInProductStructureException {
        this.structure = structure;
        this.parent = parent;
        this.children = new ProductCmptStructureReference[0];
        this.detectCycle(new ArrayList<IIpsElement>());
    }

    @Override
    public IProductCmptTreeStructure getStructure() {
        return this.structure;
    }

    @Override
    public IProductCmptStructureReference getParent() {
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }

    public ProductCmptStructureReference[] getChildren() {
        return this.children;
    }

    void setChildren(ProductCmptStructureReference[] children) {
        this.children = children;
    }

    private void detectCycle(ArrayList<IIpsElement> seenElements) throws CycleInProductStructureException {
        if (this.getWrappedIpsObject() instanceof IProductCmpt) {
            if (seenElements.contains(this.getWrappedIpsObject())) {
                throw new CycleInProductStructureException(seenElements.toArray(new IIpsElement[seenElements.size()]));
            }
            seenElements.add(this.getWrappedIpsObject());
        }
        if (this.parent != null) {
            this.parent.detectCycle(seenElements);
        }
    }

    @Override
    public IIpsSrcFile getWrappedIpsSrcFile() {
        if (this.getWrappedIpsObject() != null) {
            return this.getWrappedIpsObject().getIpsSrcFile();
        }
        return null;
    }

    @Override
    public IIpsProject getIpsProject() {
        if (this.getWrappedIpsSrcFile() != null) {
            return this.getWrappedIpsSrcFile().getIpsProject();
        }
        return null;
    }

    public String toString() {
        return "ProductCmptStructureReference [ipsObject=" + this.getWrappedIpsObject() + "," + "wrappedPart=" + this.getWrapped() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductCmptStructureReference other = (ProductCmptStructureReference)obj;
        return this.parent == other.parent && Objects.equals(this.structure, other.structure) && Objects.equals(this.getWrapped().getId(), other.getWrapped().getId()) && Objects.equals(this.getWrappedIpsObject().getQualifiedName(), other.getWrappedIpsObject().getQualifiedName());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getWrapped() != null) {
            hash = 31 * hash + this.getWrapped().hashCode();
        }
        if (this.getWrappedIpsObject() != null) {
            hash = 31 * hash + this.getWrappedIpsObject().hashCode();
        }
        if (this.getStructure() != null) {
            hash = 31 * hash + this.getStructure().hashCode();
        }
        if (this.parent != null) {
            hash = 31 * hash + System.identityHashCode(this.parent);
        }
        return hash;
    }
}

