/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt.treestructure;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.productcmpt.treestructure.ProductCmptReference;
import org.faktorips.devtools.model.internal.productcmpt.treestructure.ProductCmptStructureReference;
import org.faktorips.devtools.model.internal.productcmpt.treestructure.ProductCmptStructureTblUsageReference;
import org.faktorips.devtools.model.internal.productcmpt.treestructure.ProductCmptTypeAssociationReference;
import org.faktorips.devtools.model.internal.productcmpt.treestructure.ProductCmptVRuleReference;
import org.faktorips.devtools.model.ipsobject.IIpsObjectGeneration;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.ITableContentUsage;
import org.faktorips.devtools.model.productcmpt.IValidationRuleConfig;
import org.faktorips.devtools.model.productcmpt.IValidationRuleConfigContainer;
import org.faktorips.devtools.model.productcmpt.treestructure.CycleInProductStructureException;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptReference;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptStructureReference;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptStructureTblUsageReference;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptTreeStructure;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptTypeAssociationReference;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptVRuleReference;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.collections.IdentityHashSet;

public class ProductCmptTreeStructure
implements IProductCmptTreeStructure {
    private final IIpsProject ipsProject;
    private IProductCmptReference root;
    private final GregorianCalendar workingDate;
    private Set<IProductCmptStructureReference> setWithProductCmptsOnly;
    private Set<IProductCmptStructureReference> setWithAll;

    public ProductCmptTreeStructure(IProductCmpt root, GregorianCalendar date, IIpsProject project) throws CycleInProductStructureException {
        ArgumentCheck.notNull((Object)root);
        ArgumentCheck.notNull((Object)project);
        this.workingDate = date;
        this.ipsProject = project;
        this.root = this.buildNode(root, null, null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ipsProject == null ? 0 : this.ipsProject.hashCode());
        result = this.root == null || this.root.getWrapped() == null ? (result *= 31) : 31 * result + this.root.getWrapped().hashCode();
        return 31 * result + (this.workingDate == null ? 0 : this.workingDate.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductCmptTreeStructure other = (ProductCmptTreeStructure)obj;
        if (!Objects.equals(this.ipsProject, other.ipsProject)) {
            return false;
        }
        if (this.root == null ? other.root != null : (this.root.getWrapped() == null ? other.getRoot().getWrapped() != null : !this.root.getWrapped().equals(other.root.getWrapped()))) {
            return false;
        }
        return Objects.equals(this.workingDate, other.workingDate);
    }

    @Override
    public GregorianCalendar getValidAt() {
        return this.workingDate;
    }

    @Override
    public IProductCmptReference getRoot() {
        return this.root;
    }

    @Override
    public void refresh() throws CycleInProductStructureException {
        this.setWithAll = null;
        this.setWithProductCmptsOnly = null;
        this.root = this.buildNode(this.root.getProductCmpt(), null, null);
    }

    @Override
    public Set<IProductCmptStructureReference> toSet(boolean productCmptOnly) {
        if (productCmptOnly) {
            if (this.setWithProductCmptsOnly != null) {
                return this.setWithProductCmptsOnly;
            }
        } else if (this.setWithAll != null) {
            return this.setWithAll;
        }
        IdentityHashSet result = new IdentityHashSet();
        result.add(this.root);
        this.addChildrenToList(this.root, (Set<IProductCmptStructureReference>)result, productCmptOnly);
        if (productCmptOnly) {
            this.setWithProductCmptsOnly = result;
        } else {
            this.setWithAll = result;
        }
        return result;
    }

    private void addChildrenToList(IProductCmptStructureReference parent, Set<IProductCmptStructureReference> set, boolean productCmptOnly) {
        if (!productCmptOnly) {
            this.addChildrenToList(this.getChildProductCmptTypeAssociationReferences(parent), set, productCmptOnly);
        }
        this.addChildrenToList(this.getChildProductCmptReferences(parent), set, productCmptOnly);
        this.addChildrenToList(this.getChildProductCmptStructureTblUsageReference(parent), set, productCmptOnly);
    }

    private void addChildrenToList(IProductCmptStructureReference[] children, Set<IProductCmptStructureReference> set, boolean productCmptOnly) {
        IProductCmptStructureReference[] iProductCmptStructureReferenceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IProductCmptStructureReference element = iProductCmptStructureReferenceArray[n2];
            set.add(element);
            this.addChildrenToList(element, set, productCmptOnly);
            ++n2;
        }
    }

    private ProductCmptReference buildNode(IProductCmpt cmpt, IProductCmptLink link, ProductCmptTypeAssociationReference parent) throws CycleInProductStructureException {
        ProductCmptReference node = new ProductCmptReference(this, parent, cmpt, link);
        node.setChildren(this.buildChildNodes(cmpt, node));
        return node;
    }

    private ProductCmptStructureReference[] buildChildNodes(IProductCmptLink[] links, ProductCmptTypeAssociationReference parent, IProductCmptTypeAssociation association) throws CycleInProductStructureException {
        ArrayList<ProductCmptReference> children = new ArrayList<ProductCmptReference>();
        IProductCmptLink[] iProductCmptLinkArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            IProductCmptLink link = iProductCmptLinkArray[n2];
            try {
                IProductCmpt p = link.findTarget(this.ipsProject);
                if (p != null) {
                    if (association.isAssoziation()) {
                        children.add(new ProductCmptReference(this, parent, p, link));
                    } else {
                        children.add(this.buildNode(p, link, parent));
                    }
                }
            }
            catch (IpsException e) {
                IpsLog.log(e);
            }
            ++n2;
        }
        ProductCmptStructureReference[] result = new ProductCmptStructureReference[children.size()];
        return children.toArray(result);
    }

    /*
     * WARNING - void declaration
     */
    private ProductCmptStructureReference[] buildChildNodes(IIpsElement element, ProductCmptStructureReference parent) throws CycleInProductStructureException {
        ArrayList<IProductCmptStructureReference> children = new ArrayList<IProductCmptStructureReference>();
        IIpsElement iIpsElement = element;
        if (iIpsElement instanceof IProductCmpt) {
            void cmpt;
            IProductCmpt iProductCmpt = (IProductCmpt)iIpsElement;
            IProductCmpt cfr_ignored_0 = (IProductCmpt)iIpsElement;
            IProductCmptGeneration activeGeneration = null;
            if (this.workingDate != null) {
                activeGeneration = cmpt.getGenerationEffectiveOn(this.workingDate);
            } else {
                IIpsObjectGeneration[] generations = cmpt.getGenerationsOrderedByValidDate();
                if (generations.length > 0) {
                    activeGeneration = (IProductCmptGeneration)generations[generations.length - 1];
                }
            }
            if (activeGeneration == null) {
                return new ProductCmptReference[0];
            }
            Hashtable<String, List<IProductCmptLink>> mapping = new Hashtable<String, List<IProductCmptLink>>();
            List<IProductCmptLink> links = activeGeneration.getLinksIncludingProductCmpt();
            this.putLinksToMap(links, mapping);
            this.addAssociationsAsChildren(parent, children, (IProductCmpt)cmpt, mapping);
            this.addRules(parent, children, (IValidationRuleConfigContainer)cmpt);
            this.addRules(parent, children, activeGeneration);
            this.addTableContentUsages(parent, children, cmpt.getTableContentUsages());
            this.addTableContentUsages(parent, children, activeGeneration.getTableContentUsages());
        }
        ProductCmptStructureReference[] result = new ProductCmptStructureReference[children.size()];
        return children.toArray(result);
    }

    private void addRules(ProductCmptStructureReference parent, List<IProductCmptStructureReference> children, IValidationRuleConfigContainer container) throws CycleInProductStructureException {
        for (IValidationRuleConfig rule : container.getValidationRuleConfigs()) {
            ProductCmptVRuleReference node = new ProductCmptVRuleReference(this, parent, rule);
            children.add(node);
        }
    }

    private void addTableContentUsages(ProductCmptStructureReference parent, List<IProductCmptStructureReference> children, ITableContentUsage[] tcus) throws CycleInProductStructureException {
        ITableContentUsage[] iTableContentUsageArray = tcus;
        int n = tcus.length;
        int n2 = 0;
        while (n2 < n) {
            ITableContentUsage tcu = iTableContentUsageArray[n2];
            ProductCmptStructureTblUsageReference node = new ProductCmptStructureTblUsageReference(this, parent, tcu);
            children.add(node);
            ++n2;
        }
    }

    private void addAssociationsAsChildren(ProductCmptStructureReference parent, List<IProductCmptStructureReference> children, IProductCmpt cmpt, Hashtable<String, List<IProductCmptLink>> mapping) throws CycleInProductStructureException {
        List<Object> associations = new ArrayList();
        IProductCmptType cmptType = cmpt.findProductCmptType(this.ipsProject);
        if (cmptType != null) {
            associations = cmptType.findAllNotDerivedAssociations(this.ipsProject);
        }
        for (IAssociation iAssociation : associations) {
            IProductCmptTypeAssociation association = (IProductCmptTypeAssociation)iAssociation;
            if (!association.isRelevant()) continue;
            ProductCmptTypeAssociationReference node = new ProductCmptTypeAssociationReference(this, parent, association);
            List<IProductCmptLink> linksList = mapping.get(association.getName());
            if (linksList == null) {
                linksList = new ArrayList<IProductCmptLink>();
            }
            node.setChildren(this.buildChildNodes(linksList.toArray(new IProductCmptLink[linksList.size()]), node, association));
            children.add(node);
        }
    }

    private void putLinksToMap(List<IProductCmptLink> links, Hashtable<String, List<IProductCmptLink>> mapping) {
        for (IProductCmptLink link : links) {
            try {
                IProductCmptTypeAssociation association = link.findAssociation(this.ipsProject);
                if (association == null) continue;
                List linksForAssociation = mapping.computeIfAbsent(association.getName(), $ -> new ArrayList());
                linksForAssociation.add(link);
            }
            catch (IpsException e) {
                IpsLog.log(e);
            }
        }
    }

    @Override
    public IProductCmptReference getParentProductCmptReference(IProductCmptStructureReference child) {
        ProductCmptStructureReference ref = (ProductCmptStructureReference)child;
        IProductCmptStructureReference result = ref.getParent();
        if (result instanceof IProductCmptReference) {
            return (IProductCmptReference)result;
        }
        if (result != null) {
            return (IProductCmptReference)result.getParent();
        }
        return null;
    }

    @Override
    public IProductCmptTypeAssociationReference getParentProductCmptTypeRelationReference(IProductCmptStructureReference child) {
        ProductCmptStructureReference ref = (ProductCmptStructureReference)child;
        IProductCmptStructureReference result = ref.getParent();
        if (result instanceof IProductCmptTypeAssociationReference) {
            return (IProductCmptTypeAssociationReference)result;
        }
        if (result != null) {
            return (IProductCmptTypeAssociationReference)result.getParent();
        }
        return null;
    }

    @Override
    public IProductCmptReference[] getChildProductCmptReferences(IProductCmptStructureReference parent) {
        if (parent instanceof IProductCmptTypeAssociationReference) {
            ProductCmptStructureReference[] children = ((ProductCmptTypeAssociationReference)parent).getChildren();
            IProductCmptReference[] result = new IProductCmptReference[children.length];
            System.arraycopy(children, 0, result, 0, children.length);
            return result;
        }
        if (parent instanceof ProductCmptStructureTblUsageReference) {
            return new IProductCmptReference[0];
        }
        ProductCmptStructureReference[] children = ((ProductCmptReference)parent).getChildren();
        ArrayList<IProductCmptReference> result = new ArrayList<IProductCmptReference>();
        ProductCmptStructureReference[] productCmptStructureReferenceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ProductCmptStructureReference ref = productCmptStructureReferenceArray[n2];
            ProductCmptStructureReference[] productCmptStructureReferenceArray2 = ref.getChildren();
            int n3 = productCmptStructureReferenceArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                ProductCmptStructureReference child = productCmptStructureReferenceArray2[n4];
                if (child instanceof IProductCmptReference) {
                    result.add((IProductCmptReference)((Object)child));
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IProductCmptReference[result.size()]);
    }

    @Override
    public IProductCmptTypeAssociationReference[] getChildProductCmptTypeAssociationReferences(IProductCmptStructureReference parent) {
        return this.getChildProductCmptTypeAssociationReferences(parent, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IProductCmptTypeAssociationReference[] getChildProductCmptTypeAssociationReferences(IProductCmptStructureReference parent, boolean includeEmptyAssociations) {
        if (parent instanceof IProductCmptReference) {
            ProductCmptStructureReference[] children;
            ArrayList<void> associationReferences = new ArrayList<void>();
            ProductCmptStructureReference[] productCmptStructureReferenceArray = children = ((ProductCmptReference)parent).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ProductCmptStructureReference element = productCmptStructureReferenceArray[n2];
                ProductCmptStructureReference productCmptStructureReference = element;
                if (productCmptStructureReference instanceof IProductCmptTypeAssociationReference) {
                    void relationReference;
                    IProductCmptTypeAssociationReference cfr_ignored_0 = (IProductCmptTypeAssociationReference)((Object)productCmptStructureReference);
                    IProductCmptTypeAssociationReference cfr_ignored_1 = (IProductCmptTypeAssociationReference)((Object)productCmptStructureReference);
                    if (includeEmptyAssociations || this.getChildProductCmptReferences((IProductCmptStructureReference)relationReference).length > 0) {
                        associationReferences.add(relationReference);
                    }
                }
                ++n2;
            }
            return associationReferences.toArray(new IProductCmptTypeAssociationReference[associationReferences.size()]);
        }
        if (parent instanceof ProductCmptStructureReference) {
            ProductCmptStructureReference[] children = ((ProductCmptStructureReference)parent).getChildren();
            ArrayList<IProductCmptTypeAssociationReference> result = new ArrayList<IProductCmptTypeAssociationReference>();
            ProductCmptStructureReference[] productCmptStructureReferenceArray = children;
            int n = children.length;
            int n3 = 0;
            while (n3 < n) {
                ProductCmptStructureReference element = productCmptStructureReferenceArray[n3];
                if (element instanceof IProductCmptTypeAssociationReference) {
                    result.add((IProductCmptTypeAssociationReference)((Object)element));
                }
                ++n3;
            }
            return result.toArray(new IProductCmptTypeAssociationReference[result.size()]);
        }
        return new IProductCmptTypeAssociationReference[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IProductCmptStructureTblUsageReference[] getChildProductCmptStructureTblUsageReference(IProductCmptStructureReference parent) {
        IProductCmptStructureReference[] children;
        ArrayList<void> tblUsageReferences = new ArrayList<void>();
        IProductCmptStructureReference[] iProductCmptStructureReferenceArray = children = this.getChildren(parent);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IProductCmptStructureReference element = iProductCmptStructureReferenceArray[n2];
            IProductCmptStructureReference iProductCmptStructureReference = element;
            if (iProductCmptStructureReference instanceof ProductCmptStructureTblUsageReference) {
                void tblUsageReference;
                ProductCmptStructureTblUsageReference cfr_ignored_0 = (ProductCmptStructureTblUsageReference)iProductCmptStructureReference;
                ProductCmptStructureTblUsageReference cfr_ignored_1 = (ProductCmptStructureTblUsageReference)iProductCmptStructureReference;
                if (IpsStringUtils.isNotEmpty((String)tblUsageReference.getTableContentUsage().getTableContentName())) {
                    tblUsageReferences.add(tblUsageReference);
                }
            }
            ++n2;
        }
        return tblUsageReferences.toArray(new IProductCmptStructureTblUsageReference[tblUsageReferences.size()]);
    }

    private IProductCmptStructureReference[] getChildren(IProductCmptStructureReference parent) {
        if (parent instanceof IProductCmptReference) {
            return ((ProductCmptReference)parent).getChildren();
        }
        return ((ProductCmptStructureReference)parent).getChildren();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IProductCmptVRuleReference[] getChildProductCmptVRuleReferences(IProductCmptStructureReference parent) {
        IProductCmptStructureReference[] children;
        ArrayList<void> vRuleReferences = new ArrayList<void>();
        IProductCmptStructureReference[] iProductCmptStructureReferenceArray = children = this.getChildren(parent);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IProductCmptStructureReference element = iProductCmptStructureReferenceArray[n2];
            IProductCmptStructureReference iProductCmptStructureReference = element;
            if (iProductCmptStructureReference instanceof ProductCmptVRuleReference) {
                void vRuleReference;
                ProductCmptVRuleReference cfr_ignored_0 = (ProductCmptVRuleReference)iProductCmptStructureReference;
                ProductCmptVRuleReference cfr_ignored_1 = (ProductCmptVRuleReference)iProductCmptStructureReference;
                if (IpsStringUtils.isNotEmpty((String)vRuleReference.getValidationRuleConfig().getName())) {
                    vRuleReferences.add(vRuleReference);
                }
            }
            ++n2;
        }
        return vRuleReferences.toArray(new ProductCmptVRuleReference[vRuleReferences.size()]);
    }

    @Override
    public boolean referencesProductCmptQualifiedName(String prodCmptQualifiedName) {
        return this.root.findProductCmptReference(prodCmptQualifiedName) != null;
    }

    @Override
    public List<IProductCmptReference> findReferencesFor(List<IProductCmpt> cmpts) {
        ArrayList<IProductCmptReference> result = new ArrayList<IProductCmptReference>();
        for (IIpsElement iIpsElement : cmpts) {
            result.addAll(this.getReference(iIpsElement));
        }
        return result;
    }

    private List<IProductCmptReference> getReference(IIpsElement selectElement) {
        List<IProductCmptReference> result = this.getReferences(this.getRoot(), selectElement);
        IProductCmpt rootCmpt = this.getRoot().getProductCmpt();
        if (selectElement.equals(rootCmpt)) {
            result.add(this.getRoot());
        }
        return result;
    }

    private List<IProductCmptReference> getReferences(IProductCmptReference reference, IIpsElement selectElement) {
        IProductCmptReference[] children = this.getChildProductCmptReferences(reference);
        ArrayList<IProductCmptReference> result = new ArrayList<IProductCmptReference>();
        IProductCmptReference[] iProductCmptReferenceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IProductCmptReference child = iProductCmptReferenceArray[n2];
            if (selectElement.equals(child.getProductCmpt())) {
                result.add(child);
            }
            result.addAll(this.getReferences(child, selectElement));
            ++n2;
        }
        return result;
    }

    @Override
    public GregorianCalendar getValidTo() {
        return this.getRoot().getValidTo();
    }
}

