/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpttype;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.productcmpttype.Messages;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.type.IChangingOverTimeProperty;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;

public class ChangingOverTimePropertyValidator {
    public static final String PROPERTY_CHANGING_OVER_TIME = "changingOverTime";
    public static final String MSGCODE_PREFIX = "CHANGINGOVERTIMEPROPERTY-";
    public static final String MSGCODE_TYPE_DOES_NOT_ACCEPT_CHANGING_OVER_TIME = "CHANGINGOVERTIMEPROPERTY-TypeDoesNotAcceptChangingOverTime";
    private final IChangingOverTimeProperty property;
    private final IProductCmptType productCmptType;

    public ChangingOverTimePropertyValidator(IChangingOverTimeProperty property) {
        this.property = property;
        this.productCmptType = property.findProductCmptType(property.getIpsProject());
    }

    public void validateTypeDoesNotAcceptChangingOverTime(MessageList messageList) {
        if (this.productCmptType != null && !IpsStringUtils.isEmpty((String)this.property.getName()) && !this.productCmptType.isChangingOverTime() && this.property.isChangingOverTime()) {
            String changingOverTimePluralName = IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNamePlural();
            String text = MessageFormat.format(Messages.ProductCmptPropertyValidator_msgTypeDoesNotAcceptChangingOverTime, this.property.getName(), changingOverTimePluralName);
            messageList.add(Message.newError((String)MSGCODE_TYPE_DOES_NOT_ACCEPT_CHANGING_OVER_TIME, (String)text, (Object)this.property, (String[])new String[]{PROPERTY_CHANGING_OVER_TIME}));
        }
    }
}

