/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpttype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.SingleEventModification;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.productcmpttype.Messages;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.productcmpttype.IProductCmptCategory;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeMethod;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IOverridableElement;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductCmptCategory
extends AtomicIpsObjectPart
implements IProductCmptCategory {
    static final String XML_TAG_NAME = "Category";
    private boolean defaultForFormulaSignatureDefinitions;
    private boolean defaultForValidationRules;
    private boolean defaultForTableStructureUsages;
    private boolean defaultForPolicyCmptTypeAttributes;
    private boolean defaultForProductCmptTypeAttributes;
    private IProductCmptCategory.Position position = IProductCmptCategory.Position.LEFT;

    public ProductCmptCategory(IProductCmptType parent, String id) {
        super(parent, id);
    }

    @Override
    public IProductCmptType getProductCmptType() {
        return (IProductCmptType)this.getParent();
    }

    private ProductCmptType getProductCmptTypeImpl() {
        return (ProductCmptType)this.getProductCmptType();
    }

    @Override
    public boolean findIsContainingProperty(IProductCmptProperty property, IProductCmptType contextType, IIpsProject ipsProject) {
        if (contextType.findProductCmptProperty(property.getPropertyName(), ipsProject) == null) {
            return false;
        }
        String categoryName = ((ProductCmptType)contextType).getCategoryNameFor(property);
        if (IpsStringUtils.isNotEmpty((String)categoryName) && categoryName.equals(this.name)) {
            return true;
        }
        if (this.isDefaultFor(property)) {
            return IpsStringUtils.isEmpty((String)categoryName) || !contextType.findHasCategory(categoryName, ipsProject);
        }
        return false;
    }

    @Override
    public boolean isDefaultFor(IProductCmptProperty property) {
        ProductCmptPropertyType productCmptPropertyType = property.getProductCmptPropertyType();
        if (productCmptPropertyType == null) {
            return false;
        }
        return this.isDefaultFor(productCmptPropertyType);
    }

    @Override
    public boolean isDefaultFor(ProductCmptPropertyType propertyType) {
        return switch (propertyType) {
            case ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE -> this.isDefaultForPolicyCmptTypeAttributes();
            case ProductCmptPropertyType.PRODUCT_CMPT_TYPE_ATTRIBUTE -> this.isDefaultForProductCmptTypeAttributes();
            case ProductCmptPropertyType.VALIDATION_RULE -> this.isDefaultForValidationRules();
            case ProductCmptPropertyType.FORMULA_SIGNATURE_DEFINITION -> this.isDefaultForFormulaSignatureDefinitions();
            case ProductCmptPropertyType.TABLE_STRUCTURE_USAGE -> this.isDefaultForTableStructureUsages();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public List<IProductCmptProperty> findProductCmptProperties(IProductCmptType contextType, boolean searchSupertypeHierarchy, IIpsProject ipsProject) {
        class CategoryPropertyCollector
        extends TypeHierarchyVisitor<IProductCmptType> {
            private final List<IProductCmptProperty> properties;
            private final Set<String> overwritingProperties;
            private final /* synthetic */ boolean val$searchSupertypeHierarchy;

            private CategoryPropertyCollector(IIpsProject ipsProject, boolean bl) {
                this.val$searchSupertypeHierarchy = bl;
                super(ipsProject);
                this.properties = new ArrayList<IProductCmptProperty>();
                this.overwritingProperties = new HashSet<String>();
            }

            @Override
            protected boolean visit(IProductCmptType currentType) {
                for (IProductCmptProperty property : currentType.findProductCmptProperties(false, this.getIpsProject())) {
                    if (this.overwritingProperties.contains(property.getPropertyName())) continue;
                    if (this.isOverwriteProperty(property)) {
                        this.overwritingProperties.add(property.getPropertyName());
                    }
                    if (!this.isVisible(property) || !ProductCmptCategory.this.findIsContainingProperty(property, currentType, this.getIpsProject()) || this.properties.contains(property)) continue;
                    this.properties.add(property);
                }
                return this.val$searchSupertypeHierarchy;
            }

            private boolean isOverwriteProperty(IProductCmptProperty property) {
                if (property instanceof IAttribute) {
                    return ((IAttribute)((Object)property)).isOverwrite();
                }
                if (property instanceof IProductCmptTypeMethod) {
                    return ((IProductCmptTypeMethod)property).isOverloadsFormula();
                }
                return false;
            }

            private boolean isVisible(IProductCmptProperty property) {
                if (property instanceof IProductCmptTypeAttribute) {
                    return ((IProductCmptTypeAttribute)property).isVisible();
                }
                return true;
            }
        }
        CategoryPropertyCollector collector = new CategoryPropertyCollector(ipsProject, searchSupertypeHierarchy);
        collector.start(contextType);
        Collections.sort(collector.properties, new ProductCmptPropertyComparator(contextType));
        return collector.properties;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.valueChanged(oldValue, name, "name");
    }

    @Override
    public boolean isDefaultForFormulaSignatureDefinitions() {
        return this.defaultForFormulaSignatureDefinitions;
    }

    @Override
    public void setDefaultForFormulaSignatureDefinitions(boolean defaultForFormulaSignatureDefinitions) {
        boolean oldValue = this.defaultForFormulaSignatureDefinitions;
        this.defaultForFormulaSignatureDefinitions = defaultForFormulaSignatureDefinitions;
        this.valueChanged(oldValue, defaultForFormulaSignatureDefinitions, "defaultForFormulaSignatureDefinitions");
    }

    @Override
    public boolean isDefaultForPolicyCmptTypeAttributes() {
        return this.defaultForPolicyCmptTypeAttributes;
    }

    @Override
    public void setDefaultForPolicyCmptTypeAttributes(boolean defaultForPolicyCmptTypeAttributes) {
        boolean oldValue = this.defaultForPolicyCmptTypeAttributes;
        this.defaultForPolicyCmptTypeAttributes = defaultForPolicyCmptTypeAttributes;
        this.valueChanged(oldValue, defaultForPolicyCmptTypeAttributes, "defaultForPolicyCmptTypeAttributes");
    }

    @Override
    public boolean isDefaultForProductCmptTypeAttributes() {
        return this.defaultForProductCmptTypeAttributes;
    }

    @Override
    public void setDefaultForProductCmptTypeAttributes(boolean defaultForProductCmptTypeAttributes) {
        boolean oldValue = this.defaultForProductCmptTypeAttributes;
        this.defaultForProductCmptTypeAttributes = defaultForProductCmptTypeAttributes;
        this.valueChanged(oldValue, defaultForProductCmptTypeAttributes, "defaultForProductCmptTypeAttributes");
    }

    @Override
    public boolean isDefaultForTableStructureUsages() {
        return this.defaultForTableStructureUsages;
    }

    @Override
    public void setDefaultForTableStructureUsages(boolean defaultForTableStructureUsages) {
        boolean oldValue = this.defaultForTableStructureUsages;
        this.defaultForTableStructureUsages = defaultForTableStructureUsages;
        this.valueChanged(oldValue, defaultForTableStructureUsages, "defaultForTableStructureUsages");
    }

    @Override
    public boolean isDefaultForValidationRules() {
        return this.defaultForValidationRules;
    }

    @Override
    public void setDefaultForValidationRules(boolean defaultForValidationRules) {
        boolean oldValue = this.defaultForValidationRules;
        this.defaultForValidationRules = defaultForValidationRules;
        this.valueChanged(oldValue, defaultForValidationRules, "defaultForValidationRules");
    }

    @Override
    public void setPosition(IProductCmptCategory.Position side) {
        IProductCmptCategory.Position oldValue = this.position;
        this.position = side;
        this.getProductCmptTypeImpl().sortCategoriesAccordingToPosition();
        this.valueChanged((Object)oldValue, (Object)side, "position");
    }

    @Override
    public IProductCmptCategory.Position getPosition() {
        return this.position;
    }

    @Override
    public boolean isAtLeftPosition() {
        return this.position == IProductCmptCategory.Position.LEFT;
    }

    @Override
    public boolean isAtRightPosition() {
        return this.position == IProductCmptCategory.Position.RIGHT;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        if (!this.validateNameIsEmpty(list)) {
            return;
        }
        this.validateNameAlreadyUsedInTypeHierarchy(list, ipsProject);
        this.validateDuplicateDefaultsForFormulaSignatureDefinitions(list, ipsProject);
        this.validateDuplicateDefaultsForPolicyCmptTypeAttributes(list, ipsProject);
        this.validateDuplicateDefaultsForProductCmptTypeAttributes(list, ipsProject);
        this.validateDuplicateDefaultsForTableStructureUsages(list, ipsProject);
        this.validateDuplicateDefaultsForValidationRules(list, ipsProject);
    }

    private boolean validateNameIsEmpty(MessageList list) {
        if (IpsStringUtils.isEmpty((String)this.name)) {
            list.newError("ProductCmptCategory-NameIsEmpty", Messages.ProductCmptCategory_msgNameIsEmpty, (Object)this, new String[]{"name"});
            return false;
        }
        return true;
    }

    private boolean validateNameAlreadyUsedInTypeHierarchy(MessageList list, IIpsProject ipsProject) {
        if (this.getProductCmptTypeImpl().findIsCategoryNameUsedTwiceInSupertypeHierarchy(this.name, ipsProject)) {
            String text = MessageFormat.format(Messages.ProductCmptCategory_msgNameAlreadyUsedInTypeHierarchy, this.name, this.getProductCmptType().getName());
            list.newError("ProductCmptCategory-NameAlreadyUsedInTypeHierarchy", text, (Object)this, new String[]{"name"});
            return false;
        }
        return true;
    }

    private void validateDuplicateDefaultsForFormulaSignatureDefinitions(MessageList list, IIpsProject ipsProject) {
        if (!this.defaultForFormulaSignatureDefinitions) {
            return;
        }
        DuplicateDefaultFinder duplicateFinder = new DuplicateDefaultFinder(ProductCmptPropertyType.FORMULA_SIGNATURE_DEFINITION, ipsProject);
        duplicateFinder.start(this.getProductCmptType());
        duplicateFinder.addValidationMessageIfDuplicateFound(list, "ProductCmptCategory-DuplicateDefaultsForFormulaSignatureDefinitions", Messages.ProductCmptCategory_DuplicateDefaultsForFormulaSignatureDefinitions, "defaultForFormulaSignatureDefinitions");
    }

    private void validateDuplicateDefaultsForValidationRules(MessageList list, IIpsProject ipsProject) {
        if (!this.defaultForValidationRules) {
            return;
        }
        DuplicateDefaultFinder duplicateFinder = new DuplicateDefaultFinder(ProductCmptPropertyType.VALIDATION_RULE, ipsProject);
        duplicateFinder.start(this.getProductCmptType());
        duplicateFinder.addValidationMessageIfDuplicateFound(list, "ProductCmptCategory-DuplicateDefaultsForValidationRules", Messages.ProductCmptCategory_DuplicateDefaultsForValidationRules, "defaultForValidationRules");
    }

    private void validateDuplicateDefaultsForTableStructureUsages(MessageList list, IIpsProject ipsProject) {
        if (!this.defaultForTableStructureUsages) {
            return;
        }
        DuplicateDefaultFinder duplicateFinder = new DuplicateDefaultFinder(ProductCmptPropertyType.TABLE_STRUCTURE_USAGE, ipsProject);
        duplicateFinder.start(this.getProductCmptType());
        duplicateFinder.addValidationMessageIfDuplicateFound(list, "ProductCmptCategory-DuplicateDefaultsForTableStructureUsages", Messages.ProductCmptCategory_DuplicateDefaultsForTableStructureUsages, "defaultForTableStructureUsages");
    }

    private void validateDuplicateDefaultsForPolicyCmptTypeAttributes(MessageList list, IIpsProject ipsProject) {
        if (!this.defaultForPolicyCmptTypeAttributes) {
            return;
        }
        DuplicateDefaultFinder duplicateFinder = new DuplicateDefaultFinder(ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE, ipsProject);
        duplicateFinder.start(this.getProductCmptType());
        duplicateFinder.addValidationMessageIfDuplicateFound(list, "ProductCmptCategory-DuplicateDefaultsForPolicyCmptTypeAttributes", Messages.ProductCmptCategory_DuplicateDefaultsForPolicyCmptTypeAttributes, "defaultForPolicyCmptTypeAttributes");
    }

    private void validateDuplicateDefaultsForProductCmptTypeAttributes(MessageList list, IIpsProject ipsProject) {
        if (!this.defaultForProductCmptTypeAttributes) {
            return;
        }
        DuplicateDefaultFinder duplicateFinder = new DuplicateDefaultFinder(ProductCmptPropertyType.PRODUCT_CMPT_TYPE_ATTRIBUTE, ipsProject);
        duplicateFinder.start(this.getProductCmptType());
        duplicateFinder.addValidationMessageIfDuplicateFound(list, "ProductCmptCategory-DuplicateDefaultsForProductCmptTypeAttributes", Messages.ProductCmptCategory_DuplicateDefaultsForProductCmptTypeAttributes, "defaultForProductCmptTypeAttributes");
    }

    @Override
    public int[] moveProductCmptProperties(int[] indexes, boolean up, IProductCmptType contextType) {
        if (indexes.length == 0) {
            return new int[0];
        }
        List<IProductCmptProperty> contextProperties = this.findProductCmptProperties(contextType, false, contextType.getIpsProject());
        return ((ProductCmptType)contextType).movePropertyReferences(indexes, contextProperties, up);
    }

    @Override
    public boolean insertProductCmptProperty(final IProductCmptProperty property, final IProductCmptProperty targetProperty, final boolean above) {
        final IProductCmptType contextType = property.findProductCmptType(property.getIpsProject());
        if (contextType == null) {
            return false;
        }
        return ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<Boolean>(contextType.getIpsSrcFile()){
            private boolean result;
            {
                super($anonymous0);
                this.result = true;
            }

            @Override
            protected boolean execute() {
                int targetPropertyIndex;
                contextType.changeCategoryAndDeferPolicyChange(property, ProductCmptCategory.this.name);
                List<IProductCmptProperty> properties = ProductCmptCategory.this.findProductCmptProperties(contextType, false, contextType.getIpsProject());
                int propertyIndex = properties.indexOf(property);
                int n = targetPropertyIndex = targetProperty != null ? properties.indexOf(targetProperty) : properties.size() - 1;
                if (propertyIndex == -1 || targetPropertyIndex == -1) {
                    this.result = false;
                } else {
                    ProductCmptCategory.this.insertProductCmptProperty(propertyIndex, targetPropertyIndex, contextType, above);
                }
                return true;
            }

            @Override
            protected Boolean getResult() {
                return this.result;
            }
        });
    }

    private void insertProductCmptProperty(int propertyIndex, int targetPropertyIndex, IProductCmptType contextType, boolean above) {
        if (propertyIndex > targetPropertyIndex) {
            this.moveProductCmptPropertyUp(propertyIndex, targetPropertyIndex, contextType, above);
        } else if (propertyIndex < targetPropertyIndex) {
            this.moveProductCmptPropertyDown(propertyIndex, targetPropertyIndex, contextType, above);
        }
    }

    private void moveProductCmptPropertyUp(int propertyIndex, int targetPropertyIndex, IProductCmptType contextType, boolean above) {
        int targetIndex = above ? targetPropertyIndex : targetPropertyIndex + 1;
        int i = propertyIndex;
        while (i > targetIndex) {
            this.moveProductCmptProperties(new int[]{i--}, true, contextType);
        }
    }

    private void moveProductCmptPropertyDown(int propertyIndex, int targetPropertyIndex, IProductCmptType contextType, boolean above) {
        int targetIndex = above ? targetPropertyIndex - 1 : targetPropertyIndex;
        int i = propertyIndex;
        while (i < targetIndex) {
            this.moveProductCmptProperties(new int[]{i++}, false, contextType);
        }
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        this.name = element.getAttribute("name");
        this.defaultForFormulaSignatureDefinitions = XmlUtil.getBooleanAttributeOrFalse(element, "defaultForFormulaSignatureDefinitions");
        this.defaultForPolicyCmptTypeAttributes = XmlUtil.getBooleanAttributeOrFalse(element, "defaultForPolicyCmptTypeAttributes");
        this.defaultForProductCmptTypeAttributes = XmlUtil.getBooleanAttributeOrFalse(element, "defaultForProductCmptTypeAttributes");
        this.defaultForTableStructureUsages = XmlUtil.getBooleanAttributeOrFalse(element, "defaultForTableStructureUsages");
        this.defaultForValidationRules = XmlUtil.getBooleanAttributeOrFalse(element, "defaultForValidationRules");
        this.position = IProductCmptCategory.Position.getValueById(element.getAttribute("position"));
        super.initPropertiesFromXml(element, id);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("name", this.name);
        if (this.defaultForFormulaSignatureDefinitions) {
            element.setAttribute("defaultForFormulaSignatureDefinitions", Boolean.toString(this.defaultForFormulaSignatureDefinitions));
        }
        if (this.defaultForPolicyCmptTypeAttributes) {
            element.setAttribute("defaultForPolicyCmptTypeAttributes", Boolean.toString(this.defaultForPolicyCmptTypeAttributes));
        }
        if (this.defaultForProductCmptTypeAttributes) {
            element.setAttribute("defaultForProductCmptTypeAttributes", Boolean.toString(this.defaultForProductCmptTypeAttributes));
        }
        if (this.defaultForTableStructureUsages) {
            element.setAttribute("defaultForTableStructureUsages", Boolean.toString(this.defaultForTableStructureUsages));
        }
        if (this.defaultForValidationRules) {
            element.setAttribute("defaultForValidationRules", Boolean.toString(this.defaultForValidationRules));
        }
        element.setAttribute("position", this.position.getId());
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(XML_TAG_NAME);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isOverriding(IProductCmptProperty property) {
        IProductCmptProperty iProductCmptProperty = property;
        if (iProductCmptProperty instanceof IOverridableElement) {
            void overridable;
            IOverridableElement iOverridableElement = (IOverridableElement)((Object)iProductCmptProperty);
            IOverridableElement cfr_ignored_0 = (IOverridableElement)((Object)iProductCmptProperty);
            if (overridable.isOverriding()) {
                return true;
            }
        }
        return false;
    }

    private class DuplicateDefaultFinder
    extends TypeHierarchyVisitor<IProductCmptType> {
        private final ProductCmptPropertyType propertyType;
        private boolean duplicateDefaultFound;

        protected DuplicateDefaultFinder(ProductCmptPropertyType propertyType, IIpsProject ipsProject) {
            super(ipsProject);
            this.propertyType = propertyType;
        }

        @Override
        protected boolean visit(IProductCmptType currentType) {
            for (IProductCmptCategory category : currentType.getCategories()) {
                if (!category.isDefaultFor(this.propertyType) || ProductCmptCategory.this.name.equals(category.getName())) continue;
                this.duplicateDefaultFound = true;
                return false;
            }
            return true;
        }

        private void addValidationMessageIfDuplicateFound(MessageList list, String code, String text, String invalidProperty) {
            if (this.duplicateDefaultFound) {
                list.newWarning(code, text, (Object)ProductCmptCategory.this, new String[]{invalidProperty});
            }
        }
    }

    static class ProductCmptPropertyComparator
    implements Comparator<IProductCmptProperty> {
        private final IProductCmptType productCmptType;
        private final List<String> categories;

        ProductCmptPropertyComparator(IProductCmptType productCmptType) {
            this.productCmptType = productCmptType;
            this.categories = productCmptType.getCategories().stream().map(IIpsElement::getName).collect(Collectors.toList());
        }

        @Override
        public int compare(IProductCmptProperty property1, IProductCmptProperty property2) {
            IProductCmptProperty prop2;
            IProductCmptProperty prop1 = this.getOverriddenProperty(property1);
            int subtypeCompare = this.compareSubtypeRelationship(prop1, prop2 = this.getOverriddenProperty(property2));
            return subtypeCompare != 0 ? subtypeCompare : this.comparePropertyIndices(prop1, prop2);
        }

        /*
         * WARNING - void declaration
         */
        private IProductCmptProperty getOverriddenProperty(IProductCmptProperty property) {
            IProductCmptProperty iProductCmptProperty = property;
            if (iProductCmptProperty instanceof IOverridableElement) {
                void overridable;
                IOverridableElement iOverridableElement = (IOverridableElement)((Object)iProductCmptProperty);
                IOverridableElement cfr_ignored_0 = (IOverridableElement)((Object)iProductCmptProperty);
                if (overridable.isOverriding()) {
                    IProductCmptProperty overriddenProperty = (IProductCmptProperty)((Object)overridable.findOverriddenElement(property.getIpsProject()));
                    return this.getOverriddenProperty(overriddenProperty);
                }
            }
            return property;
        }

        private int compareSubtypeRelationship(IProductCmptProperty property1, IProductCmptProperty property2) {
            IProductCmptType productCmptType2;
            IProductCmptType productCmptType1;
            try {
                productCmptType1 = property1.findProductCmptType(this.productCmptType.getIpsProject());
                productCmptType2 = property2.findProductCmptType(this.productCmptType.getIpsProject());
            }
            catch (IpsException e) {
                IpsLog.log(e);
                return 0;
            }
            if (productCmptType1 == null || productCmptType2 == null || productCmptType1.equals(productCmptType2)) {
                return 0;
            }
            if (productCmptType1.isSubtypeOf(productCmptType2, this.productCmptType.getIpsProject())) {
                return 1;
            }
            return -1;
        }

        private int comparePropertyIndices(IProductCmptProperty property1, IProductCmptProperty property2) {
            String category2;
            IProductCmptType contextType = null;
            try {
                contextType = property1.findProductCmptType(property1.getIpsProject());
            }
            catch (IpsException e) {
                IpsLog.log(e);
                return 0;
            }
            if (contextType == null) {
                return 0;
            }
            String category1 = this.findCategory(property1, contextType);
            if (!category1.equals(category2 = this.findCategory(property2, contextType))) {
                int categoryIndex1 = this.categories.indexOf(category1);
                int categoryIndex2 = this.categories.indexOf(category2);
                return categoryIndex1 - categoryIndex2;
            }
            int index1 = ((ProductCmptType)contextType).getCategoryPositionFor(property1);
            int index2 = ((ProductCmptType)contextType).getCategoryPositionFor(property2);
            if (index1 == -1) {
                index1 = Integer.MAX_VALUE;
            }
            if (index2 == -1) {
                index2 = Integer.MAX_VALUE;
            }
            return index1 - index2;
        }

        private String findCategory(IProductCmptProperty property, IProductCmptType contextType) {
            String category = ((ProductCmptType)contextType).getCategoryNameFor(property);
            if (IpsStringUtils.isBlank((String)category)) {
                IIpsProject ipsProject = contextType.getIpsProject();
                return switch (property.getProductCmptPropertyType()) {
                    case ProductCmptPropertyType.FORMULA_SIGNATURE_DEFINITION -> contextType.findDefaultCategoryForFormulaSignatureDefinitions(ipsProject).getName();
                    case ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE -> contextType.findDefaultCategoryForPolicyCmptTypeAttributes(ipsProject).getName();
                    case ProductCmptPropertyType.PRODUCT_CMPT_TYPE_ATTRIBUTE -> contextType.findDefaultCategoryForProductCmptTypeAttributes(ipsProject).getName();
                    case ProductCmptPropertyType.TABLE_STRUCTURE_USAGE -> contextType.findDefaultCategoryForTableStructureUsages(ipsProject).getName();
                    case ProductCmptPropertyType.VALIDATION_RULE -> contextType.findDefaultCategoryForValidationRules(ipsProject).getName();
                    default -> category;
                };
            }
            return category;
        }
    }
}

