/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpttype;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.DependencyType;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.SingleEventModification;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartContainer;
import org.faktorips.devtools.model.internal.productcmpttype.Messages;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptCategory;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptPropertyReference;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptTypeAssociation;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptTypeAttribute;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptTypeMethod;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptTypeValidations;
import org.faktorips.devtools.model.internal.productcmpttype.TableStructureUsage;
import org.faktorips.devtools.model.internal.type.DuplicatePropertyNameValidator;
import org.faktorips.devtools.model.internal.type.Type;
import org.faktorips.devtools.model.internal.util.TreeSetHelper;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpt.IFormula;
import org.faktorips.devtools.model.productcmpttype.FormulaSignatureFinder;
import org.faktorips.devtools.model.productcmpttype.IProductCmptCategory;
import org.faktorips.devtools.model.productcmpttype.IProductCmptPropertyReference;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeMethod;
import org.faktorips.devtools.model.productcmpttype.ITableStructureUsage;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IChangingOverTimeProperty;
import org.faktorips.devtools.model.type.IMethod;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.ITypePart;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.util.SubListElementMover;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductCmptType
extends Type
implements IProductCmptType {
    private boolean layerSupertype = false;
    private boolean configurationForPolicyCmptType = true;
    private String policyCmptType = "";
    private String instancesIconPath = null;
    private boolean changingOverTime = this.getIpsProject().getReadOnlyProperties().isChangingOverTimeDefaultEnabled();
    private final IpsObjectPartCollection<IProductCmptTypeAttribute> attributes;
    private final IpsObjectPartCollection<ITableStructureUsage> tableStructureUsages;
    private final IpsObjectPartCollection<IProductCmptTypeMethod> methods;
    private final IpsObjectPartCollection<IProductCmptTypeAssociation> associations;
    private final IpsObjectPartCollection<IProductCmptCategory> categories;
    @Deprecated(forRemoval=true, since="22.6")
    private final IpsObjectPartCollection<IProductCmptPropertyReference> propertyReferences;
    private Map<IProductCmptProperty, Map<CategoryChange, String>> pendingPolicyChanges = new HashMap<IProductCmptProperty, Map<CategoryChange, String>>();

    public ProductCmptType(IIpsSrcFile file) {
        super(file);
        this.tableStructureUsages = new IpsObjectPartCollection<ITableStructureUsage>(this, TableStructureUsage.class, ITableStructureUsage.class, "TableStructureUsage");
        this.attributes = new IpsObjectPartCollection<IProductCmptTypeAttribute>(this, ProductCmptTypeAttribute.class, IProductCmptTypeAttribute.class, "Attribute");
        this.methods = new IpsObjectPartCollection<IProductCmptTypeMethod>(this, ProductCmptTypeMethod.class, IProductCmptTypeMethod.class, "Method");
        this.associations = new IpsObjectPartCollection<IProductCmptTypeAssociation>(this, ProductCmptTypeAssociation.class, IProductCmptTypeAssociation.class, "Association");
        this.categories = new IpsObjectPartCollection<IProductCmptCategory>(this, ProductCmptCategory.class, IProductCmptCategory.class, "Category");
        this.propertyReferences = new IpsObjectPartCollection<IProductCmptPropertyReference>(this, ProductCmptPropertyReference.class, IProductCmptPropertyReference.class, "ProductCmptPropertyReference");
    }

    protected IpsObjectPartCollection<IProductCmptTypeAttribute> getAttributesPartCollection() {
        return this.attributes;
    }

    protected IpsObjectPartCollection<IProductCmptTypeAssociation> getAssociationPartCollection() {
        return this.associations;
    }

    protected IpsObjectPartCollection<IProductCmptTypeMethod> getMethodPartCollection() {
        return this.methods;
    }

    @Override
    public IProductCmptType findSupertype(IIpsProject project) {
        if (!this.hasSupertype()) {
            return null;
        }
        IProductCmptType supertype = this.findSuperProductCmptType(project);
        if (supertype != null) {
            return supertype;
        }
        return null;
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.PRODUCT_CMPT_TYPE;
    }

    @Override
    public String getPolicyCmptType() {
        return this.policyCmptType;
    }

    @Override
    public void setPolicyCmptType(String newType) {
        String oldType = this.policyCmptType;
        this.policyCmptType = newType;
        this.valueChanged(oldType, newType);
    }

    @Override
    public boolean isConfigurationForPolicyCmptType() {
        return this.configurationForPolicyCmptType;
    }

    @Override
    public void setConfigurationForPolicyCmptType(boolean newValue) {
        boolean oldValue = this.configurationForPolicyCmptType;
        this.configurationForPolicyCmptType = newValue;
        if (!newValue && oldValue) {
            this.policyCmptType = "";
        }
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public void setLayerSupertype(boolean layerSupertype) {
        boolean oldValue = this.layerSupertype;
        this.layerSupertype = layerSupertype;
        this.valueChanged(oldValue, layerSupertype, "layerSupertype");
    }

    @Override
    public boolean isLayerSupertype() {
        return this.layerSupertype;
    }

    @Override
    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    @Override
    public void setChangingOverTime(boolean changesOverTime) {
        boolean oldValue = this.changingOverTime;
        this.changingOverTime = changesOverTime;
        this.valueChanged(oldValue, changesOverTime, "changingOverTime");
    }

    @Override
    public IPolicyCmptType findPolicyCmptType(IIpsProject ipsProject) {
        if (!this.configurationForPolicyCmptType) {
            return null;
        }
        return ipsProject.findPolicyCmptType(this.policyCmptType);
    }

    @Override
    public IProductCmptType findSuperProductCmptType(IIpsProject project) {
        return (IProductCmptType)project.findIpsObject(IpsObjectType.PRODUCT_CMPT_TYPE, this.getSupertype());
    }

    @Deprecated(forRemoval=true, since="22.6")
    @CheckForNull
    IProductCmptProperty findProductCmptProperty(IProductCmptPropertyReference reference, IIpsProject ipsProject) {
        for (IProductCmptProperty property : this.findProductCmptProperties(false, ipsProject)) {
            if (!reference.isReferencedProperty(property)) continue;
            return property;
        }
        return null;
    }

    @Override
    public List<IProductCmptProperty> findProductCmptProperties(IIpsProject ipsProject) {
        return this.findProductCmptProperties(true, ipsProject);
    }

    @Override
    public List<IProductCmptProperty> findProductCmptProperties(boolean searchSupertypeHierarchy, IIpsProject ipsProject) {
        return this.findProductCmptProperties(null, searchSupertypeHierarchy, ipsProject);
    }

    @Override
    public List<IProductCmptProperty> findProductCmptProperties(ProductCmptPropertyType propertyType, boolean searchSupertypeHierarchy, IIpsProject ipsProject) {
        ProductCmptPropertyCollector collector = new ProductCmptPropertyCollector(propertyType, searchSupertypeHierarchy, ipsProject);
        collector.start(this);
        return collector.getProperties();
    }

    @Override
    public IProductCmptProperty findProductCmptProperty(String propertyName, IIpsProject ipsProject) {
        ProductCmptPropertyType[] productCmptPropertyTypeArray = ProductCmptPropertyType.values();
        int n = productCmptPropertyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProductCmptPropertyType type = productCmptPropertyTypeArray[n2];
            IProductCmptProperty property = this.findProductCmptProperty(type, propertyName, ipsProject);
            if (property != null) {
                return property;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IProductCmptProperty findProductCmptProperty(ProductCmptPropertyType type, String propName, IIpsProject ipsProject) {
        if (ProductCmptPropertyType.PRODUCT_CMPT_TYPE_ATTRIBUTE == type) {
            return this.findProductCmptTypeAttribute(propName, ipsProject);
        }
        if (ProductCmptPropertyType.FORMULA_SIGNATURE_DEFINITION == type) {
            return this.findFormulaSignature(propName, ipsProject);
        }
        if (ProductCmptPropertyType.TABLE_STRUCTURE_USAGE == type) {
            return this.findTableStructureUsage(propName, ipsProject);
        }
        return this.findProductCmptPropertyInPolicy(type, propName, ipsProject);
    }

    private IProductCmptProperty findProductCmptPropertyInPolicy(ProductCmptPropertyType type, String propName, IIpsProject ipsProject) {
        IPolicyCmptTypeAttribute attr;
        IValidationRule rule;
        IPolicyCmptType foundPolicyCmptType = this.findPolicyCmptType(ipsProject);
        if (foundPolicyCmptType == null) {
            return null;
        }
        if (ProductCmptPropertyType.VALIDATION_RULE == type && (rule = foundPolicyCmptType.findValidationRule(propName, ipsProject)) != null && rule.isConfigurableByProductComponent()) {
            return rule;
        }
        if (ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE == type && (attr = foundPolicyCmptType.findPolicyCmptTypeAttribute(propName, ipsProject)) != null && attr.isProductRelevant()) {
            return attr;
        }
        return null;
    }

    public Map<String, IProductCmptProperty> findProductCmptPropertyMap(IIpsProject ipsProject) {
        ProductCmptPropertyCollector collector = new ProductCmptPropertyCollector(null, true, ipsProject);
        collector.start(this);
        return collector.getPropertyMap();
    }

    public Map<String, IProductCmptProperty> findProductCmptPropertyMap(ProductCmptPropertyType propertyType, IIpsProject ipsProject) {
        ProductCmptPropertyCollector collector = new ProductCmptPropertyCollector(propertyType, true, ipsProject);
        collector.start(this);
        return collector.getPropertyMap();
    }

    @Override
    public List<IProductCmptTypeAssociation> findAllNotDerivedAssociations(IIpsProject ipsProject) {
        NotDerivedAssociationCollector collector = new NotDerivedAssociationCollector(ipsProject);
        collector.start(this);
        return collector.getAssociationsFound();
    }

    @Override
    public IProductCmptTypeAttribute newProductCmptTypeAttribute() {
        return (IProductCmptTypeAttribute)this.newAttribute();
    }

    @Override
    public IProductCmptTypeAttribute newProductCmptTypeAttribute(String name) {
        IProductCmptTypeAttribute newAttribute = this.newProductCmptTypeAttribute();
        newAttribute.setName(name);
        return newAttribute;
    }

    @Override
    public IProductCmptTypeAttribute getProductCmptTypeAttribute(String name) {
        return this.attributes.getPartByName(name);
    }

    @Override
    public IProductCmptTypeAttribute findProductCmptTypeAttribute(String name, IIpsProject ipsProject) {
        return (IProductCmptTypeAttribute)this.findAttribute(name, ipsProject);
    }

    @Override
    public List<IProductCmptTypeAttribute> getProductCmptTypeAttributes() {
        return this.attributes.asList();
    }

    @Override
    protected void initFromXml(Element element, String id) {
        this.pendingPolicyChanges.clear();
        super.initFromXml(element, id);
    }

    @Deprecated(forRemoval=true, since="22.6")
    public void migrateReferences() {
        int n = this.getChildren().length;
        int i = 0;
        while (i < this.propertyReferences.size()) {
            IProductCmptPropertyReference part = this.propertyReferences.getPart(i);
            IProductCmptProperty productCmptProperty = part.findProductCmptProperty(this.getIpsProject());
            if (productCmptProperty != null) {
                productCmptProperty.setCategoryPosition(i + n);
            }
            ++i;
        }
        IPolicyCmptType policyType = this.findPolicyCmptType(this.getIpsProject());
        for (IProductCmptCategory category : this.findCategories(this.getIpsProject())) {
            List<IProductCmptProperty> propertiesInCategory = category.findProductCmptProperties(this, true, this.getIpsProject());
            int i2 = 0;
            for (IProductCmptProperty property : propertiesInCategory) {
                if (property.getParent() == this || property.getParent() == policyType) {
                    property.setCategoryPosition(++i2);
                    continue;
                }
                i2 = property.getCategoryPosition();
            }
        }
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.policyCmptType = XmlUtil.getAttributeOrEmptyString(element, "policyCmptType");
        this.configurationForPolicyCmptType = XmlUtil.getBooleanAttributeOrFalse(element, "configurationForPolicyCmptType");
        this.layerSupertype = XmlUtil.getBooleanAttributeOrFalse(element, "layerSupertype");
        this.instancesIconPath = XmlUtil.getAttributeOrEmptyString(element, "instancesIcon");
        if (element.hasAttribute("changingOverTime")) {
            this.changingOverTime = Boolean.parseBoolean(element.getAttribute("changingOverTime"));
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (this.configurationForPolicyCmptType) {
            element.setAttribute("configurationForPolicyCmptType", String.valueOf(this.configurationForPolicyCmptType));
        }
        if (this.layerSupertype) {
            element.setAttribute("layerSupertype", String.valueOf(this.layerSupertype));
        }
        if (IpsStringUtils.isNotEmpty((String)this.policyCmptType)) {
            element.setAttribute("policyCmptType", this.policyCmptType);
        }
        if (IpsStringUtils.isNotEmpty((String)this.instancesIconPath)) {
            element.setAttribute("instancesIcon", this.instancesIconPath);
        }
        element.setAttribute("changingOverTime", String.valueOf(this.changingOverTime));
    }

    @Override
    public Element toXml(Document doc) {
        Element element = super.toXml(doc);
        if (!this.pendingPolicyChanges.isEmpty()) {
            this.savePendingPolicyChanges();
        }
        return element;
    }

    private void savePendingPolicyChanges() {
        IProductCmptProperty[] policyProperties = this.pendingPolicyChanges.keySet().toArray(new IProductCmptProperty[this.pendingPolicyChanges.size()]);
        IIpsSrcFile policySrcFile = policyProperties[0].getIpsSrcFile();
        if (policySrcFile.isMutable()) {
            boolean isDirtyState = policySrcFile.isDirty();
            for (IProductCmptProperty property : this.pendingPolicyChanges.keySet()) {
                property.setCategory(this.pendingPolicyChanges.get(property).get((Object)CategoryChange.NAME));
                String stringPosition = this.pendingPolicyChanges.get(property).get((Object)CategoryChange.POSITION);
                int position = -1;
                if (stringPosition != null) {
                    position = Integer.parseInt(stringPosition);
                }
                property.setCategoryPosition(position);
            }
            if (!isDirtyState) {
                policySrcFile.save(null);
            }
        }
        this.pendingPolicyChanges.clear();
    }

    @Override
    public IProductCmptTypeAssociation newProductCmptTypeAssociation() {
        return (IProductCmptTypeAssociation)this.newAssociation();
    }

    @Override
    public ITableStructureUsage findTableStructureUsage(String roleName, IIpsProject project) {
        TableStructureUsageFinder finder = new TableStructureUsageFinder(project, roleName);
        finder.start(this);
        return finder.tsu;
    }

    @Override
    public int getNumOfTableStructureUsages() {
        return this.tableStructureUsages.size();
    }

    @Override
    public ITableStructureUsage getTableStructureUsage(String roleName) {
        return this.tableStructureUsages.getPartByName(roleName);
    }

    @Override
    public List<ITableStructureUsage> getTableStructureUsages() {
        return this.tableStructureUsages.asList();
    }

    @Override
    public int[] moveTableStructureUsage(int[] indexes, boolean up) {
        return this.tableStructureUsages.moveParts(indexes, up);
    }

    @Override
    public ITableStructureUsage newTableStructureUsage() {
        return this.tableStructureUsages.newPart();
    }

    @Override
    public List<IProductCmptTypeMethod> getProductCmptTypeMethods() {
        return this.methods.asList();
    }

    @Override
    public List<IProductCmptTypeAssociation> getProductCmptTypeAssociations() {
        return this.associations.asList();
    }

    @Override
    public List<IProductCmptTypeMethod> getNonFormulaProductCmptTypeMethods() {
        ArrayList<IProductCmptTypeMethod> result = new ArrayList<IProductCmptTypeMethod>();
        for (IProductCmptTypeMethod method : this.methods) {
            if (method.isFormulaSignatureDefinition()) continue;
            result.add(method);
        }
        return result;
    }

    @Override
    public IProductCmptTypeMethod newProductCmptTypeMethod() {
        return this.methods.newPart();
    }

    @Override
    public IProductCmptTypeMethod newFormulaSignature(String formulaName) {
        IProductCmptTypeMethod signature = this.newProductCmptTypeMethod();
        signature.setFormulaSignatureDefinition(true);
        signature.setFormulaName(formulaName);
        signature.setName(signature.getDefaultMethodName());
        return signature;
    }

    @Override
    public List<IProductCmptTypeMethod> findSignaturesOfOverloadedFormulas(IIpsProject ipsProject) {
        ArrayList<IProductCmptTypeMethod> overloadedMethods = new ArrayList<IProductCmptTypeMethod>();
        for (IProductCmptTypeMethod method : this.methods) {
            IProductCmptTypeMethod overloadedMethod;
            if (!method.isFormulaSignatureDefinition() || !method.isOverloadsFormula() || (overloadedMethod = method.findOverloadedFormulaMethod(ipsProject)) == null) continue;
            overloadedMethods.add(overloadedMethod);
        }
        return overloadedMethods;
    }

    @Override
    public IProductCmptTypeMethod getFormulaSignature(String formulaName) {
        if (IpsStringUtils.isEmpty((String)formulaName)) {
            return null;
        }
        for (IProductCmptTypeMethod method : this.methods) {
            if (!method.isFormulaSignatureDefinition() || !formulaName.equalsIgnoreCase(method.getFormulaName())) continue;
            return method;
        }
        return null;
    }

    @Override
    public List<IProductCmptTypeMethod> getFormulaSignatures() {
        ArrayList<IProductCmptTypeMethod> result = new ArrayList<IProductCmptTypeMethod>();
        for (IProductCmptTypeMethod method : this.methods) {
            if (!method.isFormulaSignatureDefinition()) continue;
            result.add(method);
        }
        return result;
    }

    @Override
    public IProductCmptTypeMethod findFormulaSignature(String formulaName, IIpsProject ipsProject) {
        FormulaSignatureFinder finder = new FormulaSignatureFinder(ipsProject, formulaName, true);
        finder.start(this);
        return (IProductCmptTypeMethod)(finder.getMethods().size() != 0 ? finder.getMethods().get(0) : null);
    }

    @Override
    public List<IMethod> findOverrideMethodCandidates(boolean onlyNotImplementedAbstractMethods, IIpsProject ipsProject) {
        List<IMethod> candidates = super.findOverrideMethodCandidates(onlyNotImplementedAbstractMethods, ipsProject);
        List<IProductCmptTypeMethod> overloadedMethods = this.findSignaturesOfOverloadedFormulas(ipsProject);
        ArrayList<IMethod> result = new ArrayList<IMethod>(candidates.size());
        for (IMethod candidate : candidates) {
            if (overloadedMethods.contains(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        IProductCmptType supertype = this.findSuperProductCmptType(ipsProject);
        if (this.isConfigurationForPolicyCmptType()) {
            this.validatePolicyCmptTypeReference(supertype, ipsProject, list);
        } else if (supertype != null && supertype.isConfigurationForPolicyCmptType()) {
            String text = Messages.ProductCmptType_TypeMustConfigureAPolicyCmptTypeIfSupertypeDoes;
            list.add(new Message("ProductCmptType-MustHaveSameValueForPolicyCmptType", text, Message.ERROR, (Object)this, new String[]{"configurationForPolicyCmptType"}));
        }
        this.validateLayerSupertype(list, ipsProject);
        this.validateProductCmptTypeAbstractWhenPolicyCmptTypeAbstract(list, ipsProject);
        this.validateSuperProductCmptTypeHasSameChangingOverTimeSetting(supertype, list);
        this.validateIfAnOverrideOfOverloadedFormulaExists(list, ipsProject);
        this.validateIconPath(list, ipsProject);
        this.validateDefaultCategoryForFormulaSignatureDefinition(list, ipsProject);
        this.validateDefaultCategoryForPolicyCmptTypeAttribute(list, ipsProject);
        this.validateDefaultCategoryForProductCmptTypeAttribute(list, ipsProject);
        this.validateDefaultCategoryForTableStructureUsages(list, ipsProject);
        this.validateDefaultCategoryForValidationRules(list, ipsProject);
    }

    private void validateSuperProductCmptTypeHasSameChangingOverTimeSetting(IProductCmptType superProductCmptType, MessageList list) {
        ProductCmptTypeValidations.validateSuperProductCmptTypeHasSameChangingOverTimeSetting(list, this, superProductCmptType);
    }

    private void validateLayerSupertype(MessageList list, IIpsProject ipsProject) {
        IProductCmptType supertype;
        if (this.isLayerSupertype() && this.hasSupertype() && (supertype = this.findSupertype(ipsProject)) != null && !supertype.isLayerSupertype()) {
            String text = MessageFormat.format(Messages.ProductCmptType_error_supertypeNotMarkedAsLayerSupertype, supertype.getName());
            list.add(new Message("ProductCmptType-SupertypeNotMarkedAsLayerSupertype", text, Message.ERROR, (Object)this, new String[]{"layerSupertype"}));
        }
    }

    private void validateIfAnOverrideOfOverloadedFormulaExists(MessageList msgList, IIpsProject ipsProject) {
        ArrayList<IProductCmptTypeMethod> overloadedSupertypeFormulaSignatures = new ArrayList<IProductCmptTypeMethod>();
        List<IProductCmptTypeMethod> formulaSignatures = this.getFormulaSignatures();
        for (IProductCmptTypeMethod formulaSignature : formulaSignatures) {
            IProductCmptTypeMethod method;
            if (!formulaSignature.isOverloadsFormula() || (method = formulaSignature.findOverloadedFormulaMethod(ipsProject)) == null) continue;
            overloadedSupertypeFormulaSignatures.add(method);
        }
        List<IProductCmptTypeMethod> nonFormulas = this.getNonFormulaProductCmptTypeMethods();
        for (IProductCmptTypeMethod overloadedMethod : overloadedSupertypeFormulaSignatures) {
            for (IProductCmptTypeMethod nonFormula : nonFormulas) {
                if (!nonFormula.isSameSignature(overloadedMethod)) continue;
                String text = MessageFormat.format(Messages.ProductCmptType_msgOverloadedFormulaMethodCannotBeOverridden, overloadedMethod.getFormulaName());
                msgList.add(new Message("ProductCmptType-OverloadedFormulaCannotBeOverridden", text, Message.ERROR, (Object)nonFormula, new String[]{"name"}));
            }
        }
    }

    private void validateIconPath(MessageList msgList, IIpsProject ipsProject) {
        if (this.isUseCustomInstanceIcon()) {
            InputStream stream = ipsProject.getResourceAsStream(this.getInstancesIcon());
            if (stream == null) {
                String text = String.valueOf(Messages.ProductCmptType_iconFileCannotBeResolved) + this.getInstancesIcon() + "\".";
                msgList.add(new Message("ProductCmptType-IconPathInvalid", text, Message.ERROR, (Object)this, new String[]{"instancesIcon"}));
            } else {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new IpsException((IStatus)new IpsStatus(e));
                }
            }
        }
    }

    @Override
    public DuplicatePropertyNameValidator createDuplicatePropertyNameValidator(IIpsProject ipsProject) {
        return new ProductCmptTypeDuplicatePropertyNameValidator(ipsProject);
    }

    private void validateProductCmptTypeAbstractWhenPolicyCmptTypeAbstract(MessageList msgList, IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.getPolicyCmptType())) {
            return;
        }
        IPolicyCmptType foundPolicyCmptType = this.findPolicyCmptType(ipsProject);
        if (foundPolicyCmptType != null) {
            msgList.add(ProductCmptTypeValidations.validateProductCmptTypeAbstractWhenPolicyCmptTypeAbstract(foundPolicyCmptType.isAbstract(), this.isAbstract(), this));
        }
    }

    private void validatePolicyCmptTypeReference(IProductCmptType supertype, IIpsProject ipsProject, MessageList list) {
        IPolicyCmptType policyCmptTypeObj = this.findPolicyCmptType(ipsProject);
        if (policyCmptTypeObj == null) {
            String text = MessageFormat.format(Messages.ProductCmptType_PolicyCmptTypeDoesNotExist, this.policyCmptType);
            list.add(new Message("ProductCmptType-PolicyCmptTypeDoesNotExist", text, Message.ERROR, (Object)this, new String[]{"policyCmptType"}));
            return;
        }
        if (!policyCmptTypeObj.isConfigurableByProductCmptType()) {
            String text = MessageFormat.format(Messages.ProductCmptType_notMarkedAsConfigurable, this.policyCmptType);
            list.add(new Message("ProductCmptType-PolicyCmptTypeNotMarkedAsConfigurable", text, Message.ERROR, (Object)this, new String[]{"policyCmptType"}));
            return;
        }
        if (!this.isSubtypeOrSameType(policyCmptTypeObj.findProductCmptType(ipsProject), ipsProject)) {
            String text = MessageFormat.format(Messages.ProductCmptType_policyCmptTypeDoesNotSpecifyThisType, this.policyCmptType);
            list.add(new Message("ProductCmptType-PolicyCmptTypeDoesNotExist", text, Message.ERROR, (Object)this, new String[]{"policyCmptType"}));
            return;
        }
        Message msg = ProductCmptTypeValidations.validateSupertype(this, supertype, policyCmptTypeObj.getQualifiedName(), policyCmptTypeObj.getSupertype(), ipsProject);
        if (msg != null) {
            list.add(msg);
        }
        if (!policyCmptTypeObj.isValid(policyCmptTypeObj.getIpsProject())) {
            String text = MessageFormat.format(Messages.ProductCmptType_policyCmptTypeNotValid, this.policyCmptType);
            list.add(new Message("ProductCmptType-PolicyCmptTypeNotValid", text, Message.WARNING, (Object)this, new String[]{"policyCmptType"}));
        }
    }

    private void validateDefaultCategoryForFormulaSignatureDefinition(MessageList list, IIpsProject ipsProject) {
        boolean propertyTypeExistsInTypeHierarchy;
        boolean bl = propertyTypeExistsInTypeHierarchy = this.findProductCmptProperties(ProductCmptPropertyType.FORMULA_SIGNATURE_DEFINITION, true, ipsProject).size() > 0;
        if (propertyTypeExistsInTypeHierarchy && this.findDefaultCategoryForFormulaSignatureDefinitions(ipsProject) == null) {
            String text = MessageFormat.format(Messages.ProductCmptCategory_NoDefaultForFormulaSignatureDefinitions, this.getName());
            list.newError("ProductCmptType-NoDefaultCategoryForFormulaSignatureDefinitions", text, (Object)this, new String[0]);
        }
    }

    private void validateDefaultCategoryForPolicyCmptTypeAttribute(MessageList list, IIpsProject ipsProject) {
        boolean propertyTypeExistsInTypeHierarchy;
        boolean bl = propertyTypeExistsInTypeHierarchy = this.findProductCmptProperties(ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE, true, ipsProject).size() > 0;
        if (propertyTypeExistsInTypeHierarchy && this.findDefaultCategoryForPolicyCmptTypeAttributes(ipsProject) == null) {
            String text = MessageFormat.format(Messages.ProductCmptCategory_NoDefaultForPolicyCmptTypeAttributes, this.getName());
            list.newError("ProductCmptType-NoDefaultCategoryForPolicyCmptTypeAttributes", text, (Object)this, new String[0]);
        }
    }

    private void validateDefaultCategoryForProductCmptTypeAttribute(MessageList list, IIpsProject ipsProject) {
        boolean propertyTypeExistsInTypeHierarchy;
        boolean bl = propertyTypeExistsInTypeHierarchy = this.findProductCmptProperties(ProductCmptPropertyType.PRODUCT_CMPT_TYPE_ATTRIBUTE, true, ipsProject).size() > 0;
        if (propertyTypeExistsInTypeHierarchy && this.findDefaultCategoryForProductCmptTypeAttributes(ipsProject) == null) {
            String text = MessageFormat.format(Messages.ProductCmptCategory_NoDefaultForProductCmptTypeAttributes, this.getName());
            list.newError("ProductCmptType-NoDefaultCategoryForProductCmptTypeAttributes", text, (Object)this, new String[0]);
        }
    }

    private void validateDefaultCategoryForTableStructureUsages(MessageList list, IIpsProject ipsProject) {
        boolean propertyTypeExistsInTypeHierarchy;
        boolean bl = propertyTypeExistsInTypeHierarchy = this.findProductCmptProperties(ProductCmptPropertyType.TABLE_STRUCTURE_USAGE, true, ipsProject).size() > 0;
        if (propertyTypeExistsInTypeHierarchy && this.findDefaultCategoryForTableStructureUsages(ipsProject) == null) {
            String text = MessageFormat.format(Messages.ProductCmptCategory_NoDefaultForTableStructureUsages, this.getName());
            list.newError("ProductCmptType-NoDefaultCategoryForTableStructureUsages", text, (Object)this, new String[0]);
        }
    }

    private void validateDefaultCategoryForValidationRules(MessageList list, IIpsProject ipsProject) {
        boolean propertyTypeExistsInTypeHierarchy;
        boolean bl = propertyTypeExistsInTypeHierarchy = this.findProductCmptProperties(ProductCmptPropertyType.VALIDATION_RULE, true, ipsProject).size() > 0;
        if (propertyTypeExistsInTypeHierarchy && this.findDefaultCategoryForValidationRules(ipsProject) == null) {
            String text = MessageFormat.format(Messages.ProductCmptCategory_NoDefaultForValidationRules, this.getName());
            list.newError("ProductCmptType-NoDefaultCategoryForValidationRules", text, (Object)this, new String[0]);
        }
    }

    @Override
    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        HashSet<IDependency> dependencies = new HashSet<IDependency>();
        if (!IpsStringUtils.isEmpty((String)this.getPolicyCmptType())) {
            IpsObjectDependency dependency = IpsObjectDependency.createConfiguresDependency(this.getQualifiedNameType(), new QualifiedNameType(this.getPolicyCmptType(), IpsObjectType.POLICY_CMPT_TYPE));
            dependencies.add(dependency);
            this.addDetails(details, dependency, this, "policyCmptType");
        }
        this.dependsOnAddValidationDependency(dependencies);
        this.dependsOnAddExplicitlyMatchingAssociations(dependencies);
        this.dependsOnAddTables(dependencies, details);
        super.dependsOn(dependencies, details);
        return dependencies.toArray(new IDependency[dependencies.size()]);
    }

    private void dependsOnAddValidationDependency(Set<IDependency> dependencies) {
        dependencies.add(IpsObjectDependency.create(this.getQualifiedNameType(), new QualifiedNameType(this.getQualifiedName(), IpsObjectType.POLICY_CMPT_TYPE), DependencyType.VALIDATION));
    }

    private void dependsOnAddExplicitlyMatchingAssociations(Set<IDependency> dependencies) {
        for (IProductCmptTypeAssociation association : this.getProductCmptTypeAssociations()) {
            IPolicyCmptTypeAssociation matchingPolicyCmptTypeAssociations;
            if (!association.constrainsPolicyCmptTypeAssociation(this.getIpsProject()) || (matchingPolicyCmptTypeAssociations = association.findMatchingPolicyCmptTypeAssociation(this.getIpsProject())).getPolicyCmptType().isConfigurableByProductCmptType()) continue;
            IpsObjectDependency dependency = IpsObjectDependency.createReferenceDependency(this.getQualifiedNameType(), matchingPolicyCmptTypeAssociations.getPolicyCmptType().getQualifiedNameType());
            dependencies.add(dependency);
        }
    }

    private void dependsOnAddTables(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details) {
        for (ITableStructureUsage tableUsage : this.getTableStructureUsages()) {
            String[] table;
            String[] stringArray = table = tableUsage.getTableStructures();
            int n = table.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                QualifiedNameType tableName = new QualifiedNameType(string, IpsObjectType.TABLE_STRUCTURE);
                IpsObjectDependency dependencyTable = IpsObjectDependency.createReferenceDependency(this.getQualifiedNameType(), tableName);
                dependencies.add(dependencyTable);
                this.addDetails(details, dependencyTable, ((TableStructureUsage)tableUsage).getTableStructureReference(string), "tableStructure");
                ++n2;
            }
        }
    }

    @Override
    public Collection<IIpsSrcFile> searchProductComponents(boolean includeSubtypes) {
        return this.searchMetaObjectSrcFiles(includeSubtypes);
    }

    @Override
    public Collection<IIpsSrcFile> searchMetaObjectSrcFiles(boolean includeSubtypes) {
        IIpsProject[] searchProjects;
        TreeSet<IIpsSrcFile> result = TreeSetHelper.newIpsSrcFileTreeSet();
        IIpsProject[] iIpsProjectArray = searchProjects = this.getIpsProject().findReferencingProjectLeavesOrSelf();
        int n = searchProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsProject project = iIpsProjectArray[n2];
            result.addAll(Arrays.asList(project.findAllProductCmptSrcFiles(this, includeSubtypes)));
            ++n2;
        }
        return result;
    }

    @Override
    public String getInstancesIcon() {
        return this.instancesIconPath;
    }

    @Override
    public boolean isUseCustomInstanceIcon() {
        return IpsStringUtils.isNotEmpty((String)this.instancesIconPath);
    }

    @Override
    public void setInstancesIcon(String path) {
        String oldPath = this.instancesIconPath;
        this.instancesIconPath = path;
        this.valueChanged(oldPath, this.instancesIconPath);
    }

    @Override
    public String getCaption(Locale locale) {
        return Messages.ProductCmptType_caption;
    }

    @Override
    public IProductCmptCategory newCategory() {
        return this.categories.newPart();
    }

    @Override
    public IProductCmptCategory newCategory(String name) {
        IProductCmptCategory category = this.newCategory();
        category.setName(name);
        return category;
    }

    @Override
    public IProductCmptCategory newCategory(String name, IProductCmptCategory.Position position) {
        IProductCmptCategory category = this.newCategory(name);
        category.setPosition(position);
        return category;
    }

    @Override
    public List<IProductCmptCategory> getCategories() {
        return Collections.unmodifiableList(this.categories.asList());
    }

    @Override
    public List<IProductCmptCategory> getCategories(IProductCmptCategory.Position position) {
        ArrayList<IProductCmptCategory> positionCategories = new ArrayList<IProductCmptCategory>();
        for (IProductCmptCategory category : this.categories) {
            if (!position.equals((Object)category.getPosition())) continue;
            positionCategories.add(category);
        }
        return positionCategories;
    }

    @Override
    public List<IProductCmptCategory> findCategories(IIpsProject ipsProject) {
        final LinkedHashMap typesToOriginalCategories = new LinkedHashMap();
        TypeHierarchyVisitor<IProductCmptType> visitor = new TypeHierarchyVisitor<IProductCmptType>(ipsProject){

            @Override
            protected boolean visit(IProductCmptType currentType) {
                typesToOriginalCategories.put(currentType, currentType.getCategories());
                return true;
            }
        };
        visitor.start(this);
        ArrayList<IProductCmptCategory> sortedCategories = new ArrayList<IProductCmptCategory>();
        int i = visitor.getVisited().size() - 1;
        while (i >= 0) {
            IType type = (IType)visitor.getVisited().get(i);
            sortedCategories.addAll((Collection)typesToOriginalCategories.get(type));
            --i;
        }
        return sortedCategories;
    }

    @Override
    public IProductCmptCategory getCategory(String name) {
        for (IProductCmptCategory category : this.categories) {
            if (!name.equals(category.getName())) continue;
            return category;
        }
        return null;
    }

    @Override
    public IProductCmptCategory getFirstCategory(IProductCmptCategory.Position position) {
        for (IProductCmptCategory category : this.categories) {
            if (!position.equals((Object)category.getPosition())) continue;
            return category;
        }
        return null;
    }

    @Override
    public IProductCmptCategory getLastCategory(IProductCmptCategory.Position position) {
        int i = this.categories.size() - 1;
        while (i >= 0) {
            if (position.equals((Object)this.categories.getPart(i).getPosition())) {
                return this.categories.getPart(i);
            }
            --i;
        }
        return null;
    }

    @Override
    public boolean isFirstCategory(IProductCmptCategory category) {
        return category.equals(this.getFirstCategory(category.getPosition()));
    }

    @Override
    public boolean isLastCategory(IProductCmptCategory category) {
        return category.equals(this.getLastCategory(category.getPosition()));
    }

    @Override
    public boolean isDefining(IProductCmptCategory category) {
        return this.equals(category.getParent());
    }

    @Override
    public boolean hasCategory(String name) {
        return this.getCategory(name) != null;
    }

    @Override
    public boolean findHasCategory(String name, IIpsProject ipsProject) {
        return this.findCategory(name, ipsProject) != null;
    }

    @Override
    public IProductCmptCategory findDefaultCategoryForFormulaSignatureDefinitions(IIpsProject ipsProject) {
        DefaultCategoryFinder defaultCategoryFinder = new DefaultCategoryFinder(ProductCmptPropertyType.FORMULA_SIGNATURE_DEFINITION, ipsProject);
        defaultCategoryFinder.start(this);
        return defaultCategoryFinder.defaultCategory;
    }

    @Override
    public IProductCmptCategory findDefaultCategoryForPolicyCmptTypeAttributes(IIpsProject ipsProject) {
        DefaultCategoryFinder defaultCategoryFinder = new DefaultCategoryFinder(ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE, ipsProject);
        defaultCategoryFinder.start(this);
        return defaultCategoryFinder.defaultCategory;
    }

    @Override
    public IProductCmptCategory findDefaultCategoryForProductCmptTypeAttributes(IIpsProject ipsProject) {
        DefaultCategoryFinder defaultCategoryFinder = new DefaultCategoryFinder(ProductCmptPropertyType.PRODUCT_CMPT_TYPE_ATTRIBUTE, ipsProject);
        defaultCategoryFinder.start(this);
        return defaultCategoryFinder.defaultCategory;
    }

    @Override
    public IProductCmptCategory findDefaultCategoryForTableStructureUsages(IIpsProject ipsProject) {
        DefaultCategoryFinder defaultCategoryFinder = new DefaultCategoryFinder(ProductCmptPropertyType.TABLE_STRUCTURE_USAGE, ipsProject);
        defaultCategoryFinder.start(this);
        return defaultCategoryFinder.defaultCategory;
    }

    @Override
    public IProductCmptCategory findDefaultCategoryForValidationRules(IIpsProject ipsProject) {
        DefaultCategoryFinder defaultCategoryFinder = new DefaultCategoryFinder(ProductCmptPropertyType.VALIDATION_RULE, ipsProject);
        defaultCategoryFinder.start(this);
        return defaultCategoryFinder.defaultCategory;
    }

    @Override
    public IProductCmptCategory findCategory(String name, IIpsProject ipsProject) {
        ProductCmptCategoryFinder visitor = new ProductCmptCategoryFinder(ipsProject, name);
        visitor.start(this);
        return visitor.category;
    }

    String getCategoryNameFor(IProductCmptProperty property) {
        String pendingCategory = (String)this.pendingPolicyChanges.getOrDefault(property, Map.of()).get((Object)CategoryChange.NAME);
        if (pendingCategory != null) {
            return pendingCategory;
        }
        return property.getCategory();
    }

    int getCategoryPositionFor(IProductCmptProperty property) {
        String pendingPosition = (String)this.pendingPolicyChanges.getOrDefault(property, Map.of()).get((Object)CategoryChange.POSITION);
        if (pendingPosition != null) {
            return Integer.parseInt(pendingPosition);
        }
        return property.getCategoryPosition();
    }

    @Override
    public boolean moveCategories(List<IProductCmptCategory> categories, boolean up) {
        for (IProductCmptCategory category : categories) {
            ArgumentCheck.equals((Object)this, (Object)category.getProductCmptType());
        }
        ArrayList<IProductCmptCategory> leftCategories = new ArrayList<IProductCmptCategory>();
        ArrayList<IProductCmptCategory> rightCategories = new ArrayList<IProductCmptCategory>();
        for (IProductCmptCategory category : categories) {
            ArrayList<IProductCmptCategory> targetList = category.isAtLeftPosition() ? leftCategories : rightCategories;
            targetList.add(category);
        }
        boolean leftMoved = this.moveCategories(leftCategories, this.getCategories(IProductCmptCategory.Position.LEFT), up);
        boolean rightMoved = this.moveCategories(rightCategories, this.getCategories(IProductCmptCategory.Position.RIGHT), up);
        if (leftMoved || rightMoved) {
            this.partsMoved(this.categories.getParts());
            return true;
        }
        return false;
    }

    private boolean moveCategories(List<IProductCmptCategory> categories, List<IProductCmptCategory> contextCategories, boolean up) {
        int[] indices = new int[categories.size()];
        int i = 0;
        while (i < categories.size()) {
            indices[i] = contextCategories.indexOf(categories.get(i));
            ++i;
        }
        SubListElementMover<IProductCmptCategory> mover = new SubListElementMover<IProductCmptCategory>(this.categories.getBackingList(), contextCategories);
        int[] newIndices = mover.move(indices, up);
        return !Arrays.equals(indices, newIndices);
    }

    int[] movePropertyReferences(final int[] movedIndices, final List<IProductCmptProperty> contextProperties, final boolean up) {
        return (int[])((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<Object>(this.getIpsSrcFile()){
            private Object result;

            @Override
            protected boolean execute() {
                this.result = ProductCmptType.this.moveProductCmptPropertyReferencesInternal(movedIndices, contextProperties, up);
                return true;
            }

            @Override
            protected Object getResult() {
                return this.result;
            }
        });
    }

    private int[] moveProductCmptPropertyReferencesInternal(int[] movedIndices, List<IProductCmptProperty> contextProperties, boolean up) {
        SubListElementMover<IProductCmptProperty> mover = new SubListElementMover<IProductCmptProperty>(contextProperties, contextProperties);
        int[] newIndices = mover.move(movedIndices, up);
        if (!Arrays.equals(movedIndices, newIndices)) {
            AtomicInteger i = new AtomicInteger(0);
            contextProperties.forEach(p -> {
                int incrementAndGet = i.incrementAndGet();
                if (!p.isPolicyCmptTypeProperty()) {
                    p.setCategoryPosition(incrementAndGet);
                } else {
                    this.deferPolicyChange((IProductCmptProperty)p, this.getCategoryNameFor((IProductCmptProperty)p), incrementAndGet);
                }
            });
            this.partsMoved(contextProperties.toArray(new IIpsObjectPart[contextProperties.size()]));
        }
        return newIndices;
    }

    @Override
    protected boolean isPartSavedToXml(IIpsObjectPart part) {
        return !(part instanceof IProductCmptPropertyReference);
    }

    boolean findIsCategoryNameUsedTwiceInSupertypeHierarchy(String categoryName, IIpsProject ipsProject) {
        CategoryCounter counter = new CategoryCounter(categoryName, ipsProject);
        counter.start(this);
        return counter.categoriesFound > 1;
    }

    void sortCategoriesAccordingToPosition() {
        Collections.sort(this.categories.getBackingList(), (o1, o2) -> {
            if (o1.isAtLeftPosition() && o2.isAtRightPosition()) {
                return -1;
            }
            if (o1.isAtRightPosition() && o2.isAtLeftPosition()) {
                return 1;
            }
            return 0;
        });
    }

    @Override
    public void changeCategoryAndDeferPolicyChange(IProductCmptProperty property, String category) {
        if (property.isPolicyCmptTypeProperty()) {
            this.deferPolicyChange(property, category, -1);
        } else {
            property.setCategory(category);
        }
    }

    private void deferPolicyChange(IProductCmptProperty property, String category, int position) {
        if (property.getType().getIpsSrcFile().isMutable()) {
            this.pendingPolicyChanges.put(property, Map.of(CategoryChange.NAME, category, CategoryChange.POSITION, String.valueOf(position)));
            this.objectHasChanged();
        }
    }

    private static enum CategoryChange {
        NAME,
        POSITION;

    }

    private static class CategoryCounter
    extends TypeHierarchyVisitor<IProductCmptType> {
        private int categoriesFound = 0;
        private String categoryName;

        public CategoryCounter(String categoryName, IIpsProject ipsProject) {
            super(ipsProject);
            this.categoryName = categoryName;
        }

        @Override
        protected boolean visit(IProductCmptType currentType) {
            for (IProductCmptCategory category : currentType.getCategories()) {
                if (!this.categoryName.equals(category.getName())) continue;
                ++this.categoriesFound;
            }
            return this.categoriesFound < 2;
        }
    }

    private static class DefaultCategoryFinder
    extends TypeHierarchyVisitor<IProductCmptType> {
        private final ProductCmptPropertyType propertyType;
        private IProductCmptCategory defaultCategory;

        private DefaultCategoryFinder(ProductCmptPropertyType propertyType, IIpsProject ipsProject) {
            super(ipsProject);
            this.propertyType = propertyType;
        }

        @Override
        protected boolean visit(IProductCmptType currentType) {
            for (IProductCmptCategory category : currentType.getCategories()) {
                if (!category.isDefaultFor(this.propertyType)) continue;
                this.defaultCategory = category;
                return false;
            }
            return true;
        }
    }

    private static class NotDerivedAssociationCollector
    extends Type.AbstractAssociationFinder<IProductCmptTypeAssociation> {
        public NotDerivedAssociationCollector(IIpsProject ipsProject) {
            super(true, ipsProject);
        }

        @Override
        protected boolean isAssociationWanted(IAssociation association) {
            return !association.isDerived() && super.isAssociationWanted(association);
        }

        @Override
        protected List<IProductCmptTypeAssociation> getAssociations(IType currentType) {
            return ((IProductCmptType)currentType).getProductCmptTypeAssociations();
        }
    }

    private static class ProductCmptCategoryFinder
    extends TypeHierarchyVisitor<IProductCmptType> {
        private final String categoryName;
        private IProductCmptCategory category;

        private ProductCmptCategoryFinder(IIpsProject ipsProject, String categoryName) {
            super(ipsProject);
            this.categoryName = categoryName;
        }

        @Override
        protected boolean visit(IProductCmptType currentType) {
            if (currentType.getCategory(this.categoryName) != null) {
                this.category = currentType.getCategory(this.categoryName);
                return false;
            }
            return true;
        }
    }

    private static class ProductCmptPropertyCollector
    extends TypeHierarchyVisitor<IProductCmptType> {
        private final ProductCmptPropertyType propertyType;
        private final boolean searchSupertypeHierarchy;
        private List<IProductCmptProperty> attributes = new ArrayList<IProductCmptProperty>();
        private List<IProductCmptProperty> tableStructureUsages = new ArrayList<IProductCmptProperty>();
        private List<IProductCmptProperty> formulaSignatureDefinitions = new ArrayList<IProductCmptProperty>();
        private List<IProductCmptProperty> policyCmptTypeAttributes = new ArrayList<IProductCmptProperty>();
        private List<IProductCmptProperty> validationRules = new ArrayList<IProductCmptProperty>();
        private Set<IPolicyCmptType> visitedPolicyCmptTypes = new LinkedHashSet<IPolicyCmptType>();

        public ProductCmptPropertyCollector(ProductCmptPropertyType propertyType, boolean searchSupertypeHierarchy, IIpsProject ipsProject) {
            super(ipsProject);
            this.propertyType = propertyType;
            this.searchSupertypeHierarchy = searchSupertypeHierarchy;
        }

        @Override
        protected boolean visit(IProductCmptType currentType) {
            this.collectProductCmptTypeAttributes(currentType);
            this.collectTableStructureUsages(currentType);
            this.collectFormulaSignatureDefinitions(currentType);
            IPolicyCmptType policyCmptType = currentType.findPolicyCmptType(this.getIpsProject());
            if (policyCmptType == null || this.visitedPolicyCmptTypes.contains(policyCmptType)) {
                return this.searchSupertypeHierarchy;
            }
            this.collectPolicyCmptTypeAttributes(policyCmptType);
            this.collectValidationRules(policyCmptType);
            return this.searchSupertypeHierarchy;
        }

        private void collectValidationRules(IPolicyCmptType policyCmptType) {
            if (this.propertyType == null || ProductCmptPropertyType.VALIDATION_RULE.equals((Object)this.propertyType)) {
                this.visitedPolicyCmptTypes.add(policyCmptType);
                this.validationRules.addAll(0, policyCmptType.getProductCmptProperties(ProductCmptPropertyType.VALIDATION_RULE));
            }
        }

        private void collectPolicyCmptTypeAttributes(IPolicyCmptType policyCmptType) {
            if (this.propertyType == null || ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE.equals((Object)this.propertyType)) {
                this.visitedPolicyCmptTypes.add(policyCmptType);
                this.policyCmptTypeAttributes.addAll(0, policyCmptType.getProductCmptProperties(ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE));
            }
        }

        private void collectFormulaSignatureDefinitions(IProductCmptType currentType) {
            if (this.propertyType == null || ProductCmptPropertyType.FORMULA_SIGNATURE_DEFINITION.equals((Object)this.propertyType)) {
                this.formulaSignatureDefinitions.addAll(0, currentType.getFormulaSignatures());
            }
        }

        private void collectTableStructureUsages(IProductCmptType currentType) {
            if (this.propertyType == null || ProductCmptPropertyType.TABLE_STRUCTURE_USAGE.equals((Object)this.propertyType)) {
                this.tableStructureUsages.addAll(0, currentType.getTableStructureUsages());
            }
        }

        private void collectProductCmptTypeAttributes(IProductCmptType currentType) {
            if (this.propertyType == null || ProductCmptPropertyType.PRODUCT_CMPT_TYPE_ATTRIBUTE.equals((Object)this.propertyType)) {
                this.attributes.addAll(0, currentType.getProductCmptTypeAttributes());
            }
        }

        public List<IProductCmptProperty> getProperties() {
            ArrayList<IProductCmptProperty> properties = new ArrayList<IProductCmptProperty>(this.size());
            properties.addAll(this.attributes);
            properties.addAll(this.tableStructureUsages);
            properties.addAll(this.formulaSignatureDefinitions);
            properties.addAll(this.policyCmptTypeAttributes);
            properties.addAll(this.validationRules);
            return properties;
        }

        public Map<String, IProductCmptProperty> getPropertyMap() {
            LinkedHashMap<String, IProductCmptProperty> propertyMap = new LinkedHashMap<String, IProductCmptProperty>(this.size());
            this.add(propertyMap, this.attributes);
            this.add(propertyMap, this.tableStructureUsages);
            this.add(propertyMap, this.formulaSignatureDefinitions);
            this.add(propertyMap, this.policyCmptTypeAttributes);
            this.add(propertyMap, this.validationRules);
            if (this.propertyType == ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE || this.propertyType == null) {
                this.fixOverwrittenPolicyCmptTypeAttributes(propertyMap);
            }
            return propertyMap;
        }

        private void fixOverwrittenPolicyCmptTypeAttributes(Map<String, IProductCmptProperty> propertyMap) {
            HashSet<String> analyzedPolicyAttributes = new HashSet<String>();
            for (IPolicyCmptType policyCmptType : this.visitedPolicyCmptTypes) {
                for (IPolicyCmptTypeAttribute attribute : policyCmptType.getPolicyCmptTypeAttributes()) {
                    if (!attribute.isOverwrite() || analyzedPolicyAttributes.contains(attribute.getName())) continue;
                    if (!attribute.isProductRelevant()) {
                        propertyMap.remove(attribute.getName());
                    } else {
                        propertyMap.put(attribute.getName(), attribute);
                    }
                    analyzedPolicyAttributes.add(attribute.getName());
                }
            }
        }

        private void add(Map<String, IProductCmptProperty> propertyMap, List<? extends IProductCmptProperty> propertyList) {
            for (IProductCmptProperty iProductCmptProperty : propertyList) {
                propertyMap.put(iProductCmptProperty.getPropertyName(), iProductCmptProperty);
            }
        }

        private int size() {
            return this.attributes.size() + this.tableStructureUsages.size() + this.formulaSignatureDefinitions.size() + this.policyCmptTypeAttributes.size() + this.validationRules.size();
        }
    }

    private static class ProductCmptTypeDuplicatePropertyNameValidator
    extends DuplicatePropertyNameValidator {
        private Set<IProductCmptType> productCmptTypes = new LinkedHashSet<IProductCmptType>();

        public ProductCmptTypeDuplicatePropertyNameValidator(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        public void addMessagesForDuplicates(IType currentType, MessageList messages) {
            super.addMessagesForDuplicates(currentType, messages);
            for (IProductCmptType productCmptType : this.productCmptTypes) {
                String propertyName = productCmptType.getUnqualifiedName().toLowerCase();
                ObjectProperty[] potentialProperties = this.getProperties().get(propertyName);
                if (potentialProperties == null) continue;
                ArrayList<ObjectProperty> duplicateProperties = new ArrayList<ObjectProperty>();
                ObjectProperty[] objectPropertyArray = potentialProperties;
                int n = potentialProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    ObjectProperty potentialProperty = objectPropertyArray[n2];
                    Object object = potentialProperty.getObject();
                    String property = potentialProperty.getProperty();
                    if (this.isPartOfPolicyTypeOrProductTypeChangingOverTime(object) && (this.isPolicyPartOrProductPartChangingOverTime(object) || object instanceof IAttribute) && (!(object instanceof IAssociation) || this.hasProblematicTargetRole((IAssociation)object, property))) {
                        duplicateProperties.add(potentialProperty);
                    }
                    ++n2;
                }
                if (duplicateProperties.isEmpty()) continue;
                duplicateProperties.add(0, new ObjectProperty((Object)productCmptType, "name"));
                messages.add(this.createMessage(propertyName, (ObjectProperty[])duplicateProperties.toArray(ObjectProperty[]::new)));
            }
        }

        private boolean isPartOfPolicyTypeOrProductTypeChangingOverTime(Object object) {
            if (object instanceof ITypePart) {
                boolean productTypeChangingOverTime;
                IType type = ((ITypePart)object).getType();
                boolean policyType = type instanceof IPolicyCmptType;
                boolean bl = productTypeChangingOverTime = type instanceof IProductCmptType && ((IProductCmptType)type).isChangingOverTime();
                return policyType || productTypeChangingOverTime;
            }
            return false;
        }

        private boolean isPolicyPartOrProductPartChangingOverTime(Object object) {
            return !(object instanceof IChangingOverTimeProperty) || ((IChangingOverTimeProperty)object).isChangingOverTime();
        }

        private boolean hasProblematicTargetRole(IAssociation association, String property) {
            boolean problematicPlural;
            boolean problematicSingular = association.is1To1() && "targetRoleSingular".equals(property);
            boolean bl = problematicPlural = association.is1ToMany() && ("targetRolePlural".equals(property) || "targetRoleSingular".equals(property) && association.getTargetRoleSingular().equalsIgnoreCase(association.getTargetRolePlural()));
            return problematicSingular || problematicPlural;
        }

        @Override
        protected boolean ignore(IType currentType, ObjectProperty[] duplicateObjectProperties) {
            if (this.isIgnoreDuplicatedPolicyPart(duplicateObjectProperties)) {
                return true;
            }
            return super.ignore(currentType, duplicateObjectProperties);
        }

        private boolean isIgnoreDuplicatedPolicyPart(ObjectProperty[] duplicateObjectProperties) {
            boolean foundRelevantProductPart = false;
            boolean foundPolicyAttribute = false;
            ObjectProperty[] objectPropertyArray = duplicateObjectProperties;
            int n = duplicateObjectProperties.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectProperty objectProperty = objectPropertyArray[n2];
                if (this.isRelevantProductPart(objectProperty)) {
                    foundRelevantProductPart = true;
                }
                if (objectProperty.getObject() instanceof IPolicyCmptTypeAttribute) {
                    foundPolicyAttribute = true;
                }
                ++n2;
            }
            return foundPolicyAttribute && !foundRelevantProductPart;
        }

        private boolean isRelevantProductPart(ObjectProperty objectProperty) {
            return objectProperty.getObject() instanceof IProductCmptTypeAttribute || objectProperty.getObject() instanceof ITableStructureUsage;
        }

        @Override
        protected IType getMatchingType(IType currentType) {
            return ((IProductCmptType)currentType).findPolicyCmptType(this.getIpsProject());
        }

        @Override
        protected String getObjectKindNamePlural(ObjectProperty invalidObjProperty) {
            IIpsObjectPartContainer objectPartContainer = (IIpsObjectPartContainer)invalidObjProperty.getObject();
            if (objectPartContainer instanceof IFormula) {
                return Messages.ProductCmptTypeMethod_Formula_msg_Plural;
            }
            if (objectPartContainer instanceof ITableStructureUsage) {
                return Messages.TableStructureUsage_msg_Plural;
            }
            return super.getObjectKindNamePlural(invalidObjProperty);
        }

        @Override
        protected String getObjectKindNameSingular(IpsObjectPartContainer objectPartContainer) {
            if (objectPartContainer instanceof IFormula) {
                return Messages.ProductCmptTypeMethod_Formula_msg_Singular;
            }
            if (objectPartContainer instanceof ITableStructureUsage) {
                return Messages.TableStructureUsage_msg_Singular;
            }
            return super.getObjectKindNameSingular(objectPartContainer);
        }

        @Override
        protected boolean visit(IType currentType) {
            ProductCmptType productCmptType = (ProductCmptType)currentType;
            this.productCmptTypes.add(productCmptType);
            for (ITableStructureUsage tableStructureUsage : productCmptType.tableStructureUsages) {
                this.add(tableStructureUsage.getRoleName(), new ObjectProperty((Object)tableStructureUsage, "roleName"));
            }
            for (IProductCmptTypeMethod method : productCmptType.getMethodPartCollection()) {
                if (!method.isFormulaSignatureDefinition() || !IpsStringUtils.isNotEmpty((String)method.getFormulaName()) || method.isOverloadsFormula()) continue;
                this.add(method.getFormulaName(), new ObjectProperty((Object)method, "formulaName"));
            }
            super.visit(currentType);
            return true;
        }
    }

    private static class TableStructureUsageFinder
    extends TypeHierarchyVisitor<IProductCmptType> {
        private String tsuName;
        private ITableStructureUsage tsu = null;

        public TableStructureUsageFinder(IIpsProject project, String tsuName) {
            super(project);
            this.tsuName = tsuName;
        }

        @Override
        protected boolean visit(IProductCmptType currentType) {
            this.tsu = currentType.getTableStructureUsage(this.tsuName);
            return this.tsu == null;
        }
    }
}

