/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpttype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.faktorips.devtools.model.internal.productcmpttype.ChangingOverTimePropertyValidator;
import org.faktorips.devtools.model.internal.productcmpttype.Messages;
import org.faktorips.devtools.model.internal.type.Association;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.type.AssociationType;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductCmptTypeAssociation
extends Association
implements IProductCmptTypeAssociation {
    private String matchingAssociationSource = "";
    private String matchingAssociationName = "";
    private boolean changingOverTime = this.getProductCmptType().isChangingOverTime();
    private boolean relevant = true;

    public ProductCmptTypeAssociation(IProductCmptType parent, String id) {
        super(parent, id);
        this.setAssociationTypeInternal(AssociationType.AGGREGATION);
    }

    @Override
    public IProductCmptType getProductCmptType() {
        return (IProductCmptType)this.getParent();
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    public IProductCmptType findTargetProductCmptType(IIpsProject ipsProject) {
        return (IProductCmptType)ipsProject.findIpsObject(IpsObjectType.PRODUCT_CMPT_TYPE, this.getTarget());
    }

    @Override
    public IProductCmptTypeAssociation findConstrainedAssociation(IIpsProject ipsProject) {
        return (IProductCmptTypeAssociation)super.findConstrainedAssociation(ipsProject);
    }

    @Override
    public boolean constrainsPolicyCmptTypeAssociation(IIpsProject ipsProject) {
        return this.findMatchingPolicyCmptTypeAssociation(ipsProject) != null;
    }

    @Override
    public Set<IPolicyCmptTypeAssociation> findPossiblyMatchingPolicyCmptTypeAssociations(IIpsProject ipsProject) {
        LinkedHashSet<IPolicyCmptTypeAssociation> result = new LinkedHashSet<IPolicyCmptTypeAssociation>();
        IPolicyCmptType sourcePolicyCmptType = this.getProductCmptType().findPolicyCmptType(ipsProject);
        if (sourcePolicyCmptType == null) {
            return result;
        }
        IProductCmptType targetProductCmptType = this.findTargetProductCmptType(ipsProject);
        if (targetProductCmptType == null) {
            return result;
        }
        IPolicyCmptType targetPolicyCmptType = targetProductCmptType.findPolicyCmptType(ipsProject);
        if (targetPolicyCmptType == null) {
            return result;
        }
        String targetQName = targetPolicyCmptType.getQualifiedName();
        this.collectPossibleMatchingAssociations(sourcePolicyCmptType, targetQName, result, ipsProject, new HashSet<IPolicyCmptType>());
        return result;
    }

    private boolean collectPossibleMatchingAssociations(IPolicyCmptType sourcePolicyCmptType, String targetQName, Set<IPolicyCmptTypeAssociation> foundAssociations, IIpsProject ipsProject, Set<IPolicyCmptType> alreadyVisit) {
        boolean result = false;
        List<IPolicyCmptTypeAssociation> policyAssociations = sourcePolicyCmptType.getPolicyCmptTypeAssociations();
        for (IPolicyCmptTypeAssociation policyCmptTypeAssociation : policyAssociations) {
            boolean notVisitedYet;
            IPolicyCmptType nextSource;
            if (AssociationType.COMPOSITION_DETAIL_TO_MASTER.equals((Object)policyCmptTypeAssociation.getAssociationType())) continue;
            if (targetQName.equals(policyCmptTypeAssociation.getTarget())) {
                result = true;
                if (foundAssociations.add(policyCmptTypeAssociation)) continue;
                return true;
            }
            IPolicyCmptType actualAssociationTarget = policyCmptTypeAssociation.findTargetPolicyCmptType(ipsProject);
            if (this.isTargetConfigurableByProductCmptType(actualAssociationTarget) || (nextSource = policyCmptTypeAssociation.findTargetPolicyCmptType(ipsProject)) == null || !(notVisitedYet = alreadyVisit.add(nextSource)) || !this.collectPossibleMatchingAssociations(nextSource, targetQName, foundAssociations, ipsProject, alreadyVisit)) continue;
            if (!foundAssociations.add(policyCmptTypeAssociation)) {
                return true;
            }
            result = true;
        }
        return result;
    }

    private boolean isTargetConfigurableByProductCmptType(IPolicyCmptType actualAssociationTarget) {
        return actualAssociationTarget != null && actualAssociationTarget.isConfigurableByProductCmptType();
    }

    @Override
    public IPolicyCmptTypeAssociation findMatchingPolicyCmptTypeAssociation(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.matchingAssociationSource) || IpsStringUtils.isEmpty((String)this.matchingAssociationName)) {
            return this.findDefaultPolicyCmptTypeAssociation(ipsProject);
        }
        IPolicyCmptType policyCmptType = this.getIpsProject().findPolicyCmptType(this.matchingAssociationSource);
        if (policyCmptType == null) {
            return null;
        }
        return (IPolicyCmptTypeAssociation)policyCmptType.getAssociation(this.matchingAssociationName);
    }

    @Override
    public void setMatchingAssociationSource(String matchingAssociationSource) {
        String oldValue = this.matchingAssociationSource;
        this.matchingAssociationSource = matchingAssociationSource;
        this.valueChanged(oldValue, matchingAssociationSource);
    }

    @Override
    public String getMatchingAssociationSource() {
        return this.matchingAssociationSource;
    }

    @Override
    public void setMatchingAssociationName(String matchingAssociationName) {
        String oldValue = this.matchingAssociationName;
        this.matchingAssociationName = matchingAssociationName;
        this.valueChanged(oldValue, matchingAssociationName);
    }

    @Override
    public String getMatchingAssociationName() {
        return this.matchingAssociationName;
    }

    @Override
    public IPolicyCmptTypeAssociation findDefaultPolicyCmptTypeAssociation(IIpsProject ipsProject) {
        IPolicyCmptType policyCmptType = this.getProductCmptType().findPolicyCmptType(ipsProject);
        if (policyCmptType == null) {
            return null;
        }
        if (!policyCmptType.getProductCmptType().equals(this.getProductCmptType().getQualifiedName())) {
            IProductCmptTypeAssociation constrainedAssociation;
            if (this.isConstrain() && (constrainedAssociation = (IProductCmptTypeAssociation)this.findSuperAssociationWithSameName(ipsProject)) != null) {
                return constrainedAssociation.findDefaultPolicyCmptTypeAssociation(ipsProject);
            }
            return null;
        }
        IProductCmptType targetType = this.findTargetProductCmptType(ipsProject);
        if (targetType == null) {
            return null;
        }
        IPolicyCmptType targetPolicyCmptType = targetType.findPolicyCmptType(ipsProject);
        if (targetPolicyCmptType == null) {
            return null;
        }
        boolean targetIsProductOnlySubclass = !targetPolicyCmptType.getProductCmptType().equals(targetType.getQualifiedName());
        IPolicyCmptTypeAssociation[] policyAssoc = this.getAssociationsFor(policyCmptType, targetPolicyCmptType);
        if (policyAssoc.length == 0) {
            return null;
        }
        int index = this.getAssociationIndex(targetIsProductOnlySubclass);
        if (index >= policyAssoc.length) {
            return null;
        }
        return policyAssoc[index];
    }

    private IPolicyCmptTypeAssociation[] getAssociationsFor(IPolicyCmptType from, IPolicyCmptType target) {
        ArrayList<IPolicyCmptTypeAssociation> result = new ArrayList<IPolicyCmptTypeAssociation>();
        String targetQName = target.getQualifiedName();
        List<IPolicyCmptTypeAssociation> policyAssociations = from.getPolicyCmptTypeAssociations();
        for (IPolicyCmptTypeAssociation policyCmptTypeAssociation : policyAssociations) {
            if (!targetQName.equals(policyCmptTypeAssociation.getTarget()) || AssociationType.COMPOSITION_DETAIL_TO_MASTER.equals((Object)policyCmptTypeAssociation.getAssociationType())) continue;
            result.add(policyCmptTypeAssociation);
        }
        return result.toArray(new IPolicyCmptTypeAssociation[result.size()]);
    }

    private int getAssociationIndex(boolean targetIsProductOnlySubclass) {
        ArrayList<IAssociation> allAssociationsForTheTargetType = new ArrayList<IAssociation>();
        IProductCmptType target = this.getIpsProject().findProductCmptType(this.getTarget());
        for (IAssociation element : this.getType().getAssociations()) {
            IProductCmptType elementTarget = this.getIpsProject().findProductCmptType(element.getTarget());
            if (this.getTarget().equals(element.getTarget())) {
                allAssociationsForTheTargetType.add(element);
            }
            if (!targetIsProductOnlySubclass || !target.isSubtypeOf(elementTarget, this.getIpsProject())) continue;
            allAssociationsForTheTargetType.add(element);
        }
        int index = 0;
        Iterator it = allAssociationsForTheTargetType.iterator();
        while (it.hasNext()) {
            if (Objects.equals(this, it.next())) {
                return index;
            }
            ++index;
        }
        throw new RuntimeException("Can't get index of association " + this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + Objects.hash(this.changingOverTime, this.matchingAssociationName, this.matchingAssociationSource, this.relevant);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductCmptTypeAssociation other = (ProductCmptTypeAssociation)obj;
        return this.changingOverTime == other.changingOverTime && Objects.equals(this.matchingAssociationName, other.matchingAssociationName) && Objects.equals(this.matchingAssociationSource, other.matchingAssociationSource) && this.relevant == other.relevant;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        this.validateMatchingAsoociation(list, ipsProject);
        this.validateDerivedUnionChangingOverTimeProperty(list, ipsProject);
        this.validateConstrainedChangeOverTime(list, ipsProject);
        this.validateTypeDoesNotAcceptChangingOverTime(list);
    }

    protected void validateDerivedUnionChangingOverTimeProperty(MessageList list, IIpsProject ipsProject) {
        IProductCmptTypeAssociation derivedUnionAssociation;
        if (this.isSubsetOfADerivedUnion() && (derivedUnionAssociation = (IProductCmptTypeAssociation)this.findSubsettedDerivedUnion(ipsProject)) != null && derivedUnionAssociation.isChangingOverTime() != this.isChangingOverTime()) {
            String messageText = this.isChangingOverTime() ? Messages.ProductCmptTypeAssociation_Msg_DeriveUnionChangingOverTimeMismatch_SubetChanging : Messages.ProductCmptTypeAssociation_Msg_DeriveUnionChangingOverTimeMismatch_SubetStatic;
            String boundMessageText = MessageFormat.format(messageText, derivedUnionAssociation.getName());
            Message message = new Message("Association-DerivedUnionChangingOverTimeMismatch", boundMessageText, Message.ERROR, new ObjectProperty((Object)this, "changingOverTime"));
            list.add(message);
        }
    }

    private void validateMatchingAsoociation(MessageList list, IIpsProject ipsProject) {
        IPolicyCmptTypeAssociation matchingPolicyCmptTypeAssociation = this.findMatchingPolicyCmptTypeAssociation(ipsProject);
        if (matchingPolicyCmptTypeAssociation == null) {
            if (this.isMatchingAssociationSourceAndNameNotEmpty()) {
                list.add(new Message("Association-MatchingAssociationNotFound", MessageFormat.format(Messages.ProductCmptTypeAssociation_error_matchingAssociationNotFound, this.getMatchingAssociationName(), this.getMatchingAssociationSource()), Message.ERROR, (Object)this, new String[]{"matchingAssociationName", "matchingAssociationSource"}));
            }
            return;
        }
        if (!this.isRematchingAssociation(matchingPolicyCmptTypeAssociation, ipsProject)) {
            list.add(new Message("Association-MatchingAssociationInvalid", MessageFormat.format(Messages.ProductCmptTypeAssociation_error_MatchingAssociationInvalid, this.getMatchingAssociationName(), this.getMatchingAssociationSource()), Message.ERROR, (Object)this, new String[]{"matchingAssociationName", "matchingAssociationSource"}));
            return;
        }
        Set<IPolicyCmptTypeAssociation> possibleMatchingPolicyCmptTypeAssociations = this.findPossiblyMatchingPolicyCmptTypeAssociations(ipsProject);
        if (!possibleMatchingPolicyCmptTypeAssociations.contains(matchingPolicyCmptTypeAssociation)) {
            list.add(new Message("Association-MatchingAssociationInvalid", MessageFormat.format(Messages.ProductCmptTypeAssociation_error_MatchingAssociationDoesNotReferenceThis, this.getMatchingAssociationName(), this.getMatchingAssociationSource()), Message.ERROR, (Object)this, new String[]{"matchingAssociationName", "matchingAssociationSource"}));
            return;
        }
        List<IAssociation> allAssociations = this.getProductCmptType().findAllAssociations(ipsProject);
        for (IAssociation otherAssociation : allAssociations) {
            IPolicyCmptTypeAssociation otherMatchingAssociation;
            if (this.equals(otherAssociation) || (otherMatchingAssociation = ((IProductCmptTypeAssociation)otherAssociation).findMatchingPolicyCmptTypeAssociation(ipsProject)) == null || !otherMatchingAssociation.equals(matchingPolicyCmptTypeAssociation)) continue;
            list.add(new Message("Association-MatchingAssociationDuplicateName", MessageFormat.format(Messages.ProductCmptTypeAssociation_error_MatchingAssociationDuplicateName, otherAssociation, this.getMatchingAssociationSource()), Message.ERROR, (Object)this, new String[]{"matchingAssociationName", "matchingAssociationSource"}));
        }
    }

    private boolean isRematchingAssociation(IPolicyCmptTypeAssociation matchingPolicyCmptTypeAssociation, IIpsProject ipsProject) {
        IProductCmptTypeAssociation rematchingAssociation = matchingPolicyCmptTypeAssociation.findMatchingProductCmptTypeAssociation(ipsProject);
        if (rematchingAssociation != null) {
            return this.getName().equals(rematchingAssociation.getName());
        }
        return false;
    }

    private boolean isMatchingAssociationSourceAndNameNotEmpty() {
        return IpsStringUtils.isNotEmpty((String)this.matchingAssociationSource) && IpsStringUtils.isNotEmpty((String)this.matchingAssociationName);
    }

    private void validateConstrainedChangeOverTime(MessageList list, IIpsProject ipsProject) {
        IProductCmptTypeAssociation constrainedAssociation;
        if (this.isConstrain() && (constrainedAssociation = this.findConstrainedAssociation(ipsProject)) != null && this.isChangingOverTime() != constrainedAssociation.isChangingOverTime()) {
            list.newError("Association-ConstrainedChangeOverTimeMismatch", Messages.ProductCmptTypeAssociation_errorMsg_constrained_changeOverTime_missmatch, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "changingOverTime")});
        }
    }

    private void validateTypeDoesNotAcceptChangingOverTime(MessageList messageList) {
        ChangingOverTimePropertyValidator propertyValidator = new ChangingOverTimePropertyValidator(this);
        propertyValidator.validateTypeDoesNotAcceptChangingOverTime(messageList);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Association");
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.matchingAssociationName = XmlUtil.getAttributeOrEmptyString(element, "matchingAssociationName");
        this.matchingAssociationSource = XmlUtil.getAttributeOrEmptyString(element, "matchingAssociationSource");
        this.initPropertyChangingOverTime(element);
        this.initPropertyVisible(element);
    }

    private void initPropertyChangingOverTime(Element element) {
        if (element.hasAttribute("changingOverTime")) {
            this.changingOverTime = Boolean.parseBoolean(element.getAttribute("changingOverTime"));
        }
    }

    private void initPropertyVisible(Element element) {
        if (element.hasAttribute("relevant")) {
            this.relevant = Boolean.parseBoolean(element.getAttribute("relevant"));
        }
    }

    @Override
    protected void propertiesToXml(Element newElement) {
        super.propertiesToXml(newElement);
        if (IpsStringUtils.isNotEmpty((String)this.matchingAssociationName)) {
            newElement.setAttribute("matchingAssociationName", this.matchingAssociationName);
        }
        if (IpsStringUtils.isNotEmpty((String)this.matchingAssociationSource)) {
            newElement.setAttribute("matchingAssociationSource", this.matchingAssociationSource);
        }
        newElement.setAttribute("changingOverTime", Boolean.toString(this.changingOverTime));
        newElement.setAttribute("relevant", Boolean.toString(this.relevant));
    }

    @Override
    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    @Override
    public void setChangingOverTime(boolean changingOverTime) {
        boolean oldValue = this.changingOverTime;
        this.changingOverTime = changingOverTime;
        this.valueChanged(oldValue, this.changingOverTime);
    }

    @Override
    public boolean isRelevant() {
        return this.relevant;
    }

    @Override
    public void setRelevant(boolean relevant) {
        boolean oldValue = this.relevant;
        this.relevant = relevant;
        this.valueChanged(oldValue, this.relevant);
    }

    @Override
    public IAssociation findMatchingAssociation() {
        return this.findMatchingPolicyCmptTypeAssociation(this.getIpsProject());
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return this.getProductCmptType();
    }
}

