/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpttype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.productcmpt.MultiValueHolder;
import org.faktorips.devtools.model.internal.productcmpttype.ChangingOverTimePropertyValidator;
import org.faktorips.devtools.model.internal.productcmpttype.Messages;
import org.faktorips.devtools.model.internal.type.Attribute;
import org.faktorips.devtools.model.internal.valueset.UnrestrictedValueSet;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.type.AttributeProperty;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductCmptTypeAttribute
extends Attribute
implements IProductCmptTypeAttribute {
    static final String TAG_NAME = "Attribute";
    private IValueSet valueSet = new UnrestrictedValueSet(this, this.getNextPartId());

    public ProductCmptTypeAttribute(IProductCmptType parent, String id) {
        super(parent, id);
        this.initPropertyDefaultVisible();
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    private void initPropertyDefaultVisible() {
        this.setProperty(AttributeProperty.VISIBLE, true);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.setProperty(AttributeProperty.MULTI_VALUE_ATTRIBUTE, XmlUtil.getBooleanAttributeOrFalse(element, "multiValueAttribute"));
        if (element.hasAttribute("visible")) {
            String visibleElement = element.getAttribute("visible");
            this.setProperty(AttributeProperty.VISIBLE, Boolean.parseBoolean(visibleElement));
        }
        this.setProperty(AttributeProperty.MULTILINGUAL, XmlUtil.getBooleanAttributeOrFalse(element, "multilingual"));
    }

    @Override
    protected void initPropertyDefaultChangingOverTime() {
        this.setProperty(AttributeProperty.CHANGING_OVER_TIME, this.getProductCmptType().isChangingOverTime());
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (this.isMultiValueAttribute()) {
            element.setAttribute("multiValueAttribute", String.valueOf(this.isMultiValueAttribute()));
        }
        element.setAttribute("visible", String.valueOf(this.isVisible()));
        if (this.isMultilingual()) {
            element.setAttribute("multilingual", String.valueOf(this.isMultilingual()));
        }
    }

    @Override
    public IProductCmptType getProductCmptType() {
        return (IProductCmptType)this.getParent();
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public ProductCmptPropertyType getProductCmptPropertyType() {
        return ProductCmptPropertyType.PRODUCT_CMPT_TYPE_ATTRIBUTE;
    }

    @Override
    public List<PropertyValueType> getPropertyValueTypes() {
        return Arrays.asList(PropertyValueType.ATTRIBUTE_VALUE);
    }

    @Override
    public boolean isDerived() {
        return false;
    }

    public ValueDatatype getValueDatatype() {
        return this.findDatatype(this.getIpsProject());
    }

    @Override
    public IValueSet getValueSet() {
        return this.valueSet;
    }

    @Override
    public List<ValueSetType> getAllowedValueSetTypes(IIpsProject ipsProject) {
        if (this.isMultilingual()) {
            ArrayList<ValueSetType> types = new ArrayList<ValueSetType>();
            types.add(ValueSetType.UNRESTRICTED);
            return types;
        }
        return ipsProject.getValueSetTypes(this.findDatatype(ipsProject));
    }

    @Override
    public boolean isValueSetUpdateable() {
        return true;
    }

    @Override
    public void setValueSetType(ValueSetType newType) {
        ArgumentCheck.notNull((Object)((Object)newType));
        if (newType == this.valueSet.getValueSetType()) {
            return;
        }
        this.valueSet = newType.newValueSet(this, this.getNextPartId());
        this.objectHasChanged();
    }

    @Override
    public IValueSet changeValueSetType(ValueSetType newType) {
        this.setValueSetType(newType);
        return this.valueSet;
    }

    @Override
    public void setValueSetCopy(IValueSet source) {
        IValueSet oldset = this.valueSet;
        this.valueSet = source.copy(this, this.getNextPartId());
        this.valueChanged(oldset, this.valueSet);
    }

    @Override
    public boolean isMultiValueAttribute() {
        return this.isPropertySet(AttributeProperty.MULTI_VALUE_ATTRIBUTE);
    }

    @Override
    public void setMultiValueAttribute(boolean multiValueAttribute) {
        boolean oldValue = this.isPropertySet(AttributeProperty.MULTI_VALUE_ATTRIBUTE);
        this.setProperty(AttributeProperty.MULTI_VALUE_ATTRIBUTE, multiValueAttribute);
        this.valueChanged(oldValue, multiValueAttribute);
    }

    @Override
    public boolean isVisible() {
        return this.isPropertySet(AttributeProperty.VISIBLE);
    }

    @Override
    public void setVisible(boolean visible) {
        boolean old = this.isPropertySet(AttributeProperty.VISIBLE);
        this.setProperty(AttributeProperty.VISIBLE, visible);
        this.valueChanged(old, visible, "visible");
    }

    @Override
    public boolean isMultilingualSupported() {
        return Datatype.STRING.getQualifiedName().equals(this.getDatatype());
    }

    @Override
    public boolean isMultilingual() {
        return this.isPropertySet(AttributeProperty.MULTILINGUAL) && this.isMultilingualSupported();
    }

    @Override
    public void setMultilingual(boolean multilingual) {
        boolean old = this.isPropertySet(AttributeProperty.MULTILINGUAL);
        this.setProperty(AttributeProperty.MULTILINGUAL, multilingual);
        this.valueChanged(old, multilingual, "multilingual");
    }

    @Override
    public String getPropertyDatatype() {
        return this.getDatatype();
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        if (this.valueSet != null) {
            return new IIpsElement[]{this.valueSet};
        }
        return new IIpsElement[0];
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof IValueSet) {
            this.valueSet = (IValueSet)part;
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        if (xmlTag.getNodeName().equals("ValueSet")) {
            this.valueSet = ValueSetType.newValueSet(xmlTag, this, id);
            return this.valueSet;
        }
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        return null;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof IValueSet) {
            this.valueSet = new UnrestrictedValueSet(this, this.getNextPartId());
            return true;
        }
        return false;
    }

    @Override
    protected void reinitPartCollectionsThis() {
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return this.getProductCmptType();
    }

    @Override
    public boolean isPolicyCmptTypeProperty() {
        return false;
    }

    @Override
    public boolean isPropertyFor(IPropertyValue propertyValue) {
        return this.getProductCmptPropertyType().isMatchingPropertyValue(this.getPropertyName(), propertyValue);
    }

    @Override
    protected void validateThis(MessageList result, IIpsProject ipsProject) {
        super.validateThis(result, ipsProject);
        this.validateAllowedValueSetTypes(result);
        this.validateOverwriteFlag(result, ipsProject);
        this.validateChangingOverTimeFlag(result);
    }

    private void validateAllowedValueSetTypes(MessageList result) {
        if (!this.getAllowedValueSetTypes(this.getIpsProject()).contains((Object)this.getValueSet().getValueSetType())) {
            result.add(Message.newError((String)"ATTRIBUTE-InvalidValueSet", (String)MessageFormat.format(Messages.ProductCmptTypeAttribute_msg_invalidValueSet, this.getValueSet().getValueSetType().getName(), this.getPropertyName()), (Object)this, (String[])new String[]{"valueSet"}));
        }
    }

    private void validateOverwriteFlag(MessageList result, IIpsProject ipsProject) {
        IProductCmptTypeAttribute superAttr;
        if (this.isOverwrite() && (superAttr = (IProductCmptTypeAttribute)this.findOverwrittenAttribute(ipsProject)) != null) {
            if (this.isMultiValueAttribute() != superAttr.isMultiValueAttribute()) {
                result.add(new Message("ATTRIBUTE-OverwrittenAttributeSingeMultiValueDiffers", Messages.ProductCmptTypeAttribute_msgOverwritten_singleValueMultipleValuesDifference, Message.ERROR, (Object)this, new String[]{"multiValueAttribute"}));
            }
            if (this.isMultilingual() != superAttr.isMultilingual()) {
                result.add(Message.newError((String)"ATTRIBUTE-OverwrittenAttributeMultilingualDiffers", (String)Messages.ProductCmptTypeAttribute_msgOverwritten_multilingual_different, (Object)this, (String[])new String[]{"multilingual"}));
            }
        }
    }

    private void validateChangingOverTimeFlag(MessageList result) {
        ChangingOverTimePropertyValidator propertyValidator = new ChangingOverTimePropertyValidator(this);
        propertyValidator.validateTypeDoesNotAcceptChangingOverTime(result);
    }

    @Override
    protected void validateDefaultValue(ValueDatatype valueDatatype, MessageList result, IIpsProject ipsProject) {
        if (this.isMultiValueAttribute() && this.getDefaultValue() != null) {
            this.validateMultiDefaultValues(valueDatatype, result, ipsProject);
        } else {
            super.validateDefaultValue(valueDatatype, result, ipsProject);
        }
    }

    private void validateMultiDefaultValues(ValueDatatype valueDatatype, MessageList result, IIpsProject ipsProject) {
        String[] split;
        String[] stringArray = split = MultiValueHolder.Factory.getSplitMultiValue(this.getDefaultValue());
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String singleValue = stringArray[n2];
            this.validateDefaultValue(singleValue, valueDatatype, result, ipsProject);
            ++n2;
        }
    }

    @Override
    protected void validateDefaultValue(String defaultValueToValidate, ValueDatatype valueDatatype, MessageList result, IIpsProject ipsProject) {
        super.validateDefaultValue(defaultValueToValidate, valueDatatype, result, ipsProject);
        this.validateDefaultValue(defaultValueToValidate, result);
    }

    private void validateDefaultValue(String defaultValue, MessageList result) {
        if (!this.isVisible() && !this.getValueSet().containsValue(defaultValue, this.getIpsProject())) {
            result.remove(result.getMessageByCode("ATTRIBUTE-DefaultNotInValueSet"));
            result.newError("ATTRIBUTE-DefaultNotInValueSetWhileHidden", MessageFormat.format(Messages.ProductCmptTypeAttribute_msgDefaultValueNotInValueSetWhileHidden, defaultValue), (Object)this, new String[]{"defaultValue"});
        }
    }

    @Override
    public boolean isChangingOverTimeValidationNecessary() {
        return true;
    }
}

