/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpttype;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.internal.method.Method;
import org.faktorips.devtools.model.internal.productcmpttype.ChangingOverTimePropertyValidator;
import org.faktorips.devtools.model.internal.productcmpttype.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeMethod;
import org.faktorips.devtools.model.type.IMethod;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Element;

public class ProductCmptTypeMethod
extends Method
implements IProductCmptTypeMethod {
    private static final String XML_FORMULA_MANDATORY = "mandatory";
    private boolean formulaSignatureDefinition = true;
    private boolean overloadsFormula = false;
    private boolean formulaMandatory = true;
    private String formulaName = "";
    private boolean changingOverTime = this.getProductCmptType().isChangingOverTime();

    public ProductCmptTypeMethod(IProductCmptType parent, String id) {
        super(parent, id);
    }

    @Override
    public IProductCmptType getProductCmptType() {
        return (IProductCmptType)this.getParent();
    }

    @Override
    public boolean isFormulaSignatureDefinition() {
        return this.formulaSignatureDefinition;
    }

    @Override
    public void setFormulaSignatureDefinition(boolean newValue) {
        boolean oldValue = this.formulaSignatureDefinition;
        this.formulaSignatureDefinition = newValue;
        if (!this.formulaSignatureDefinition) {
            this.setFormulaName("");
            this.overloadsFormula = false;
        } else {
            this.setAbstract(false);
        }
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public void setOverloadsFormula(boolean enabled) {
        boolean oldValue = this.overloadsFormula;
        this.overloadsFormula = enabled;
        this.valueChanged(oldValue, enabled);
    }

    @Override
    public boolean isOverloadsFormula() {
        return this.overloadsFormula;
    }

    @Override
    public IProductCmptTypeMethod findOverloadedFormulaMethod(IIpsProject ipsProject) {
        if (!this.isOverloadsFormula()) {
            return null;
        }
        FormulaNameFinder finder = new FormulaNameFinder(ipsProject);
        finder.start((IProductCmptType)this.getProductCmptType().findSupertype(ipsProject));
        return finder.method;
    }

    @Override
    public String getDefaultMethodName() {
        if (this.isFormulaSignatureDefinition()) {
            return "compute" + StringUtils.capitalize((String)this.getFormulaName());
        }
        return "";
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        String mandatoryXml;
        super.initPropertiesFromXml(element, id);
        if (element.hasAttribute("formulaSignatureDefinition")) {
            this.formulaSignatureDefinition = Boolean.parseBoolean(element.getAttribute("formulaSignatureDefinition"));
        }
        this.overloadsFormula = XmlUtil.getBooleanAttributeOrFalse(element, "overloadsFormula");
        this.formulaName = XmlUtil.getAttributeOrEmptyString(element, "formulaName");
        if (element.hasAttribute("changingOverTime")) {
            this.changingOverTime = Boolean.parseBoolean(element.getAttribute("changingOverTime"));
        }
        this.formulaMandatory = IpsStringUtils.isEmpty((String)(mandatoryXml = element.getAttribute(XML_FORMULA_MANDATORY))) ? true : Boolean.parseBoolean(mandatoryXml);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("formulaSignatureDefinition", String.valueOf(this.formulaSignatureDefinition));
        if (this.overloadsFormula) {
            element.setAttribute("overloadsFormula", String.valueOf(this.overloadsFormula));
        }
        if (IpsStringUtils.isNotEmpty((String)this.formulaName)) {
            element.setAttribute("formulaName", String.valueOf(this.formulaName));
        }
        element.setAttribute("changingOverTime", String.valueOf(this.changingOverTime));
        element.setAttribute(XML_FORMULA_MANDATORY, String.valueOf(this.formulaMandatory));
    }

    @Override
    public String getPropertyName() {
        if (this.formulaSignatureDefinition) {
            return this.getFormulaName();
        }
        return "";
    }

    @Override
    public ProductCmptPropertyType getProductCmptPropertyType() {
        if (this.formulaSignatureDefinition) {
            return ProductCmptPropertyType.FORMULA_SIGNATURE_DEFINITION;
        }
        return null;
    }

    @Override
    public List<PropertyValueType> getPropertyValueTypes() {
        return Arrays.asList(PropertyValueType.FORMULA);
    }

    @Override
    protected void validateThis(MessageList result, IIpsProject ipsProject) {
        String text;
        Datatype datatype;
        super.validateThis(result, ipsProject);
        this.validateChangingOverTime(result, ipsProject);
        if (!this.isFormulaSignatureDefinition()) {
            return;
        }
        if (IpsStringUtils.isEmpty((String)this.getFormulaName())) {
            String text2 = Messages.ProductCmptTypeMethod_FormulaNameIsMissing;
            result.add(new Message("METHOD-FormulaNameIsEmpty", text2, Message.ERROR, (Object)this, new String[]{"formulaName"}));
        }
        if ((datatype = this.findDatatype(ipsProject)) != null && (datatype.isVoid() || !datatype.isValueDatatype())) {
            text = Messages.ProductCmptTypeMethod_FormulaSignatureDatatypeMustBeAValueDatatype;
            result.add(new Message("METHOD-DatatypeMustBeAValueDatatypeForFormulaSignature", text, Message.ERROR, (Object)this, new String[]{"datatype"}));
        }
        if (this.isAbstract()) {
            text = Messages.ProductCmptTypeMethod_FormulaSignatureMustntBeAbstract;
            result.add(new Message("METHOD-FormulaMustntBeAbstract", text, Message.ERROR, (Object)this, new String[]{"abstract"}));
        }
        this.validateOverloadedFormulaSignature(result, ipsProject);
    }

    protected void validateOverloadedFormulaSignature(MessageList result, IIpsProject ipsProject) {
        if (this.isFormulaSignatureDefinition() && this.isOverloadsFormula() && !IpsStringUtils.isEmpty((String)this.getFormulaName())) {
            FormulaNameFinder finder = new FormulaNameFinder(ipsProject);
            finder.start(this.getProductCmptType().findSuperProductCmptType(ipsProject));
            if (!finder.isOverloadedMethodAvailable()) {
                result.add(new Message("METHOD-NoFormulaWithSameNameInTypeHierarchy", Messages.ProductCmptTypeMethod_msgNoOverloadableFormulaInSupertypeHierarchy, Message.ERROR, (Object)this, new String[]{"overloadsFormula"}));
            } else {
                this.validateFormulaMandatoryOverloaded(result, finder);
            }
        }
    }

    private void validateFormulaMandatoryOverloaded(MessageList result, FormulaNameFinder finder) {
        if (!this.isFormulaMandatory() && finder.getMethod().isFormulaMandatory()) {
            result.add(new Message("METHOD-NotOptionalIfNotOptionalInTypeHierarchy", Messages.ProductCmptTypeMethod_msgOptionalNotAllowedBecauseNotOptionalInSupertypeHierarchy, Message.ERROR, (Object)this, new String[]{"formulaMandatory"}));
        }
    }

    protected void validateChangingOverTime(MessageList result, IIpsProject ipsProject) {
        if (!IpsStringUtils.isEmpty((String)this.getName())) {
            ChangingOverTimePropertyValidator propertyValidator = new ChangingOverTimePropertyValidator(this);
            propertyValidator.validateTypeDoesNotAcceptChangingOverTime(result);
            IMethod superMethod = this.findOverriddenMethod(ipsProject);
            if (superMethod == null) {
                superMethod = this.findOverloadedFormulaMethod(ipsProject);
            }
            if (superMethod == null) {
                return;
            }
            IProductCmptTypeMethod method = (IProductCmptTypeMethod)superMethod;
            if (method.isChangingOverTime() && !this.isChangingOverTime()) {
                result.add(new Message("METHOD-ChangingOverTimeIfNotChangingOverTimeInTypeHierarchy", Messages.ProductCmptTypeMethod_msgNotChangingOverTimeNotAllowedBecauseChangingOverTimeInSupertypeHierarchy, Message.ERROR, (Object)this, new String[]{"changingOverTime"}));
            }
            if (this.isChangingOverTime() && !method.isChangingOverTime()) {
                result.add(new Message("METHOD-NotChangingOverTimeIfChangingOverTimeInTypeHierarchy", Messages.ProductCmptTypeMethod_msgChangingOverTimeNotAllowedBecauseNotChangingOverTimeInSupertypeHierarchy, Message.ERROR, (Object)this, new String[]{"changingOverTime"}));
            }
        }
    }

    @Override
    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    @Override
    public String getPropertyDatatype() {
        return this.getDatatype();
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return this.getProductCmptType();
    }

    @Override
    public boolean isPolicyCmptTypeProperty() {
        return false;
    }

    @Override
    public boolean isPropertyFor(IPropertyValue propertyValue) {
        return this.getProductCmptPropertyType().isMatchingPropertyValue(this.getPropertyName(), propertyValue);
    }

    @Override
    public boolean isFormulaMandatory() {
        return this.formulaMandatory || !this.isFormulaOptionalSupported();
    }

    @Override
    public void setFormulaMandatory(boolean formulaMandatory) {
        boolean oldValue = this.formulaMandatory;
        this.formulaMandatory = formulaMandatory;
        this.valueChanged(oldValue, formulaMandatory);
    }

    @Override
    public boolean isFormulaOptionalSupported() {
        return this.isFormulaSignatureDefinition();
    }

    @Override
    public String getFormulaName() {
        return this.formulaName;
    }

    @Override
    public void setFormulaName(String newFormulaName) {
        String oldFormulaName = this.getFormulaName();
        this.formulaName = newFormulaName;
        this.valueChanged(oldFormulaName, this.formulaName, "formulaName");
    }

    @Override
    public void setChangingOverTime(boolean changingOverTime) {
        boolean oldValue = this.changingOverTime;
        this.changingOverTime = changingOverTime;
        this.valueChanged(oldValue, changingOverTime, "changingOverTime");
    }

    private class FormulaNameFinder
    extends TypeHierarchyVisitor<IProductCmptType> {
        private IProductCmptTypeMethod method;

        public FormulaNameFinder(IIpsProject ipsProject) {
            super(ipsProject);
        }

        private boolean isOverloadedMethodAvailable() {
            return this.method != null;
        }

        @Override
        protected boolean visit(IProductCmptType currentType) {
            if (IpsStringUtils.isEmpty((String)ProductCmptTypeMethod.this.getFormulaName()) || currentType == null) {
                return false;
            }
            this.method = currentType.getFormulaSignature(ProductCmptTypeMethod.this.getFormulaName());
            return this.method == null;
        }

        private IProductCmptTypeMethod getMethod() {
            return this.method;
        }
    }
}

