/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpttype;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.productcmpttype.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;

public class ProductCmptTypeValidations {
    private ProductCmptTypeValidations() {
    }

    public static Message validateProductCmptTypeAbstractWhenPolicyCmptTypeAbstract(boolean isPolicyCmptTypeAbstract, boolean isProductCmptTypeAbstract, IProductCmptType thisProductCmptType) {
        if (isPolicyCmptTypeAbstract && !isProductCmptTypeAbstract) {
            ObjectProperty[] objectPropertyArray;
            if (thisProductCmptType != null) {
                ObjectProperty[] objectPropertyArray2 = new ObjectProperty[1];
                objectPropertyArray = objectPropertyArray2;
                objectPropertyArray2[0] = new ObjectProperty((Object)thisProductCmptType, "abstract");
            } else {
                objectPropertyArray = new ObjectProperty[]{};
            }
            return new Message("ProductCmptType-ProductCmptTypeAbstractWhenPolicyCmptTypeAbstract", Messages.ProductCmptType_msgProductCmptTypeAbstractWhenPolicyCmptTypeAbstract, Message.ERROR, objectPropertyArray);
        }
        return null;
    }

    public static Message validateSupertype(IProductCmptType productCmptType, IProductCmptType superProductCmptType, String policyCmptType, String superPolicyCmptType, IIpsProject ipsProject) {
        ObjectProperty[] objectPropertyArray;
        Message message = null;
        if (productCmptType == null) {
            objectPropertyArray = new ObjectProperty[]{};
        } else {
            ObjectProperty[] objectPropertyArray2 = new ObjectProperty[2];
            objectPropertyArray2[0] = new ObjectProperty((Object)productCmptType, "supertype");
            objectPropertyArray = objectPropertyArray2;
            objectPropertyArray2[1] = new ObjectProperty((Object)productCmptType, "policyCmptType");
        }
        ObjectProperty[] invalidObjectProperties = objectPropertyArray;
        if (superProductCmptType == null) {
            IPolicyCmptType foundSuperPolicyCmptType = ipsProject.findPolicyCmptType(superPolicyCmptType);
            if (foundSuperPolicyCmptType != null && foundSuperPolicyCmptType.isConfigurableByProductCmptType()) {
                String text = Messages.ProductCmptType_MustInheritFromASupertype;
                message = new Message("ProductCmptType-MustHaveSupertype", text, Message.ERROR, invalidObjectProperties);
            }
        } else {
            String policyCmptTypeOfProductSupertype = superProductCmptType.getPolicyCmptType();
            if (!ProductCmptTypeValidations.isConsistentHierarchy(policyCmptType, superPolicyCmptType, policyCmptTypeOfProductSupertype, superProductCmptType, ipsProject)) {
                String text = Messages.ProductCmptType_InconsistentTypeHierarchies;
                message = new Message("ProductCmptType-HierarchyMismatch", text, Message.ERROR, invalidObjectProperties);
            }
        }
        return message;
    }

    public static void validateSuperProductCmptTypeHasSameChangingOverTimeSetting(MessageList list, IProductCmptType productCmptType, IProductCmptType superProductCmptType) {
        if (superProductCmptType == null) {
            return;
        }
        if (productCmptType.isChangingOverTime() != superProductCmptType.isChangingOverTime()) {
            String changingOverTimePluralName = IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNamePlural();
            String text = MessageFormat.format(Messages.ProductCmptType_error_settingChangingOverTimeDiffersFromSettingInSupertype, changingOverTimePluralName, superProductCmptType.getQualifiedName());
            list.newError("ProductCmptType-SettingChangingOverTimeDiffersFromSupertype", text, (Object)productCmptType, new String[]{"changingOverTime"});
        }
    }

    static boolean isConsistentHierarchy(String policyCmptType, String superPolicyCmptType, String policyCmptTypeOfProductSupertype, IProductCmptType superProductCmptType, IIpsProject ipsProject) {
        if (ProductCmptTypeValidations.isPCTypeConfiguredByConsistentProductCmptType(policyCmptType, superPolicyCmptType, policyCmptTypeOfProductSupertype)) {
            return true;
        }
        IPolicyCmptType foundSuperPolicyCmptType = ipsProject.findPolicyCmptType(superPolicyCmptType);
        return ProductCmptTypeValidations.isPolicyAndProductCmptTypeNotConfigured(superProductCmptType, foundSuperPolicyCmptType);
    }

    private static boolean isPCTypeConfiguredByConsistentProductCmptType(String policyCmptType, String superPolicyCmptType, String policyCmptTypeOfProductSupertype) {
        return policyCmptType.equals(policyCmptTypeOfProductSupertype) || superPolicyCmptType.equals(policyCmptTypeOfProductSupertype);
    }

    private static boolean isPolicyAndProductCmptTypeNotConfigured(IProductCmptType superProductCmptType, IPolicyCmptType foundSuperPolicyCmptType) {
        return !superProductCmptType.isConfigurationForPolicyCmptType() && (foundSuperPolicyCmptType == null || !foundSuperPolicyCmptType.isConfigurableByProductCmptType());
    }
}

