/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpttype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.productcmpttype.ChangingOverTimePropertyValidator;
import org.faktorips.devtools.model.internal.productcmpttype.Messages;
import org.faktorips.devtools.model.internal.type.TypePart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.ITableStructureUsage;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.devtools.model.util.ListElementMover;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableStructureUsage
extends TypePart
implements ITableStructureUsage {
    static final String TAG_NAME = "TableStructureUsage";
    static final String TAG_NAME_TABLE_STRUCTURE = "TableStructure";
    private boolean mandatoryTableContent = false;
    private List<TableStructureReference> tableStructures = new ArrayList<TableStructureReference>();
    private boolean changingOverTime = this.getProductCmptType().isChangingOverTime();

    public TableStructureUsage(IProductCmptType pcType, String id) {
        super(pcType, id);
    }

    @Override
    public IProductCmptType getProductCmptType() {
        return (IProductCmptType)this.getParent();
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        return this.tableStructures.toArray(new IIpsElement[this.tableStructures.size()]);
    }

    @Override
    public IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        if (partType.equals(TableStructureReference.class)) {
            return this.newTableStructureReference();
        }
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if (xmlTagName.equals(TAG_NAME_TABLE_STRUCTURE)) {
            return this.newTableStructureReferenceInternal(id);
        }
        return null;
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof TableStructureReference) {
            this.tableStructures.add((TableStructureReference)part);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof TableStructureReference) {
            this.tableStructures.remove(part);
            return true;
        }
        return false;
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.tableStructures.clear();
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.name = element.getAttribute("roleName");
        this.mandatoryTableContent = XmlUtil.getBooleanAttributeOrFalse(element, "mandatoryTableContent");
        if (element.hasAttribute("changingOverTime")) {
            this.changingOverTime = Boolean.parseBoolean(element.getAttribute("changingOverTime"));
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("roleName", this.name);
        if (this.mandatoryTableContent) {
            element.setAttribute("mandatoryTableContent", "" + this.mandatoryTableContent);
        }
        element.setAttribute("changingOverTime", "" + this.changingOverTime);
    }

    @Override
    public String getRoleName() {
        return this.name;
    }

    @Override
    public void setRoleName(String newRoleName) {
        String oldRoleName = this.name;
        this.name = newRoleName;
        this.valueChanged(oldRoleName, newRoleName);
    }

    @Override
    public boolean isMandatoryTableContent() {
        return this.mandatoryTableContent;
    }

    @Override
    public void setMandatoryTableContent(boolean mandatoryTableContent) {
        boolean oldIsMandatory = this.mandatoryTableContent;
        this.mandatoryTableContent = mandatoryTableContent;
        this.valueChanged(oldIsMandatory, mandatoryTableContent);
    }

    @Override
    public String[] getTableStructures() {
        String[] result = new String[this.tableStructures.size()];
        int i = 0;
        while (i < result.length) {
            TableStructureReference tsr = this.tableStructures.get(i);
            result[i] = tsr.getTableStructure();
            ++i;
        }
        return result;
    }

    @Override
    public void addTableStructure(String tableStructure) {
        if (this.getTableStructureReference(tableStructure) != null) {
            return;
        }
        TableStructureReference tsr = this.newTableStructureReferenceInternal(this.getNextPartId());
        tsr.setTableStructure(tableStructure);
        this.objectHasChanged();
    }

    @Override
    public boolean isUsed(String tableStructure) {
        if (tableStructure == null) {
            return false;
        }
        for (TableStructureReference tsr : this.tableStructures) {
            if (!tableStructure.equals(tsr.tableStructure)) continue;
            return true;
        }
        return false;
    }

    private TableStructureReference newTableStructureReference() {
        TableStructureReference tsr = this.newTableStructureReferenceInternal(this.getNextPartId());
        this.objectHasChanged();
        return tsr;
    }

    private TableStructureReference newTableStructureReferenceInternal(String id) {
        TableStructureReference tsr = new TableStructureReference(this, id);
        this.tableStructures.add(tsr);
        return tsr;
    }

    @Override
    public void removeTableStructure(String tableStructure) {
        TableStructureReference toBeDeleted = this.getTableStructureReference(tableStructure);
        if (toBeDeleted != null) {
            this.tableStructures.remove(toBeDeleted);
            this.objectHasChanged();
        }
    }

    protected TableStructureReference getTableStructureReference(String tableStructure) {
        for (TableStructureReference tsr : this.tableStructures) {
            if (tsr.getTableStructure() == null || !tsr.getTableStructure().equals(tableStructure)) continue;
            return tsr;
        }
        return null;
    }

    public void removeTableStructure(TableStructureReference tableStructureAssignment) {
        if (this.tableStructures.remove(tableStructureAssignment)) {
            this.objectHasChanged();
        }
    }

    @Override
    public int[] moveTableStructure(int[] indexes, boolean up) {
        ListElementMover<TableStructureReference> mover = new ListElementMover<TableStructureReference>(this.tableStructures);
        return mover.move(indexes, up);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        Message msg;
        String text;
        super.validateThis(list, ipsProject);
        if (!ValidationUtils.validateFieldName(this.name, ipsProject)) {
            text = MessageFormat.format(Messages.TableStructureUsage_msgInvalidRoleName, this.name);
            msg = new Message("TableStructureUsage-InvalidRoleName", text, Message.ERROR, (Object)this, new String[]{"roleName"});
            list.add(msg);
        }
        if (this.tableStructures.size() == 0) {
            text = Messages.TableStructureUsage_msgAtLeastOneStructureMustBeReferenced;
            msg = new Message("TableStructureUsage-MustReferenceAtLeast1Structure", text, Message.ERROR, (Object)this, new String[]{"tableStructure"});
            list.add(msg);
        }
        this.validateRoleNameInSupertypeHierarchy(list);
        this.validateChangingOverTime(list);
    }

    private void validateRoleNameInSupertypeHierarchy(MessageList msgList) {
        IProductCmptType supertype = this.getProductCmptType().findSuperProductCmptType(this.getIpsProject());
        if (supertype == null) {
            return;
        }
        ITableStructureUsage tsu = supertype.findTableStructureUsage(this.name, this.getIpsProject());
        if (tsu != null) {
            String msg = MessageFormat.format(Messages.TableStructureUsage_msgRoleNameAlreadyInSupertype, this.getRoleName());
            msgList.add(new Message("TableStructureUsage-RoleNameAlreadyInSupertype", msg, Message.ERROR));
        }
    }

    private void validateChangingOverTime(MessageList list) {
        ChangingOverTimePropertyValidator propertyValidator = new ChangingOverTimePropertyValidator(this);
        propertyValidator.validateTypeDoesNotAcceptChangingOverTime(list);
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public ProductCmptPropertyType getProductCmptPropertyType() {
        return ProductCmptPropertyType.TABLE_STRUCTURE_USAGE;
    }

    @Override
    public List<PropertyValueType> getPropertyValueTypes() {
        return Arrays.asList(PropertyValueType.TABLE_CONTENT_USAGE);
    }

    @Override
    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    @Override
    public void setChangingOverTime(boolean changingOverTime) {
        boolean oldValue = this.changingOverTime;
        this.changingOverTime = changingOverTime;
        this.valueChanged(oldValue, changingOverTime, "changingOverTime");
    }

    @Override
    public String getPropertyDatatype() {
        return "";
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return this.getProductCmptType();
    }

    @Override
    public boolean isPolicyCmptTypeProperty() {
        return false;
    }

    @Override
    public boolean isPropertyFor(IPropertyValue propertyValue) {
        return this.getProductCmptPropertyType().isMatchingPropertyValue(this.getPropertyName(), propertyValue);
    }

    public static class TableStructureReference
    extends AtomicIpsObjectPart {
        private String tableStructure = "";

        public TableStructureReference(ITableStructureUsage tableStructureUsage, String id) {
            super(tableStructureUsage, id);
        }

        @Override
        protected Element createElement(Document doc) {
            return doc.createElement(TableStructureUsage.TAG_NAME_TABLE_STRUCTURE);
        }

        @Override
        protected void initPropertiesFromXml(Element element, String id) {
            super.initPropertiesFromXml(element, id);
            this.tableStructure = element.getAttribute("tableStructure");
        }

        @Override
        protected void propertiesToXml(Element element) {
            super.propertiesToXml(element);
            element.setAttribute("tableStructure", this.tableStructure);
        }

        public String getTableStructure() {
            return this.tableStructure;
        }

        public void setTableStructure(String tableStructure) {
            String oldStructure = this.tableStructure;
            this.tableStructure = tableStructure;
            this.valueChanged(oldStructure, tableStructure);
        }

        @Override
        protected void validateThis(MessageList list, IIpsProject ipsProject) {
            super.validateThis(list, ipsProject);
            if (this.getIpsProject().findIpsObject(IpsObjectType.TABLE_STRUCTURE, this.getTableStructure()) == null) {
                String text = MessageFormat.format(Messages.TableStructureUsage_msgTableStructureNotExists, this.getTableStructure());
                Message msg = new Message("TableStructureUsage-TableStructureNotFound", text, Message.ERROR, (Object)this);
                list.add(msg);
            }
        }
    }
}

