/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.model.internal.tablecontents.Row;
import org.faktorips.devtools.model.internal.tablestructure.ColumnRange;
import org.faktorips.devtools.model.tablestructure.ColumnRangeType;
import org.faktorips.devtools.model.tablestructure.IColumnRange;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.IKeyItem;
import org.faktorips.devtools.model.tablestructure.ITableStructure;

public abstract class AbstractKeyValue {
    private final ITableStructure structure;
    private final IIndex uniqueKey;
    private final Row row;

    protected AbstractKeyValue(ITableStructure structure, IIndex uniqueKey, Row row) {
        this.structure = structure;
        this.uniqueKey = uniqueKey;
        this.row = row;
    }

    protected static List<IKeyItem> getNonTwoColumnRangeKeyItems(IIndex uniqueKey) {
        IKeyItem[] keyItems = uniqueKey.getKeyItems();
        ArrayList<IKeyItem> result = new ArrayList<IKeyItem>(keyItems.length);
        IKeyItem[] iKeyItemArray = keyItems;
        int n = keyItems.length;
        int n2 = 0;
        while (n2 < n) {
            IKeyItem keyItem = iKeyItemArray[n2];
            if (!(keyItem instanceof IColumnRange) || !ColumnRangeType.TWO_COLUMN_RANGE.equals(((IColumnRange)keyItem).getColumnRangeType())) {
                result.add(keyItem);
            }
            ++n2;
        }
        return result;
    }

    protected static List<ColumnRange> getTwoColumnRanges(IIndex uniqueKey) {
        IKeyItem[] keyItems = uniqueKey.getKeyItems();
        ArrayList<ColumnRange> columnRanges = new ArrayList<ColumnRange>();
        IKeyItem[] iKeyItemArray = keyItems;
        int n = keyItems.length;
        int n2 = 0;
        while (n2 < n) {
            IKeyItem keyItem = iKeyItemArray[n2];
            if (keyItem instanceof ColumnRange && ColumnRangeType.TWO_COLUMN_RANGE.equals(((ColumnRange)keyItem).getColumnRangeType())) {
                columnRanges.add((ColumnRange)keyItem);
            }
            ++n2;
        }
        return columnRanges;
    }

    public ITableStructure getStructure() {
        return this.structure;
    }

    public Row getRow() {
        return this.row;
    }

    public IIndex getUniqueKey() {
        return this.uniqueKey;
    }

    public boolean isValid() {
        return this.isValid(this.row);
    }

    public abstract boolean isValid(Row var1);

    protected abstract String getKeyValue();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + this.getKeyValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractKeyValue other = (AbstractKeyValue)obj;
        return this.getKeyValue().equals(other.getKeyValue());
    }
}

