/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import java.util.Arrays;
import java.util.List;
import org.faktorips.devtools.model.internal.tablecontents.AbstractKeyValue;
import org.faktorips.devtools.model.internal.tablecontents.Row;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.IKeyItem;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.internal.IpsStringUtils;

public class KeyValue
extends AbstractKeyValue {
    private final String value;

    public KeyValue(ITableStructure structure, IIndex uniqueKey, Row row) {
        super(structure, uniqueKey, row);
        this.value = this.evalValue(row);
    }

    public static KeyValue createKeyValue(ITableStructure structure, IIndex uniqueKey, Row row) {
        return new KeyValue(structure, uniqueKey, row);
    }

    @Override
    protected String getKeyValue() {
        return this.getValue();
    }

    @Override
    public boolean isValid(Row row) {
        String valueNew = this.evalValue(row);
        if (IpsStringUtils.isEmpty((String)valueNew) || IpsStringUtils.isEmpty((String)this.getValue())) {
            return false;
        }
        return this.getValue().equals(valueNew);
    }

    private String evalValue(Row row) {
        List<IKeyItem> keyItems = KeyValue.getNonTwoColumnRangeKeyItems(this.getUniqueKey());
        Object[] values = new String[keyItems.size()];
        int i = 0;
        while (i < keyItems.size()) {
            values[i] = KeyValue.getValueForKeyItem(this.getStructure(), row, keyItems.get(i));
            ++i;
        }
        return Arrays.toString(values);
    }

    private static String getValueForKeyItem(ITableStructure structure, Row row, IKeyItem keyItem) {
        IColumn[] columns = keyItem.getColumns();
        String value = "";
        int i = 0;
        while (i < columns.length) {
            int columnIndex = structure.getColumnIndex(columns[i]);
            if (columnIndex < row.getNoOfColumns()) {
                value = String.valueOf(value) + (i > 0 ? "#" : "");
                value = String.valueOf(value) + row.getValue(columnIndex);
            }
            ++i;
        }
        return value;
    }

    public String toString() {
        return String.valueOf(this.getUniqueKey().getName()) + ": " + this.getValue();
    }

    public String getValue() {
        return this.value;
    }
}

