/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import org.eclipse.core.runtime.IStatus;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.tablecontents.AbstractKeyValue;
import org.faktorips.devtools.model.internal.tablecontents.Row;
import org.faktorips.devtools.model.internal.tablestructure.ColumnRange;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.internal.IpsStringUtils;

public class KeyValueRange
extends AbstractKeyValue
implements Comparable<KeyValueRange> {
    private final ColumnRange columnRange;
    private final ValueDatatype valueDatatype;
    private String valueFrom;

    private KeyValueRange(ITableStructure structure, ValueDatatype[] datatypes, IIndex uniqueKey, ColumnRange columnRange, Row row) {
        super(structure, uniqueKey, row);
        this.columnRange = columnRange;
        this.valueDatatype = KeyValueRange.getValueDatatypeOfColumnRange(structure, datatypes, columnRange);
        this.valueFrom = this.evalValueFrom(row, columnRange);
    }

    public static KeyValueRange createKeyValue(ITableStructure structure, ValueDatatype[] datatypes, IIndex uniqueKey, Row row, ColumnRange columnRange) {
        return new KeyValueRange(structure, datatypes, uniqueKey, columnRange, row);
    }

    @Override
    protected String getKeyValue() {
        return this.getValueFrom();
    }

    @Override
    public boolean isValid(Row row) {
        return this.isValid(this.valueFrom, this.evalValueFrom(row, this.columnRange)) && this.isToGreaterOrEqualFrom();
    }

    public boolean isParsable() {
        if (this.valueDatatype == null) {
            return false;
        }
        return this.valueDatatype.isParsable(this.valueFrom) && this.valueDatatype.isParsable(this.evalValueTo(this.getRow(), this.columnRange));
    }

    public String getValueTo() {
        return this.evalValueTo(this.getRow(), this.columnRange);
    }

    public String getValueFrom() {
        return this.valueFrom;
    }

    private boolean isToGreaterOrEqualFrom() {
        return this.compareTo(this.evalValueTo(this.getRow(), this.columnRange), this.valueFrom) >= 0;
    }

    public boolean isFromLessOrEqual(String value) {
        return this.compareTo(this.valueFrom, value) <= 0;
    }

    private boolean isValid(String value1, String value2) {
        if (IpsStringUtils.isEmpty((String)value1) || IpsStringUtils.isEmpty((String)value2)) {
            return false;
        }
        return value1.equals(value2);
    }

    private String evalValueFrom(Row row, ColumnRange columnRange) {
        return KeyValueRange.evalValue(this.getStructure(), row, columnRange.getFromColumn());
    }

    private String evalValueTo(Row row, ColumnRange columnRange) {
        return KeyValueRange.evalValue(this.getStructure(), row, columnRange.getToColumn());
    }

    @Override
    public int compareTo(KeyValueRange keyValueRange) {
        return this.compareTo(this.getKeyValue(), keyValueRange.getKeyValue());
    }

    private int compareTo(String value1, String value2) {
        return KeyValueRange.compareTo(this.valueDatatype, value1, value2);
    }

    private static int compareTo(ValueDatatype valueDatatype, String value1, String value2) {
        return valueDatatype.compare(value1, value2);
    }

    private static ValueDatatype getValueDatatypeOfColumnRange(ITableStructure structure, ValueDatatype[] datatypes, ColumnRange columnRange) {
        if (datatypes != null) {
            try {
                int columnIndex = structure.getColumnIndex(columnRange.getFromColumn());
                if (columnIndex <= datatypes.length) {
                    return datatypes[columnIndex];
                }
                IpsLog.log((IStatus)new IpsStatus("Datatype of column " + columnRange.getFromColumn() + " not found!"));
            }
            catch (IpsException e) {
                IpsLog.log((IStatus)new IpsStatus("Column " + columnRange.getFromColumn() + " not found!"));
            }
        }
        return null;
    }

    private static String evalValue(ITableStructure tableStructure, Row row, String columnName) {
        return row.getValue(tableStructure.getColumnIndex(columnName));
    }

    public static boolean isRangeCollision(ITableStructure tableStructure, ValueDatatype[] valueDatatypes, ColumnRange otherColumnRange, Row row, Row otherRow) {
        String fromColumnName = otherColumnRange.getFromColumn();
        String toColumnName = otherColumnRange.getToColumn();
        String from = KeyValueRange.evalValue(tableStructure, row, fromColumnName);
        String otherTo = KeyValueRange.evalValue(tableStructure, otherRow, toColumnName);
        ValueDatatype valueDatatype = KeyValueRange.getValueDatatypeOfColumnRange(tableStructure, valueDatatypes, otherColumnRange);
        if (KeyValueRange.compareTo(valueDatatype, otherTo, from) < 0) {
            return false;
        }
        String otherFrom = KeyValueRange.evalValue(tableStructure, otherRow, fromColumnName);
        String to = KeyValueRange.evalValue(tableStructure, row, toColumnName);
        return KeyValueRange.compareTo(valueDatatype, to, otherFrom) >= 0;
    }

    public String toString() {
        return String.valueOf(this.getUniqueKey().getName()) + ": " + this.valueFrom + "- /" + this.evalValueTo(this.getRow(), this.columnRange);
    }
}

