/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.tablecontents.Messages;
import org.faktorips.devtools.model.internal.tablecontents.TableContents;
import org.faktorips.devtools.model.internal.tablecontents.TableRows;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablecontents.IRow;
import org.faktorips.devtools.model.tablecontents.ITableContents;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.IColumnRange;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.IKeyItem;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.devtools.model.util.ListElementMover;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Row
extends AtomicIpsObjectPart
implements IRow {
    static final String TAG_NAME = "Row";
    static final String VALUE_TAG_NAME = "Value";
    private ArrayList<String> values;
    private int rowNumber = 0;
    private int numberOfValues;

    Row(TableRows parent, String id) {
        super(parent, id);
        this.initValues();
        this.numberOfValues = this.getNumOfColumnsViaTableContents();
    }

    @Override
    public ITableContents getTableContents() {
        return (ITableContents)this.getParent().getParent();
    }

    public TableRows getTableRows() {
        return (TableRows)this.getParent();
    }

    private int getNumOfColumnsViaTableContents() {
        return ((ITableContents)this.getParent().getParent()).getNumOfColumns();
    }

    private void initValues() {
        this.values = new ArrayList<String>(Arrays.asList(new String[this.getNumOfColumnsViaTableContents()]));
    }

    void setNumberOfValues(int numberOfValues) {
        this.numberOfValues = numberOfValues;
    }

    @Override
    public String getName() {
        return "" + (this.rowNumber + 1);
    }

    @Override
    public String getCaption(Locale locale) {
        return MessageFormat.format(Messages.Row_caption, this.rowNumber + 1);
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    @Override
    public String getValue(int column) {
        return this.values.get(column);
    }

    @Override
    public void setValue(int column, String newValue) {
        this.setValueInternal(column, newValue);
        ITableStructure tableStructure = this.findTableStructure();
        if (tableStructure != null) {
            this.getTableRows().updateUniqueKeyCacheFor(this, tableStructure.getUniqueKeys());
        }
        this.objectHasChanged();
    }

    @Override
    public int moveValue(int columnIndex, boolean up) {
        ArgumentCheck.notNull(this.values);
        int index = columnIndex;
        if (up ? index == 0 : index == this.values.size() - 1) {
            return index;
        }
        int[] newIndex = this.moveParts(new int[]{index}, up);
        return newIndex[0];
    }

    @Override
    public void swapValue(int firstColumnIndex, int secondColumnIndex) {
        if (firstColumnIndex == secondColumnIndex || firstColumnIndex < 0 || secondColumnIndex < 0) {
            throw new IllegalArgumentException();
        }
        int positionOfFirstAttribute = firstColumnIndex;
        int positionOfSecondAttribute = secondColumnIndex;
        if (firstColumnIndex < secondColumnIndex) {
            positionOfFirstAttribute = secondColumnIndex;
            positionOfSecondAttribute = firstColumnIndex;
        }
        int currentIndex = positionOfFirstAttribute;
        while (currentIndex != positionOfSecondAttribute) {
            currentIndex = this.moveValue(currentIndex, true);
        }
        currentIndex = positionOfSecondAttribute + 1;
        while (currentIndex != positionOfFirstAttribute) {
            currentIndex = this.moveValue(currentIndex, false);
        }
    }

    private int[] moveParts(int[] indeces, boolean up) {
        ListElementMover<String> mover = new ListElementMover<String>(this.values);
        return mover.move(indeces, up);
    }

    protected ITableStructure findTableStructure() {
        return this.getTableContents().findTableStructure(this.getIpsProject());
    }

    public void setValueInternal(int column, String newValue) {
        this.values.set(column, newValue);
    }

    @Override
    public void newColumn(int insertAfter, String defaultValue) {
        if (insertAfter < this.values.size()) {
            this.values.add(Math.max(0, insertAfter), defaultValue);
        } else {
            this.values.add(defaultValue);
        }
        ++this.numberOfValues;
        this.objectHasChanged();
    }

    void removeColumn(int column) {
        this.values.remove(column);
        --this.numberOfValues;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        ITableStructure tableStructure = this.findTableStructure();
        if (tableStructure == null) {
            return;
        }
        if (this.numberOfValues != this.getNumOfColumnsViaTableContents()) {
            String text = MessageFormat.format(Messages.Row_NumberOfValuesIsInvalid, this.numberOfValues, this.getNumOfColumnsViaTableContents());
            Message message = new Message("NUMBER_OF_VALUES_IS_INVALID", text, Message.ERROR, (Object)this);
            list.add(message);
            return;
        }
        ValueDatatype[] datatypes = ((TableContents)this.getTableContents()).findColumnDatatypesByReferences(tableStructure, ipsProject);
        this.validateThis(list, tableStructure, datatypes);
    }

    private void validateThis(MessageList result, ITableStructure tableStructure, ValueDatatype[] datatypes) {
        List<IIndex> indices = tableStructure.getIndices();
        this.validateMissingAndInvalidIndexValue(result, datatypes, tableStructure, indices);
        this.validateRowValue(result, tableStructure, datatypes);
        if (!result.containsErrorMsg()) {
            this.validateUniqueKey(result, tableStructure, datatypes);
        }
    }

    private void validateUniqueKey(MessageList list, ITableStructure tableStructure, ValueDatatype[] datatypes) {
        MessageList validationMessageList = new MessageList();
        if (tableStructure.getUniqueKeys().length > 0) {
            this.getTableRows().validateUniqueKeys(validationMessageList, tableStructure, datatypes);
        }
        list.add(validationMessageList.getMessagesFor((Object)this));
    }

    /*
     * WARNING - void declaration
     */
    private void validateMissingAndInvalidIndexValue(MessageList list, ValueDatatype[] datatypes, ITableStructure structure, List<IIndex> indices) {
        if (structure.getNumOfColumns() != this.getTableContents().getNumOfColumns()) {
            return;
        }
        for (IIndex indexKey : indices) {
            IKeyItem[] keyItems;
            IKeyItem[] iKeyItemArray = keyItems = indexKey.getKeyItems();
            int n = keyItems.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyItem keyItem = iKeyItemArray[n2];
                IKeyItem iKeyItem = keyItem;
                if (iKeyItem instanceof IColumn) {
                    void column;
                    IColumn cfr_ignored_0 = (IColumn)iKeyItem;
                    IColumn cfr_ignored_1 = (IColumn)iKeyItem;
                    this.validateUniqueKeyValue(list, structure, column.getName());
                } else {
                    IKeyItem iKeyItem2 = keyItem;
                    if (iKeyItem2 instanceof IColumnRange) {
                        void columnRange;
                        IColumnRange cfr_ignored_2 = (IColumnRange)iKeyItem2;
                        IColumnRange cfr_ignored_3 = (IColumnRange)iKeyItem2;
                        if (columnRange.getColumnRangeType().isOneColumnFrom()) {
                            this.validateUniqueKeyValue(list, structure, columnRange.getFromColumn());
                        } else if (columnRange.getColumnRangeType().isOneColumnTo()) {
                            this.validateUniqueKeyValue(list, structure, columnRange.getToColumn());
                        } else if (columnRange.getColumnRangeType().isTwoColumn()) {
                            this.validateUniqueKeyValue(list, structure, columnRange.getFromColumn());
                            this.validateUniqueKeyValue(list, structure, columnRange.getToColumn());
                            this.validateFromAndToColumnCombination(list, datatypes, structure, columnRange.getFromColumn(), columnRange.getToColumn());
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void validateFromAndToColumnCombination(MessageList list, ValueDatatype[] datatypes, ITableStructure structure, String fromColumnName, String toColumnName) {
        try {
            int fromColumnIndex = structure.getColumnIndex(fromColumnName);
            int toColumnIndex = structure.getColumnIndex(toColumnName);
            ValueDatatype valueDatatypeFrom = datatypes[fromColumnIndex];
            ValueDatatype valueDatatypeTo = datatypes[toColumnIndex];
            if (valueDatatypeFrom == null || valueDatatypeTo == null || !valueDatatypeFrom.equals(valueDatatypeTo)) {
                return;
            }
            String valueFrom = this.getValue(fromColumnIndex);
            String valueTo = this.getValue(toColumnIndex);
            if (valueFrom == null || valueTo == null || !valueDatatypeFrom.isParsable(valueFrom) || !valueDatatypeTo.isParsable(valueTo)) {
                return;
            }
            if (valueDatatypeFrom.compare(this.getValue(fromColumnIndex), valueTo) > 0) {
                IColumn fromColumn = structure.getColumn(fromColumnIndex);
                IColumn toColumn = structure.getColumn(toColumnIndex);
                String localizedFromLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(fromColumn);
                String localizedToLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(toColumn);
                String text = MessageFormat.format(Messages.Row_FromValueGreaterThanToValue, String.valueOf(localizedFromLabel) + '-' + localizedToLabel);
                list.add(new Message("UniqueKeyFromVolumnValueIsGreaterToColumnValue", text, Message.ERROR, new ObjectProperty((Object)this, "value", fromColumnIndex)));
                list.add(new Message("UniqueKeyFromVolumnValueIsGreaterToColumnValue", text, Message.ERROR, new ObjectProperty((Object)this, "value", toColumnIndex)));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void validateUniqueKeyValue(MessageList list, ITableStructure structure, String columnName) {
        try {
            int columnIndex = structure.getColumnIndex(columnName);
            String localizedLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(structure.getColumn(columnIndex));
            String value = this.getValue(columnIndex);
            if (value != null && IpsStringUtils.isEmpty((String)value.trim()) || value == null) {
                String text = MessageFormat.format(Messages.Row_MissingValueForUniqueKey, localizedLabel);
                Message message = new Message("UNDEFINED_UNIQUE_KEY_VALUE", text, Message.ERROR, new ObjectProperty((Object)this, "value", columnIndex));
                list.add(message);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void validateRowValue(MessageList list, ITableStructure structure, ValueDatatype[] datatypes) {
        int numOfColumnsInStructure = structure.getNumOfColumns();
        int i = 0;
        while (i < this.getNumOfColumnsViaTableContents()) {
            if (i >= numOfColumnsInStructure || i >= datatypes.length) {
                return;
            }
            IColumn column = structure.getColumn(i);
            ValueDatatype dataType = datatypes[i];
            String value = this.getValue(i);
            if (dataType == null || !dataType.isParsable(value)) {
                String localizedLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(column);
                String datatypeName = dataType == null ? column.getDatatype() : dataType.toString();
                String text = MessageFormat.format(Messages.Row_ValueNotParsable, value, datatypeName, localizedLabel);
                Message message = new Message("VALUE_NOT_PARSABLE", text, Message.ERROR, new ObjectProperty((Object)this, "value", i));
                list.add(message);
            }
            ++i;
        }
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        NodeList nl = element.getElementsByTagName(VALUE_TAG_NAME);
        this.initValues();
        int i = 0;
        while (i < this.values.size()) {
            if (i < nl.getLength()) {
                Element valueElement = (Element)nl.item(i);
                String content = ValueToXmlHelper.getValueFromElement((Element)valueElement);
                this.values.set(i, content);
            }
            ++i;
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.removeAttribute("id");
        for (String value : this.values) {
            ValueToXmlHelper.addValueToElement((String)value, (Element)element, (String)VALUE_TAG_NAME);
        }
    }

    public int getNoOfColumns() {
        return this.values.size();
    }
}

