/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.faktorips.devtools.model.internal.tablecontents.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablecontents.ITableContents;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;

public class SingleTableContentsValidator {
    private ITableStructure tableStructure;
    private IIpsProject ipsProject;

    public SingleTableContentsValidator(IIpsProject ipsProject, ITableStructure tableStructure) {
        Assert.isNotNull((Object)ipsProject);
        this.ipsProject = ipsProject;
        this.tableStructure = tableStructure;
    }

    public static SingleTableContentsValidator createFor(ITableContents tableContents) {
        IIpsProject project = tableContents.getIpsProject();
        return new SingleTableContentsValidator(project, SingleTableContentsValidator.getStructureFor(tableContents, project));
    }

    private static ITableStructure getStructureFor(ITableContents tableContents, IIpsProject project) {
        return tableContents.findTableStructure(project);
    }

    public MessageList validateIfPossible() {
        MessageList messageList = new MessageList();
        if (this.canValidate()) {
            this.validateAndAppendMessages(messageList);
        }
        return messageList;
    }

    public boolean canValidate() {
        return this.tableStructure != null;
    }

    protected void validateAndAppendMessages(MessageList messageList) {
        if (this.isNumberOfContentsIllegal()) {
            String text = MessageFormat.format(Messages.TableContents_msgTooManyContentsForSingleTableStructure, this.tableStructure.getName());
            messageList.add(new Message("TABLECONTENTS-TooManyContentsForSingleTableStructure", text, Message.ERROR, (Object)this.tableStructure.getName(), new String[]{"tableStructure"}));
        }
    }

    private List<IIpsSrcFile> findContentSrcFiles() {
        return this.ipsProject.findAllTableContentsSrcFiles(this.tableStructure);
    }

    private boolean isNumberOfContentsIllegal() {
        return !this.tableStructure.isMultipleContentsAllowed() && this.getNumberofContents() > 1;
    }

    private int getNumberofContents() {
        List<IIpsSrcFile> contentSrcFiles = this.findContentSrcFiles();
        return contentSrcFiles.size();
    }

    public boolean forbidsAdditionalContents() {
        if (this.tableStructure == null) {
            return true;
        }
        return !this.tableStructure.isMultipleContentsAllowed() && this.getNumberofContents() >= 1;
    }
}

