/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.DependencyType;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.IPartReference;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.ipsobject.BaseIpsObject;
import org.faktorips.devtools.model.internal.ipsobject.DeprecationValidation;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.internal.tablecontents.Messages;
import org.faktorips.devtools.model.internal.tablecontents.SingleTableContentsValidator;
import org.faktorips.devtools.model.internal.tablecontents.TableColumnReference;
import org.faktorips.devtools.model.internal.tablecontents.TableContentsSaxHandler;
import org.faktorips.devtools.model.internal.tablecontents.TableRows;
import org.faktorips.devtools.model.internal.tablecontents.UniqueKeyValidator;
import org.faktorips.devtools.model.internal.tablestructure.TableStructure;
import org.faktorips.devtools.model.ipsobject.IDescription;
import org.faktorips.devtools.model.ipsobject.IFixDifferencesComposite;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.tablecontents.ITableContents;
import org.faktorips.devtools.model.tablecontents.ITableRows;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class TableContents
extends BaseIpsObject
implements ITableContents {
    public static final String COLUMNREFERENCENAME = "ColumnReference";
    private static final List<String> FIX_REQUIRING_ERROR_CODES = Arrays.asList("TABLECONTENTS-TableContentReferencedColumnNamesInvalid", "TABLECONTENTS-TableContentsReferencedColumnOrderingInvalid", "TABLECONTENTS-TableContentsReferencedColumnCountInvalid");
    private String structure = "";
    private ITableRows tableRows;
    private int numOfColumns = 0;
    private IpsObjectPartCollection<IPartReference> columnReferences = new IpsObjectPartCollection<IPartReference>(this, TableColumnReference.class, IPartReference.class, "ColumnTableReference");

    public TableContents(IIpsSrcFile file) {
        super(file);
    }

    @Override
    public ITableRows newTableRows() {
        this.setTableRowsInternal(this.createNewTableRowsInternal(this.getNextPartId()));
        this.partWasAdded(this.getTableRowsInternal());
        return this.getTableRowsInternal();
    }

    protected ITableRows createNewTableRowsInternal(String id) {
        TableRows newTableRows = new TableRows(this, id);
        this.initUniqueKeyValidator(newTableRows);
        return newTableRows;
    }

    private void initUniqueKeyValidator(TableRows tableRows) {
        ITableStructure tableStructure;
        try {
            tableStructure = this.findTableStructure(this.getIpsProject());
        }
        catch (IpsException e) {
            IpsLog.log(e);
            return;
        }
        tableRows.initUniqueKeyValidator(tableStructure, new UniqueKeyValidator());
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.TABLE_CONTENTS;
    }

    @Override
    public String getTableStructure() {
        return this.structure;
    }

    @Override
    public void setTableStructure(String tableStructure) {
        String oldStructure = this.structure;
        this.setTableStructureInternal(tableStructure);
        this.valueChanged(oldStructure, this.structure);
    }

    protected void setTableStructureInternal(String qName) {
        this.structure = qName;
    }

    @Override
    public ITableStructure findTableStructure(IIpsProject ipsProject) {
        return (ITableStructure)this.getIpsProject().findIpsObject(IpsObjectType.TABLE_STRUCTURE, this.structure);
    }

    @Override
    public int getNumOfColumns() {
        return this.numOfColumns;
    }

    public void setNumOfColumnsInternal(int numOfColumns) {
        this.numOfColumns = numOfColumns;
    }

    @Override
    public int newColumn(String defaultValue, String name) {
        this.newColumnAt(this.numOfColumns, defaultValue, name);
        return this.numOfColumns;
    }

    @Override
    protected IDescription newDescription(String id) {
        return super.newDescription(id);
    }

    @Override
    public void newColumnAt(int index, String defaultValue, String name) {
        ((TableRows)this.getTableRowsInternal()).newColumn(index, defaultValue);
        this.addNewColumnReference(name);
        ++this.numOfColumns;
        this.objectHasChanged();
    }

    @Override
    public void deleteColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.numOfColumns) {
            throw new IllegalArgumentException("Illegal column index " + columnIndex);
        }
        ((TableRows)this.getTableRowsInternal()).removeColumn(columnIndex);
        this.removeColumnReference(columnIndex);
        --this.numOfColumns;
        this.objectHasChanged();
    }

    @Override
    public void migrateColumnReferences() {
        ITableStructure newTableStructure;
        int referenceCount = this.getColumnReferencesCount();
        if (referenceCount == 0 && this.numOfColumns != 0 && (newTableStructure = this.findTableStructure(this.getIpsProject())) != null) {
            int i = 0;
            while (i < newTableStructure.getNumOfColumns()) {
                TableColumnReference newReference = new TableColumnReference(this, this.getNextPartId());
                newReference.setName(newTableStructure.getColumn(i).getName());
                this.columnReferences.addPart(newReference);
                ++i;
            }
        }
    }

    @Override
    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        if (IpsStringUtils.isEmpty((String)this.getTableStructure())) {
            return new IDependency[0];
        }
        return this.createDependencies(details);
    }

    private IDependency[] createDependencies(Map<IDependency, List<IDependencyDetail>> details) {
        ArrayList<IDependency> dependencies = new ArrayList<IDependency>();
        dependencies.add(this.createStructureDependency(details));
        dependencies.addAll(this.createValidationDependencies());
        return dependencies.toArray(new IDependency[dependencies.size()]);
    }

    private IDependency createStructureDependency(Map<IDependency, List<IDependencyDetail>> details) {
        IpsObjectDependency dependency = IpsObjectDependency.createInstanceOfDependency(this.getQualifiedNameType(), new QualifiedNameType(this.getTableStructure(), IpsObjectType.TABLE_STRUCTURE));
        this.addDetails(details, dependency, this, "tableStructure");
        return dependency;
    }

    private List<IDependency> createValidationDependencies() {
        ITableStructure tableStructure = this.findTableStructureInternal();
        if (this.isSingleContentStructure(tableStructure)) {
            return this.createValidationDependencies(tableStructure);
        }
        return Collections.emptyList();
    }

    private ITableStructure findTableStructureInternal() {
        return this.findTableStructure(this.getIpsProject());
    }

    private boolean isSingleContentStructure(ITableStructure tableStructure) {
        return tableStructure != null && !tableStructure.isMultipleContentsAllowed();
    }

    private List<IDependency> createValidationDependencies(ITableStructure tableStructure) {
        ArrayList<IDependency> dependencies = new ArrayList<IDependency>();
        List<IIpsSrcFile> siblingSrcFiles = this.getSiblingTableSrcFiles(tableStructure);
        for (IIpsSrcFile other : siblingSrcFiles) {
            IpsObjectDependency validationDependency = IpsObjectDependency.create(this.getQualifiedNameType(), other.getQualifiedNameType(), DependencyType.VALIDATION);
            dependencies.add(validationDependency);
        }
        return dependencies;
    }

    private List<IIpsSrcFile> getSiblingTableSrcFiles(ITableStructure tableStructure) {
        List<IIpsSrcFile> tableSrcFiles = this.getIpsProject().findAllTableContentsSrcFiles(tableStructure);
        tableSrcFiles.remove(this.getIpsSrcFile());
        return tableSrcFiles;
    }

    @Override
    public void initFromInputStream(InputStream is) {
        this.initTableContentFromStream(is, false);
    }

    private void initTableContentFromStream(InputStream is, boolean readWholeContent) {
        try {
            this.reinitPartCollections();
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(is), (DefaultHandler)new TableContentsSaxHandler(this, readWholeContent));
        }
        catch (IOException | ParserConfigurationException | SAXNotSupportedException e) {
            throw new IpsException((IStatus)new IpsStatus(e));
        }
        catch (SAXException e) {
            this.handleSaxException(e);
        }
    }

    private void handleSaxException(SAXException e) {
        if (e.getCause() != null) {
            throw new IpsException((IStatus)new IpsStatus(e.getCause()));
        }
    }

    @Override
    protected void propertiesToXml(Element newElement) {
        super.propertiesToXml(newElement);
        newElement.setAttribute("tableStructure", this.structure);
        newElement.setAttribute("numOfColumns", "" + this.numOfColumns);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.structure = element.getAttribute("tableStructure");
        this.numOfColumns = Integer.parseInt(element.getAttribute("numOfColumns"));
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if ("Rows".equals(xmlTagName) || "Generation".equals(xmlTagName)) {
            return this.createNewTableRowsInternal(id);
        }
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        if (ITableRows.class.isAssignableFrom(partType)) {
            return this.createNewTableRowsInternal(this.getNextPartId());
        }
        return null;
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        ArrayList<IIpsObjectPart> children = new ArrayList<IIpsObjectPart>();
        for (IPartReference reference : this.getColumnReferences()) {
            children.add(reference);
        }
        children.add(this.getTableRowsInternal());
        return children.toArray(new IIpsElement[children.size()]);
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof ITableRows) {
            if (!this.isRowsInitialized()) {
                this.setTableRowsInternal((ITableRows)part);
                return true;
            }
            throw new IllegalStateException("TableRows object already set for " + this);
        }
        return false;
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.setTableRowsInternal(null);
        this.columnReferences.clear();
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof ITableRows) {
            this.setTableRowsInternal(null);
            return true;
        }
        return false;
    }

    @Override
    protected void validateChildren(MessageList result, IIpsProject ipsProject) {
        if (this.isRowsInitialized() || IIpsModelExtensions.get().getModelPreferences().isAutoValidateTables()) {
            super.validateChildren(result, ipsProject);
        }
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        ITableStructure tableStructure = this.findTableStructure(ipsProject);
        if (tableStructure == null) {
            String text = MessageFormat.format(Messages.TableContents_msgMissingTablestructure, this.structure);
            list.add(new Message("TABLECONTENTS-UnknownStructure", text, Message.ERROR, (Object)this, new String[]{"tableStructure"}));
            return;
        }
        if (tableStructure.getNumOfColumns() != this.getNumOfColumns()) {
            String text = MessageFormat.format(Messages.TableContents_NumberOfColumnsInvalid, this.getNumOfColumns(), tableStructure.getNumOfColumns());
            Message validationMessage = new Message("TABLECONTENTS-NumOfColumns", text, Message.ERROR, (Object)this);
            list.add(validationMessage);
        }
        DeprecationValidation.validateTableStructureIsNotDeprecated(this, this.getQualifiedName(), tableStructure, ipsProject, list);
        this.validateColumnReferences(list, tableStructure);
        SingleTableContentsValidator singleTableContentsValidator = SingleTableContentsValidator.createFor(this);
        list.add(singleTableContentsValidator.validateIfPossible());
    }

    private void validateColumnReferences(MessageList validationMessageList, ITableStructure tableStructure) {
        this.validateColumnReferencesCount(validationMessageList, tableStructure);
        if (validationMessageList.containsErrorMsg()) {
            return;
        }
        List<IColumn> columns = Arrays.asList(tableStructure.getColumns());
        this.validateColumnReferenceNames(validationMessageList, tableStructure, columns);
        if (validationMessageList.containsErrorMsg()) {
            return;
        }
        this.validateColumnReferenceOrdering(validationMessageList, tableStructure, columns);
    }

    private void validateColumnReferencesCount(MessageList validationMessageList, ITableStructure tableStructure) {
        if (tableStructure.getNumOfColumns() != this.getColumnReferencesCount()) {
            String text = MessageFormat.format(Messages.TableContents_ReferencedColumnCountInvalid, tableStructure.getQualifiedName());
            Message validationMessage = new Message("TABLECONTENTS-TableContentsReferencedColumnCountInvalid", text, Message.ERROR, (Object)this);
            validationMessageList.add(validationMessage);
        }
    }

    private void validateColumnReferenceNames(MessageList validationMessageList, ITableStructure tableStructure, List<IColumn> columns) {
        for (IColumn currentColumn : columns) {
            if (this.containsEnumAttributeReference(currentColumn.getName())) continue;
            String text = MessageFormat.format(Messages.TableContents_ReferencedColumnNamesInvalid, tableStructure.getQualifiedName());
            Message validationMessage = new Message("TABLECONTENTS-TableContentReferencedColumnNamesInvalid", text, Message.ERROR, (Object)this);
            validationMessageList.add(validationMessage);
        }
    }

    private void validateColumnReferenceOrdering(MessageList validationMessageList, ITableStructure tableStructure, List<IColumn> columns) {
        int i = 0;
        while (i < columns.size()) {
            String currentReference;
            String currentColumnName = columns.get(i).getName();
            if (!currentColumnName.equals(currentReference = this.columnReferences.getPart(i).getName())) {
                String text = MessageFormat.format(Messages.TableContents_ReferencedColumnOrderingInvalid, tableStructure.getQualifiedName());
                Message validationMessage = new Message("TABLECONTENTS-TableContentsReferencedColumnOrderingInvalid", text, Message.ERROR, (Object)this);
                validationMessageList.add(validationMessage);
                break;
            }
            ++i;
        }
    }

    ValueDatatype[] findColumnDatatypes(ITableStructure structure, IIpsProject ipsProject) {
        if (structure == null) {
            return new ValueDatatype[0];
        }
        return ((TableStructure)structure).findColumnDatatypes(ipsProject);
    }

    ValueDatatype[] findColumnDatatypesByReferences(ITableStructure structure, IIpsProject ipsProject) {
        if (structure == null) {
            return new ValueDatatype[0];
        }
        ValueDatatype[] valueDatatypes = new ValueDatatype[this.columnReferences.size()];
        int i = 0;
        for (IPartReference reference : this.columnReferences) {
            IColumn column = structure.getColumn(reference.getName());
            valueDatatypes[i++] = column != null ? column.findValueDatatype(ipsProject) : null;
        }
        return valueDatatypes;
    }

    @Override
    public void addExtensionProperty(String propertyId, String extPropertyValue) {
        this.addExtensionPropertyValue(propertyId, extPropertyValue);
    }

    @Override
    public IIpsSrcFile findMetaClassSrcFile(IIpsProject ipsProject) {
        return ipsProject.findIpsSrcFile(IpsObjectType.TABLE_STRUCTURE, this.getTableStructure());
    }

    @Override
    public boolean isFixToModelRequired() {
        MessageList messages = this.validate(this.getIpsProject());
        for (Message message : messages) {
            if (!FIX_REQUIRING_ERROR_CODES.contains(message.getCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDifferenceToModel(IIpsProject ipsProject) {
        return false;
    }

    @Override
    public void fixAllDifferencesToModel(IIpsProject ipsProject) {
    }

    @Override
    public IFixDifferencesComposite computeDeltaToModel(IIpsProject ipsProject) {
        return null;
    }

    @Override
    public String getMetaClass() {
        return this.getTableStructure();
    }

    @Override
    public ITableRows getTableRows() {
        return this.getTableRowsInternal();
    }

    private ITableRows getTableRowsInternal() {
        if (!this.isRowsInitialized()) {
            this.readTableRows();
        }
        return this.tableRows;
    }

    private boolean isRowsInitialized() {
        return this.tableRows != null;
    }

    private void readTableRows() {
        if (!this.getIpsSrcFile().exists()) {
            this.newTableRows();
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = this.getIpsSrcFile().getContentFromEnclosingResource();){
                this.initTableContentFromStream(inputStream, true);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IpsException(e.getMessage(), (Throwable)e);
        }
    }

    protected void setTableRowsInternal(ITableRows tableRows) {
        this.tableRows = tableRows;
    }

    private void addNewColumnReference(String name) {
        ITableStructure newTableStructure = this.findTableStructure(this.getIpsProject());
        if (newTableStructure != null) {
            TableColumnReference newReference = new TableColumnReference(this, this.getNextPartId());
            newReference.setName(name);
            this.columnReferences.addPart(newReference);
        }
    }

    @Override
    public void createColumnReferenceSaxHandler(String referenceName) {
        TableColumnReference reference = new TableColumnReference(this, this.getNextPartId());
        reference.setName(referenceName);
        this.columnReferences.addPart(reference);
    }

    private void removeColumnReference(int columnIndex) {
        ITableStructure newTableStructure = this.findTableStructure(this.getIpsProject());
        if (newTableStructure != null) {
            this.columnReferences.removePart(this.columnReferences.getPart(columnIndex));
        }
    }

    private void sortColumnReferencesInternal(IColumn[] columnList) {
        if (columnList.length == this.columnReferences.size()) {
            IPartReference[] newOrdering = new IPartReference[columnList.length];
            int i = 0;
            IIpsObjectPart[] iIpsObjectPartArray = columnList;
            int n = columnList.length;
            int n2 = 0;
            while (n2 < n) {
                IColumn column = iIpsObjectPartArray[n2];
                for (IPartReference reference : this.columnReferences) {
                    if (!column.getName().equals(reference.getName())) continue;
                    newOrdering[i++] = reference;
                    break;
                }
                ++n2;
            }
            this.columnReferences.clear();
            iIpsObjectPartArray = newOrdering;
            n = newOrdering.length;
            n2 = 0;
            while (n2 < n) {
                IIpsObjectPart reference = iIpsObjectPartArray[n2];
                this.columnReferences.addPart(reference);
                ++n2;
            }
        }
        this.objectHasChanged(new PropertyChangeEvent(this.columnReferences, COLUMNREFERENCENAME, null, this.columnReferences));
    }

    @Override
    public void fixColumnReferences() {
        ITableStructure newTableStructure = this.findTableStructure(this.getIpsProject());
        if (newTableStructure != null) {
            this.updateReferences(newTableStructure);
            this.sortColumnReferencesInternal(newTableStructure.getColumns());
        }
    }

    private void updateReferences(ITableStructure structure) {
        IColumn[] columns = structure.getColumns();
        this.columnReferences.clear();
        IColumn[] iColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            TableColumnReference newReference = new TableColumnReference(this, this.getNextPartId());
            newReference.setName(column.getName());
            this.columnReferences.addPart(newReference);
            ++n2;
        }
    }

    private boolean containsEnumAttributeReference(String name) {
        for (IPartReference currentReference : this.columnReferences) {
            if (!currentReference.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IPartReference> getColumnReferences() {
        return this.columnReferences.getBackingList();
    }

    @Override
    public int getColumnReferencesCount() {
        return this.columnReferences.size();
    }
}

