/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.ipsobject.Description;
import org.faktorips.devtools.model.internal.tablecontents.TableContents;
import org.faktorips.devtools.model.internal.tablecontents.TableRows;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.tablecontents.ITableRows;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class TableContentsSaxHandler
extends DefaultHandler {
    private static final String TABLECONTENTS = IpsObjectType.TABLE_CONTENTS.getXmlElementName();
    private static final String VALUE = "Value";
    private static final String ROW = "Row";
    private static final String DESCRIPTION = "Description";
    private static final String ATTRIBUTE_TABLESTRUCTURE = "tableStructure";
    private static final String ATTRIBUTE_NUMOFCOLUMNS = "numOfColumns";
    private static final String COLUMNREFERENCE_TAG = "ColumnTableReference";
    private static final String COLUMNREFERENCE_NAME = "name";
    private static final String EXTENSIONPROPERTIES = TableRows.getXmlExtPropertiesElementName();
    private static final String EXTENSIONPROPERTIES_VALUE = TableRows.getXmlValueElement();
    private static final String EXTENSIONPROPERTIES_ID = TableRows.getXmlAttributeExtpropertyid();
    private static final String EXTENSIONPROPERTIES_ATTRIBUTE_ISNULL = TableRows.getXmlAttributeIsnull();
    private final TableContents tableContents;
    private ITableStructure tableStructure;
    private final boolean readRowsContent;
    private List<String> columns = new ArrayList<String>(20);
    private StringBuilder textBuilder = null;
    private boolean insideRowNode;
    private boolean insideExtensionPropertiesNode;
    private boolean insideValueNode;
    private boolean insideDescriptionNode;
    private boolean insideCsvContent;
    private boolean nullValue;
    private String extensionPropertyId;
    private String currentDescriptionLocale;
    private TableRows currentTableRows;
    private String currentId;
    private String referenceName;

    public TableContentsSaxHandler(TableContents tableContents, boolean readRowsContent) {
        this.tableContents = tableContents;
        this.readRowsContent = readRowsContent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.updateCurrentId(attributes);
        if (this.isTableContents(qName)) {
            this.tableContents.setTableStructureInternal(attributes.getValue(ATTRIBUTE_TABLESTRUCTURE));
            try {
                this.tableStructure = this.tableContents.findTableStructure(this.tableContents.getIpsProject());
            }
            catch (IpsException e) {
                this.tableStructure = null;
            }
            this.tableContents.setNumOfColumnsInternal(Integer.parseInt(attributes.getValue(ATTRIBUTE_NUMOFCOLUMNS)));
        } else if (COLUMNREFERENCE_TAG.equals(qName)) {
            this.referenceName = attributes.getValue(COLUMNREFERENCE_NAME);
        } else if (this.isTableRowsTag(qName)) {
            this.tableContents.migrateColumnReferences();
            this.readRowsContent();
            this.insideCsvContent = this.isFormatCsv(attributes);
        } else if (DESCRIPTION.equals(qName)) {
            this.insideDescriptionNode = true;
            this.currentDescriptionLocale = attributes.getValue("locale");
        } else if (EXTENSIONPROPERTIES.equals(qName)) {
            this.insideExtensionPropertiesNode = true;
        } else if (ROW.equals(qName)) {
            this.insideRowNode = true;
        } else if (this.isColumnValueNode(qName)) {
            this.insideValueNode = true;
            this.nullValue = Boolean.parseBoolean(attributes.getValue("isNull"));
        } else if (this.isExtensionPropertiesValueNode(qName)) {
            this.insideValueNode = true;
            this.nullValue = Boolean.parseBoolean(attributes.getValue(EXTENSIONPROPERTIES_ATTRIBUTE_ISNULL));
            this.extensionPropertyId = attributes.getValue(EXTENSIONPROPERTIES_ID);
        }
    }

    private boolean isFormatCsv(Attributes attributes) {
        String format = attributes.getValue("format");
        return format != null && ITableRows.FORMAT_CSV.equals(format);
    }

    private boolean isTableContents(String qName) {
        return TABLECONTENTS.equals(qName) && !this.readRowsContent;
    }

    private boolean isTableRowsTag(String qName) {
        return "Rows".equals(qName) || "Generation".equals(qName);
    }

    private void readRowsContent() throws SAXException {
        if (!this.readRowsContent) {
            throw new SAXException("Skip reading table content");
        }
        this.currentTableRows = (TableRows)this.tableContents.createNewTableRowsInternal(this.currentId);
        this.tableContents.setTableRowsInternal(this.currentTableRows);
    }

    private void updateCurrentId(Attributes attributes) {
        if (attributes != null) {
            String idValue;
            this.currentId = idValue = attributes.getValue("id");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ROW.equals(qName)) {
            this.insideRowNode = false;
            this.currentTableRows.newRow(this.tableStructure, (Optional)Optional.ofNullable(this.currentId), (List)this.columns);
            this.columns.clear();
        } else if (DESCRIPTION.equals(qName)) {
            this.insideDescriptionNode = false;
            this.handleDescription();
            this.textBuilder = null;
        } else if (EXTENSIONPROPERTIES.equals(qName)) {
            this.insideExtensionPropertiesNode = false;
        } else if (this.insideCsvContent && this.isTableRowsTag(qName)) {
            this.insideCsvContent = false;
            this.currentTableRows.initFromCsv(this.getText());
            this.textBuilder = null;
        } else if (this.isColumnValueNode(qName)) {
            this.insideValueNode = false;
            this.columns.add(this.getText());
            this.textBuilder = null;
        } else if (this.isExtensionPropertiesValueNode(qName)) {
            this.insideValueNode = false;
            this.handleExtensionProperty();
            this.textBuilder = null;
        } else if (this.isAttributeReferenceNode(qName)) {
            this.tableContents.createColumnReferenceSaxHandler(this.referenceName);
            this.referenceName = null;
        }
    }

    private void handleExtensionProperty() throws SAXNotSupportedException {
        if (this.currentTableRows != null) {
            throw new SAXNotSupportedException("Extension properties inside a generation node are not supported!");
        }
        this.tableContents.addExtensionProperty(this.extensionPropertyId, this.getText());
    }

    private void handleDescription() {
        if (!IpsStringUtils.isEmpty((String)this.currentDescriptionLocale)) {
            Locale locale = new Locale(this.currentDescriptionLocale);
            Description description = (Description)this.tableContents.getDescription(locale);
            if (description == null) {
                description = (Description)this.tableContents.newDescription(this.currentId);
                description.setLocaleWithoutChangeEvent(locale);
            }
            description.setTextWithoutChangeEvent(this.getText());
        }
    }

    private String getText() {
        return this.textBuilder == null && this.nullValue ? null : (this.textBuilder == null ? "" : this.textBuilder.toString());
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.insideDescriptionNode || this.insideValueNode || this.insideCsvContent) {
            String s = new String(buf, offset, len);
            if (this.textBuilder == null) {
                this.textBuilder = new StringBuilder(s);
            } else {
                this.textBuilder.append(s);
            }
        }
    }

    private boolean isColumnValueNode(String nodeName) {
        return VALUE.equals(nodeName) && this.insideRowNode;
    }

    private boolean isExtensionPropertiesValueNode(String nodeName) {
        return EXTENSIONPROPERTIES_VALUE.equals(nodeName) && this.insideExtensionPropertiesNode;
    }

    private boolean isAttributeReferenceNode(String nodeName) {
        return COLUMNREFERENCE_TAG.equals(nodeName);
    }
}

