/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPart;
import org.faktorips.devtools.model.internal.tablecontents.Row;
import org.faktorips.devtools.model.internal.tablecontents.TableContents;
import org.faktorips.devtools.model.internal.tablecontents.TableRowsCsvHelper;
import org.faktorips.devtools.model.internal.tablecontents.UniqueKeyValidator;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.tablecontents.IRow;
import org.faktorips.devtools.model.tablecontents.ITableContents;
import org.faktorips.devtools.model.tablecontents.ITableRows;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableRows
extends IpsObjectPart
implements ITableRows {
    private List<Row> rows = new ArrayList<Row>(100);
    private UniqueKeyValidator uniqueKeyValidator;
    private MessageList lastUniqueKeyValidationResult;

    public TableRows(TableContents parent, String id) {
        super(parent, id);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Rows");
    }

    @Override
    public IRow[] getRows() {
        return this.rows.toArray(new IRow[0]);
    }

    protected List<Row> getRowsAsList() {
        return Collections.unmodifiableList(this.rows);
    }

    @Override
    public IRow getRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getNumOfRows()) {
            return null;
        }
        return this.rows.get(rowIndex);
    }

    @Override
    public int getNumOfRows() {
        return this.rows.size();
    }

    @Override
    public IRow newRow() {
        Row newRow = this.newRowInternal(this.getNextPartId());
        this.objectHasChanged();
        return newRow;
    }

    @Override
    public Row newRow(ITableStructure tableStructure, Optional<String> id, List<String> columns) {
        Row newRow = this.newRowInternal(id.orElseGet(this::getNextPartId));
        int i = 0;
        while (i < columns.size()) {
            newRow.setValueInternal(i, columns.get(i));
            ++i;
        }
        if (tableStructure != null) {
            this.updateUniqueKeyCacheFor(newRow, tableStructure.getUniqueKeys());
        }
        newRow.setNumberOfValues(columns.size());
        return newRow;
    }

    public void markAsChanged() {
        this.objectHasChanged();
    }

    protected ITableStructure findTableStructure() {
        return this.getTableContents().findTableStructure(this.getIpsProject());
    }

    private Row newRowInternal(String id) {
        int nextRowNumber = this.getNumOfRows();
        Row newRow = new Row(this, id);
        this.rows.add(newRow);
        newRow.setRowNumber(nextRowNumber);
        return newRow;
    }

    public void newColumn(int insertAt, String defaultValue) {
        for (Row row : this.rows) {
            row.newColumn(insertAt, defaultValue);
        }
        this.clearUniqueKeyValidator();
    }

    public void removeColumn(int column) {
        for (Row row : this.rows) {
            row.removeColumn(column);
        }
        this.clearUniqueKeyValidator();
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        return this.getRows();
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if ("Row".equals(xmlTagName)) {
            return this.newRowInternal(id);
        }
        return null;
    }

    @Override
    public IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        if (partType.equals(IRow.class)) {
            return this.newRowInternal(this.getNextPartId());
        }
        return null;
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof IRow) {
            this.rows.add((Row)part);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof IRow) {
            Row row = (Row)part;
            int delIndex = this.rows.indexOf(row);
            if (delIndex != -1) {
                this.rows.remove(delIndex);
                int i = delIndex;
                while (i < this.rows.size()) {
                    Row updateRow = this.rows.get(i);
                    updateRow.setRowNumber(i);
                    ++i;
                }
                ITableStructure tableStructure = this.findTableStructure();
                if (tableStructure != null) {
                    this.removeUniqueKeyCacheFor(row, tableStructure.getUniqueKeys());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.rows.clear();
    }

    @Override
    public void clear() {
        this.rows.clear();
        this.clearUniqueKeyValidator();
        this.objectHasChanged();
    }

    public ITableContents getTableContents() {
        return (ITableContents)this.getParent();
    }

    @Override
    public IRow insertRowAfter(int rowIndex) {
        int newRowIndex = rowIndex + 1 > this.getNumOfRows() ? this.getNumOfRows() : rowIndex + 1;
        Row newRow = new Row(this, this.getNextPartId());
        this.rows.add(newRowIndex, newRow);
        newRow.setRowNumber(newRowIndex);
        this.refreshRowNumbers();
        this.objectHasChanged();
        return newRow;
    }

    private void refreshRowNumbers() {
        int index = 0;
        for (Row row : this.rows) {
            row.setRowNumber(index++);
        }
    }

    static String getXmlExtPropertiesElementName() {
        return "ExtensionProperties";
    }

    static String getXmlValueElement() {
        return "Value";
    }

    static String getXmlAttributeExtpropertyid() {
        return "id";
    }

    static String getXmlAttributeIsnull() {
        return "isNull";
    }

    private void updateUniqueKeyCache(ITableStructure tableStructure) {
        this.uniqueKeyValidator.clearUniqueKeyCache();
        IIndex[] uniqueKeys = tableStructure.getUniqueKeys();
        for (IRow iRow : this.rows) {
            this.updateUniqueKeyCacheFor((Row)iRow, uniqueKeys);
        }
        this.uniqueKeyValidator.cacheTableStructureAndValueDatatypes(this);
        this.uniqueKeyValidator.setTableStructureModificationTimeStamp(tableStructure);
    }

    public boolean wasUniqueKeyErrorStateChange() {
        return this.uniqueKeyValidator.wasErrorStateChange();
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        ITableStructure tableStructure = this.getTableContents().findTableStructure(ipsProject);
        ValueDatatype[] datatypes = ((TableContents)this.getTableContents()).findColumnDatatypesByReferences(tableStructure, ipsProject);
        if (tableStructure != null && datatypes != null && tableStructure.getUniqueKeys().length > 0) {
            MessageList validationMessageList = new MessageList();
            this.validateUniqueKeys(validationMessageList, tableStructure, datatypes);
            list.add(validationMessageList.getMessageByCode("TABLECONTENTS-TooManyUniqueKeyViolations"));
        }
    }

    void validateUniqueKeys(MessageList list, ITableStructure tableStructure, ValueDatatype[] datatypes) {
        this.validateUniqueKeys(list, tableStructure, datatypes, this.isUniqueKeyValidatedAutomatically(tableStructure));
    }

    public boolean isUniqueKeyValidatedAutomatically() {
        ITableStructure tableStructure = this.findTableStructure();
        return tableStructure != null && this.isUniqueKeyValidatedAutomatically(tableStructure);
    }

    private boolean isUniqueKeyValidatedAutomatically(ITableStructure tableStructure) {
        return tableStructure == null || tableStructure.getRanges().length * this.rows.size() <= 5000;
    }

    private void validateUniqueKeys(MessageList list, ITableStructure tableStructure, ValueDatatype[] datatypes, boolean validate) {
        if (this.isUniqueKeyValidationEnabled()) {
            if (validate) {
                if (this.uniqueKeyValidator.isEmpty() || this.uniqueKeyValidator.isInvalidUniqueKeyCache(tableStructure)) {
                    this.updateUniqueKeyCache(tableStructure);
                }
                this.uniqueKeyValidator.validateAllUniqueKeys(list, tableStructure, datatypes);
            } else {
                list.add(this.lastUniqueKeyValidationResult);
            }
        }
    }

    public void validateUniqueKeysManually() {
        ITableStructure tableStructure = this.findTableStructure();
        if (tableStructure != null) {
            this.lastUniqueKeyValidationResult = new MessageList();
            IIpsProject ipsProject = this.getTableContents().getIpsProject();
            ValueDatatype[] datatypes = ((TableContents)this.getTableContents()).findColumnDatatypesByReferences(tableStructure, ipsProject);
            this.validateUniqueKeys(this.lastUniqueKeyValidationResult, tableStructure, datatypes, true);
            boolean dirty = this.getIpsSrcFile().isDirty();
            this.objectHasChanged();
            if (!dirty) {
                this.getIpsSrcFile().markAsClean();
            }
        }
    }

    public boolean isUniqueKeyValidationEnabled() {
        return this.findTableStructure() != null && this.uniqueKeyValidator != null;
    }

    public void clearUniqueKeyValidator() {
        if (this.isUniqueKeyValidationEnabled()) {
            this.uniqueKeyValidator.clearUniqueKeyCache();
        }
    }

    void updateUniqueKeyCacheFor(Row row, IIndex[] uniqueKeys) {
        if (this.isUniqueKeyValidationEnabled()) {
            this.uniqueKeyValidator.handleRowChanged(this, row, uniqueKeys);
        }
    }

    private void removeUniqueKeyCacheFor(Row row, IIndex[] uniqueKeys) {
        if (this.isUniqueKeyValidationEnabled()) {
            this.uniqueKeyValidator.handleRowRemoved(this, row, uniqueKeys);
        }
    }

    public void initUniqueKeyValidator(ITableStructure tableStructure, UniqueKeyValidator uniqueKeyValidator) {
        this.uniqueKeyValidator = uniqueKeyValidator;
        if (tableStructure != null && uniqueKeyValidator != null) {
            this.updateUniqueKeyCache(tableStructure);
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.removeAttribute("id");
        if (this.usesCsv()) {
            element.setAttribute("format", FORMAT_CSV);
        }
    }

    private boolean usesCsv() {
        return FORMAT_CSV.equals(this.getIpsProject().getReadOnlyProperties().getTableContentFormat().getId());
    }

    @Override
    protected void partsToXml(Document doc, Element element) {
        if (this.usesCsv()) {
            new TableRowsCsvHelper(this).partsToCsv(doc, element);
        } else {
            super.partsToXml(doc, element);
        }
    }

    @Override
    public void initFromXml(Element element) {
        super.initFromXml(element);
        if (element.hasAttribute("format") && FORMAT_CSV.equals(element.getAttribute("format"))) {
            this.initFromCsv(element.getTextContent());
        }
    }

    public void initFromCsv(String text) {
        new TableRowsCsvHelper(this).initFromCsv(text);
    }
}

