/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.ICSVWriter;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.tablecontents.Row;
import org.faktorips.devtools.model.internal.tablecontents.TableRows;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.tablecontents.ITableContents;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class TableRowsCsvHelper {
    private static final String NULL_VALUE = "\\N";
    private final TableRows tableRows;

    TableRowsCsvHelper(TableRows tableRows) {
        this.tableRows = tableRows;
    }

    private ITableContents getTableContents() {
        return this.tableRows.getTableContents();
    }

    private IIpsProject getIpsProject() {
        return this.tableRows.getIpsProject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void partsToCsv(Document doc, Element element) {
        String nullRepresentationString = this.getNullRepresentationString();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                StringWriter stringWriter = new StringWriter();
                try {
                    try (ICSVWriter csvWriter = new CSVWriterBuilder((Writer)stringWriter).withSeparator('|').withQuoteChar('\"').withEscapeChar('\\').build();){
                        int numOfColumns = this.getTableContents().getNumOfColumns();
                        String[] nextLine = new String[numOfColumns];
                        this.tableRows.getRowsAsList().forEach(r -> this.writeRowToCsv(csvWriter, nextLine, (Row)r, nullRepresentationString));
                        String csv = stringWriter.toString();
                        CDATASection text = doc.createCDATASection(csv);
                        element.appendChild(text);
                    }
                    if (stringWriter == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stringWriter == null) throw throwable;
                    stringWriter.close();
                    throw throwable;
                }
                stringWriter.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw this.asIpsException(e);
        }
    }

    private String getNullRepresentationString() {
        return NULL_VALUE;
    }

    private void writeRowToCsv(ICSVWriter csvWriter, String[] nextLine, Row row, String nullRepresentationString) {
        int i = 0;
        while (i < nextLine.length) {
            String value = row.getValue(i);
            if (value == null) {
                value = nullRepresentationString;
            }
            nextLine[i] = value;
            ++i;
        }
        csvWriter.writeNext(nextLine, false);
    }

    private IpsException asIpsException(Exception e) {
        IpsLog.log(e);
        return new IpsException((IStatus)new Status(4, "org.faktorips.devtools.model", "Could not write table contents to CSV string", (Throwable)e));
    }

    public void initFromCsv(String csv) {
        String nullRepresentationString = this.getNullRepresentationString();
        Throwable throwable = null;
        Object var4_5 = null;
        try (StringReader stringReader = new StringReader(csv);){
            CSVParser csvParser = new CSVParserBuilder().withSeparator('|').withQuoteChar('\"').withEscapeChar('\\').build();
            try {
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (CSVReader csvReader = new CSVReaderBuilder((Reader)stringReader).withCSVParser((ICSVParser)csvParser).build();){
                    String[] csvLine;
                    ITableStructure structure = this.getTableContents().findTableStructure(this.getIpsProject());
                    while ((csvLine = csvReader.readNext()) != null) {
                        int i = 0;
                        while (i < csvLine.length) {
                            if (nullRepresentationString.equals(csvLine[i])) {
                                csvLine[i] = null;
                            }
                            ++i;
                        }
                        this.tableRows.newRow(structure, Optional.empty(), (List)Arrays.asList(csvLine));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (CsvValidationException | IOException e) {
                throw this.asIpsException((Exception)e);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

