/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.tablecontents.AbstractKeyValue;
import org.faktorips.devtools.model.internal.tablecontents.KeyValue;
import org.faktorips.devtools.model.internal.tablecontents.Messages;
import org.faktorips.devtools.model.internal.tablecontents.Row;
import org.faktorips.devtools.model.internal.tablecontents.TableContents;
import org.faktorips.devtools.model.internal.tablecontents.TableRows;
import org.faktorips.devtools.model.internal.tablecontents.UniqueKeyValidatorRange;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.tablecontents.ITableRows;
import org.faktorips.devtools.model.tablestructure.IColumn;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.IKeyItem;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;

public class UniqueKeyValidator {
    public static final int HANDLE_UNIQUEKEY_ROW_REMOVED = 1;
    public static final int HANDLE_UNIQUEKEY_ROW_CHANGED = 2;
    public static final boolean TRACE_VALIDATION_CACHE = Boolean.parseBoolean(Abstractions.getDebugOption((String)"org.faktorips.devtools.model/trace/tablecontentvalidation"));
    private Map<IIndex, Map<AbstractKeyValue, Set<Row>>> uniqueKeyMapColumn = new HashMap<IIndex, Map<AbstractKeyValue, Set<Row>>>();
    private Map<IIndex, UniqueKeyValidatorRange> uniqueKeyValidatorForTwoColumnRange = new HashMap<IIndex, UniqueKeyValidatorRange>();
    private MessageList cachedMessageList;
    private long tableStrunctureModificationStamp;
    private ITableStructure cachedTableStructure;
    private ValueDatatype[] cachedValueDatatypes;
    private boolean currentErrorStatus;
    private boolean previousErrorStatus;

    ITableStructure getCachedTableStructure() {
        return this.cachedTableStructure;
    }

    ValueDatatype[] getCachedValueDatatypes() {
        return this.cachedValueDatatypes;
    }

    public void clearUniqueKeyCache() {
        this.uniqueKeyMapColumn.clear();
        this.uniqueKeyValidatorForTwoColumnRange.clear();
    }

    public boolean isEmpty() {
        return this.uniqueKeyMapColumn.isEmpty() && this.uniqueKeyValidatorForTwoColumnRange.isEmpty();
    }

    public boolean wasErrorStateChange() {
        if (this.currentErrorStatus != this.previousErrorStatus) {
            this.previousErrorStatus = this.currentErrorStatus;
            return true;
        }
        return false;
    }

    public void handleRowChanged(ITableRows tableContentsGeneration, Row row, IIndex[] uniqueKeys) {
        this.updateAllUniqueKeysCache(tableContentsGeneration, row, 2, uniqueKeys);
    }

    public void handleRowRemoved(ITableRows tableContentsGeneration, Row row, IIndex[] uniqueKeys) {
        this.updateAllUniqueKeysCache(tableContentsGeneration, row, 1, uniqueKeys);
    }

    private void updateAllUniqueKeysCache(ITableRows tableContentsGeneration, Row row, int operation, IIndex[] uniqueKeys) {
        this.cachedMessageList = null;
        if (this.cachedTableStructure == null) {
            return;
        }
        this.cacheTableStructureAndValueDatatypes(tableContentsGeneration);
        IIndex[] iIndexArray = uniqueKeys;
        int n = uniqueKeys.length;
        int n2 = 0;
        while (n2 < n) {
            IIndex uniqueKey = iIndexArray[n2];
            if (uniqueKey.containsTwoColumnRanges()) {
                this.updateUniqueKeysColumnRange(row, operation, uniqueKey);
            } else {
                this.updateUniqueKeysCacheColumn(row, operation, uniqueKey);
            }
            ++n2;
        }
    }

    private void updateUniqueKeysCacheColumn(Row row, int operation, IIndex uniqueKey) {
        Map keyValueMap = this.uniqueKeyMapColumn.computeIfAbsent(uniqueKey, $ -> new HashMap());
        UniqueKeyValidator.updateKeyValueInMap(keyValueMap, KeyValue.createKeyValue(this.cachedTableStructure, uniqueKey, row), row, operation);
    }

    private void updateUniqueKeysColumnRange(Row row, int operation, IIndex uniqueKey) {
        UniqueKeyValidatorRange uniqueKeyValidatorRange = this.uniqueKeyValidatorForTwoColumnRange.get(uniqueKey);
        if (uniqueKeyValidatorRange == null) {
            uniqueKeyValidatorRange = new UniqueKeyValidatorRange(this, uniqueKey);
            this.uniqueKeyValidatorForTwoColumnRange.put(uniqueKey, uniqueKeyValidatorRange);
        }
        uniqueKeyValidatorRange.updateUniqueKeysCache(row, operation);
    }

    static void updateKeyValueInMap(Map<AbstractKeyValue, Set<Row>> keyValueMap, AbstractKeyValue keyValue, Row row, int operation) {
        Set rowsForKeyValue = keyValueMap.computeIfAbsent(keyValue, $ -> new HashSet(2));
        if (operation == 2) {
            if (!rowsForKeyValue.contains(row)) {
                rowsForKeyValue.add(row);
            }
        } else if (operation == 1) {
            rowsForKeyValue.remove(row);
        }
    }

    public void validateAllUniqueKeys(MessageList list, ITableStructure tableStructure, ValueDatatype[] datatypes) {
        if (this.cachedMessageList != null && !this.isInvalidUniqueKeyCache(tableStructure)) {
            list.add(this.cachedMessageList);
            return;
        }
        this.cachedValueDatatypes = datatypes;
        this.cachedTableStructure = tableStructure;
        if (TRACE_VALIDATION_CACHE) {
            this.printCachedContent();
        }
        MessageList validationErrors = new MessageList();
        this.validateUniqueKeys(validationErrors, this.uniqueKeyMapColumn);
        this.validateUniqueKeysRange(validationErrors, this.uniqueKeyValidatorForTwoColumnRange);
        list.add(validationErrors);
        this.currentErrorStatus = validationErrors.containsErrorMsg();
        this.cachedMessageList = list;
    }

    private void printCachedContent() {
        System.out.println("uniqueKeyValidatorForTwoColumnRange:");
        for (UniqueKeyValidatorRange entry : this.uniqueKeyValidatorForTwoColumnRange.values()) {
            entry.printCachedContent("  ");
        }
    }

    private void validateUniqueKeysRange(MessageList list, Map<IIndex, UniqueKeyValidatorRange> uniqueKeyValidatorForTwoColumnRange) {
        for (UniqueKeyValidatorRange uniqueKeyValidatorRange : uniqueKeyValidatorForTwoColumnRange.values()) {
            uniqueKeyValidatorRange.validate(list);
        }
    }

    private void validateUniqueKeys(MessageList list, Map<IIndex, Map<AbstractKeyValue, Set<Row>>> uniqueKeyMap2) {
        for (Map<AbstractKeyValue, Set<Row>> keyValuesForUniqueKeyCache : uniqueKeyMap2.values()) {
            ArrayList<AbstractKeyValue> invalidkeyValues = new ArrayList<AbstractKeyValue>();
            for (Map.Entry<AbstractKeyValue, Set<Row>> keyValueEntry : keyValuesForUniqueKeyCache.entrySet()) {
                this.validateKeyValue(list, keyValueEntry, invalidkeyValues, keyValuesForUniqueKeyCache);
            }
            for (AbstractKeyValue abstractKeyValue : invalidkeyValues) {
                keyValuesForUniqueKeyCache.remove(abstractKeyValue);
            }
        }
    }

    void validateKeyValue(MessageList list, Map.Entry<AbstractKeyValue, Set<Row>> keyValueEntry, List<AbstractKeyValue> invalidkeyValues, Map<AbstractKeyValue, Set<Row>> keyValuesForUniqueKeyCache) {
        AbstractKeyValue keyValue = keyValueEntry.getKey();
        Set<Row> rows = keyValueEntry.getValue();
        HashSet<Row> rowsChecked = new HashSet<Row>(rows.size());
        for (Row currentRow : rows) {
            if (!keyValue.isValid(currentRow)) continue;
            rowsChecked.add(currentRow);
        }
        if (rowsChecked.size() == 0) {
            invalidkeyValues.add(keyValue);
            return;
        }
        keyValuesForUniqueKeyCache.put(keyValueEntry.getKey(), rowsChecked);
        if (rowsChecked.size() > 1) {
            for (Row row : rowsChecked) {
                this.createValidationErrorUniqueKeyViolation(list, keyValue.getUniqueKey(), row);
            }
        }
    }

    void cacheTableStructureAndValueDatatypes(ITableRows tableContentsGeneration) {
        if (this.cachedTableStructure == null || this.isInvalidUniqueKeyCache(this.cachedTableStructure)) {
            this.updateCachedTableStructure((TableRows)tableContentsGeneration);
        }
        if (this.cachedValueDatatypes == null) {
            this.updateCachedValueDatatypes((TableRows)tableContentsGeneration);
        }
    }

    private void updateCachedValueDatatypes(TableRows tableContentsGeneration) {
        if (this.cachedTableStructure == null) {
            return;
        }
        try {
            this.cachedValueDatatypes = ((TableContents)tableContentsGeneration.getTableContents()).findColumnDatatypes(this.cachedTableStructure, tableContentsGeneration.getIpsProject());
        }
        catch (IpsException e) {
            IpsLog.log((IStatus)new IpsStatus("Error searching value datatypes: " + tableContentsGeneration.getTableContents().getTableStructure()));
            return;
        }
    }

    private void updateCachedTableStructure(TableRows tableContentsGeneration) {
        try {
            this.cachedTableStructure = tableContentsGeneration.getTableContents().findTableStructure(tableContentsGeneration.getIpsProject());
        }
        catch (IpsException e) {
            IpsLog.log((IStatus)new IpsStatus("Error searching TableStructure: " + tableContentsGeneration.getTableContents().getTableStructure()));
            return;
        }
    }

    public boolean isInvalidUniqueKeyCache(ITableStructure tableStructure) {
        return this.tableStrunctureModificationStamp != this.getTableStructureModTimeStamp(tableStructure);
    }

    public void setTableStructureModificationTimeStamp(ITableStructure tableStructure) {
        if (tableStructure == null) {
            return;
        }
        this.tableStrunctureModificationStamp = this.getTableStructureModTimeStamp(tableStructure);
    }

    private long getTableStructureModTimeStamp(ITableStructure tableStructure) {
        return tableStructure.getIpsSrcFile().getEnclosingResource().getModificationStamp();
    }

    void createValidationErrorUniqueKeyViolation(MessageList list, IIndex uniqueKey, Row row) {
        String text = MessageFormat.format(Messages.UniqueKeyValidator_msgUniqueKeyViolation, row.getRowNumber() + 1, uniqueKey.getName());
        ArrayList<ObjectProperty> objectProperties = new ArrayList<ObjectProperty>();
        this.createObjectProperties(uniqueKey, row, objectProperties);
        list.add(new Message("TABLECONTENTS-UniqueKeyViolation", text, Message.ERROR, objectProperties.toArray(new ObjectProperty[objectProperties.size()])));
    }

    private void createObjectProperties(IIndex uniqueKey, Row row, List<ObjectProperty> objectProperties) {
        IKeyItem[] items;
        IKeyItem[] iKeyItemArray = items = uniqueKey.getKeyItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn[] columns;
            IKeyItem item = iKeyItemArray[n2];
            IColumn[] iColumnArray = columns = item.getColumns();
            int n3 = columns.length;
            int n4 = 0;
            while (n4 < n3) {
                IColumn column = iColumnArray[n4];
                objectProperties.add(new ObjectProperty((Object)row, "value", this.cachedTableStructure.getColumnIndex(column)));
                ++n4;
            }
            ++n2;
        }
    }
}

