/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.tablecontents;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.faktorips.devtools.model.internal.tablecontents.AbstractKeyValue;
import org.faktorips.devtools.model.internal.tablecontents.KeyValue;
import org.faktorips.devtools.model.internal.tablecontents.KeyValueRange;
import org.faktorips.devtools.model.internal.tablecontents.Messages;
import org.faktorips.devtools.model.internal.tablecontents.Row;
import org.faktorips.devtools.model.internal.tablecontents.UniqueKeyValidator;
import org.faktorips.devtools.model.internal.tablestructure.ColumnRange;
import org.faktorips.devtools.model.tablestructure.IIndex;
import org.faktorips.devtools.model.tablestructure.ITableStructure;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;

public class UniqueKeyValidatorRange {
    private static final int MAX_NO_OF_UNIQUE_KEY_VALIDATION_ERRORS = 10;
    private UniqueKeyValidator uniqueKeyValidator;
    private IIndex uniqueKey;
    private Map<KeyValue, Map<ColumnRange, SortedMap<AbstractKeyValue, Set<Row>>>> keyValueRanges = new HashMap<KeyValue, Map<ColumnRange, SortedMap<AbstractKeyValue, Set<Row>>>>();
    private List<ColumnRange> twoColumnRanges;

    public UniqueKeyValidatorRange(UniqueKeyValidator uniqueKeyValidator, IIndex uniqueKey) {
        this.uniqueKeyValidator = uniqueKeyValidator;
        this.uniqueKey = uniqueKey;
        this.twoColumnRanges = AbstractKeyValue.getTwoColumnRanges(uniqueKey);
    }

    public void updateUniqueKeysCache(Row row, int operation) {
        KeyValue keyValue = KeyValue.createKeyValue(this.uniqueKeyValidator.getCachedTableStructure(), this.uniqueKey, row);
        Map listOfRangeMaps = this.keyValueRanges.computeIfAbsent(keyValue, $ -> new HashMap());
        for (ColumnRange columnRange : this.twoColumnRanges) {
            SortedMap sortedMap = listOfRangeMaps.computeIfAbsent(columnRange, $ -> new TreeMap());
            this.updateUniqueKeysColumnRange(this.uniqueKeyValidator.getCachedTableStructure(), row, operation, columnRange, sortedMap);
        }
    }

    private void updateUniqueKeysColumnRange(ITableStructure tableStructure, Row row, int operation, ColumnRange columnRange, SortedMap<AbstractKeyValue, Set<Row>> keyValueRangeMap) {
        KeyValueRange keyValueRange = KeyValueRange.createKeyValue(tableStructure, this.uniqueKeyValidator.getCachedValueDatatypes(), this.uniqueKey, row, columnRange);
        if (keyValueRange.isParsable()) {
            UniqueKeyValidator.updateKeyValueInMap(keyValueRangeMap, keyValueRange, row, operation);
        }
    }

    public void validate(MessageList list) {
        this.twoColumnRanges = AbstractKeyValue.getTwoColumnRanges(this.uniqueKey);
        ArrayList<KeyValue> invalidKeyValues = new ArrayList<KeyValue>();
        for (Map.Entry<KeyValue, Map<ColumnRange, SortedMap<AbstractKeyValue, Set<Row>>>> entry : this.keyValueRanges.entrySet()) {
            KeyValue keyValue = entry.getKey();
            if (!keyValue.isValid()) {
                invalidKeyValues.add(keyValue);
                continue;
            }
            Map<ColumnRange, SortedMap<AbstractKeyValue, Set<Row>>> columnRangeMaps = entry.getValue();
            this.validateAllRanges(list, keyValue, columnRangeMaps);
            if (list.getMessageByCode("TABLECONTENTS-TooManyUniqueKeyViolations") != null) break;
        }
        this.removeInvalidKeyValues(invalidKeyValues);
    }

    private void validateAllRanges(MessageList list, KeyValue keyValue, Map<ColumnRange, SortedMap<AbstractKeyValue, Set<Row>>> columnRangeMaps) {
        HashSet<Row> rowsUniqueKeyViolation = new HashSet<Row>(2);
        Map<KeyValueRange, Set<Row>> allRangesRowsSameFromValue = null;
        for (Map.Entry<ColumnRange, SortedMap<AbstractKeyValue, Set<Row>>> entry2 : columnRangeMaps.entrySet()) {
            SortedMap<AbstractKeyValue, Set<Row>> keyValueRangeMap = entry2.getValue();
            Map<KeyValueRange, Set<Row>> rowsSameFromValue = this.validateUniqueKeysRange(rowsUniqueKeyViolation, keyValue, keyValueRangeMap);
            allRangesRowsSameFromValue = this.mergeRowsInMap(allRangesRowsSameFromValue, rowsSameFromValue);
        }
        if (allRangesRowsSameFromValue != null && allRangesRowsSameFromValue.size() > 0) {
            for (Set rows : allRangesRowsSameFromValue.values()) {
                rowsUniqueKeyViolation.addAll(rows);
            }
        }
        MessageList uniqueKeyValidationErrors = new MessageList();
        for (Row row : rowsUniqueKeyViolation) {
            this.uniqueKeyValidator.createValidationErrorUniqueKeyViolation(uniqueKeyValidationErrors, keyValue.getUniqueKey(), row);
            if (this.isMaxNoOfUniqueKeyViolationsReached(uniqueKeyValidationErrors)) break;
        }
        list.add(uniqueKeyValidationErrors);
    }

    private Map<KeyValueRange, Set<Row>> mergeRowsInMap(Map<KeyValueRange, Set<Row>> prevRangesRowsSameFromValue, Map<KeyValueRange, Set<Row>> rowsSameFromValue) {
        if (prevRangesRowsSameFromValue == null) {
            return rowsSameFromValue;
        }
        HashMap<KeyValueRange, Set<Row>> result = new HashMap<KeyValueRange, Set<Row>>();
        HashSet<Row> rowsViolation = new HashSet<Row>(2);
        for (Map.Entry<KeyValueRange, Set<Row>> entry : prevRangesRowsSameFromValue.entrySet()) {
            KeyValueRange keyValue = entry.getKey();
            Set<Row> rows = entry.getValue();
            for (Map.Entry<KeyValueRange, Set<Row>> entryInSecondSet : rowsSameFromValue.entrySet()) {
                this.addOverlappingRows(rowsViolation, rows, entryInSecondSet.getValue());
            }
            if (rowsViolation.size() <= 0) continue;
            result.put(keyValue, rowsViolation);
        }
        return result;
    }

    private void addOverlappingRows(Set<Row> rowsViolation, Set<Row> rows, Set<Row> rowsInSecondSet) {
        for (Row row : rows) {
            boolean collision = false;
            for (Row rowSecond : rowsInSecondSet) {
                if (row == rowSecond || !(collision = this.collisionInAllRanges(row, rowSecond))) continue;
                rowsViolation.add(row);
                break;
            }
            if (collision) break;
        }
    }

    private void removeInvalidKeyValues(List<KeyValue> invalidKeyValues) {
        for (KeyValue invalidKeyValue : invalidKeyValues) {
            this.keyValueRanges.remove(invalidKeyValue);
        }
    }

    private Map<KeyValueRange, Set<Row>> validateUniqueKeysRange(Set<Row> rowsUniqueKeyViolation, KeyValue keyValue, SortedMap<AbstractKeyValue, Set<Row>> keyValueRangeMap) {
        ArrayList<AbstractKeyValue> invalidkeyValues = new ArrayList<AbstractKeyValue>();
        HashMap<KeyValueRange, Set<Row>> mapRowsSameFrom = new HashMap<KeyValueRange, Set<Row>>();
        KeyValueRange prevKeyValueFrom = null;
        this.updateInvalidKeyValues(keyValue, invalidkeyValues);
        for (Map.Entry<AbstractKeyValue, Set<Row>> entry : keyValueRangeMap.entrySet()) {
            Set<Row> rowsChecked;
            KeyValueRange keyValueFrom = (KeyValueRange)entry.getKey();
            Set<Row> keyValueObject = entry.getValue();
            if (!this.isValid(keyValue, keyValueFrom, keyValueFrom.getRow())) continue;
            List<Row> validRows = this.updateValidRows(keyValue, keyValueFrom, keyValueObject);
            if (validRows.size() > 1) {
                Set rowsSameFrom = mapRowsSameFrom.computeIfAbsent(keyValueFrom, $ -> new HashSet(2));
                rowsSameFrom.addAll(validRows);
            } else if (validRows.size() == 0) {
                invalidkeyValues.add(keyValueFrom);
                continue;
            }
            if (rowsUniqueKeyViolation.size() >= 10) break;
            if (prevKeyValueFrom != null && (rowsChecked = this.validateKeyValueRange(rowsUniqueKeyViolation, prevKeyValueFrom, keyValueFrom, keyValueObject, invalidkeyValues)) != null) {
                keyValueRangeMap.put(entry.getKey(), rowsChecked);
            }
            prevKeyValueFrom = keyValueFrom;
        }
        for (AbstractKeyValue abstractKeyValue : invalidkeyValues) {
            keyValueRangeMap.remove(abstractKeyValue);
        }
        return mapRowsSameFrom;
    }

    private List<Row> updateValidRows(KeyValue keyValue, KeyValueRange keyValueFrom, Set<Row> keyValueObject) {
        ArrayList<Row> validRows = new ArrayList<Row>();
        for (Row row : keyValueObject) {
            if (!this.isValid(keyValue, keyValueFrom, row)) continue;
            validRows.add(row);
        }
        return validRows;
    }

    private boolean isValid(KeyValue keyValue, KeyValueRange keyValueFrom, Row row) {
        return keyValueFrom.isValid(row) && keyValue.isValid(row);
    }

    private void updateInvalidKeyValues(KeyValue keyValue, List<AbstractKeyValue> invalidkeyValues) {
        if (!keyValue.isValid()) {
            invalidkeyValues.add(keyValue);
        }
    }

    private boolean isMaxNoOfUniqueKeyViolationsReached(MessageList list) {
        if (list.size() >= 10) {
            this.createValidationErrorTooManyUniqueKeyViolations(list, 10);
            return true;
        }
        return false;
    }

    private Set<Row> validateKeyValueRange(Set<Row> rowsUniqueKeyViolation, KeyValueRange prevFrom, KeyValueRange keyValue, Set<Row> rows, List<AbstractKeyValue> invalidkeyValues) {
        HashSet<Row> rowsChecked = new HashSet<Row>(rows.size());
        for (Row currentRow : rows) {
            if (!keyValue.isValid(currentRow)) continue;
            rowsChecked.add(currentRow);
        }
        if (rowsChecked.size() == 0) {
            invalidkeyValues.add(keyValue);
            return rowsChecked;
        }
        for (Row currentRow : rowsChecked) {
            if (!this.collisionInAllRanges(prevFrom.getRow(), currentRow)) continue;
            rowsUniqueKeyViolation.add(prevFrom.getRow());
            rowsUniqueKeyViolation.add(currentRow);
        }
        return rowsChecked;
    }

    private boolean collisionInAllRanges(Row row1, Row row2) {
        for (ColumnRange columnRange : this.twoColumnRanges) {
            if (KeyValueRange.isRangeCollision(this.uniqueKeyValidator.getCachedTableStructure(), this.uniqueKeyValidator.getCachedValueDatatypes(), columnRange, row1, row2)) continue;
            return false;
        }
        return true;
    }

    private void createValidationErrorTooManyUniqueKeyViolations(MessageList list, int numberOfValidationErrors) {
        String text = MessageFormat.format(Messages.UniqueKeyValidatorRange_msgTooManyUniqueKeyViolations, numberOfValidationErrors, this.uniqueKey.getName());
        list.add(new Message("TABLECONTENTS-TooManyUniqueKeyViolations", text, Message.ERROR));
    }

    public void printCachedContent(String offset) {
        System.out.println(String.valueOf(offset) + " UniqueKeyRange:" + this.uniqueKey.getName());
        for (Map.Entry<KeyValue, Map<ColumnRange, SortedMap<AbstractKeyValue, Set<Row>>>> entry : this.keyValueRanges.entrySet()) {
            System.out.println(String.valueOf(offset) + " KeyValue:" + entry.getKey());
            this.printCachedColumnRange(String.valueOf(offset) + " ", entry.getValue());
        }
    }

    private void printCachedColumnRange(String offset, Map<ColumnRange, SortedMap<AbstractKeyValue, Set<Row>>> sortedMap) {
        for (Map.Entry<ColumnRange, SortedMap<AbstractKeyValue, Set<Row>>> entry : sortedMap.entrySet()) {
            System.out.println(String.valueOf(offset) + " ColumnRange:" + entry.getKey().getName());
            this.printCachedSordetMap(String.valueOf(offset) + " ", entry.getValue());
        }
    }

    private void printCachedSordetMap(String offset, SortedMap<AbstractKeyValue, Set<Row>> map) {
        for (Map.Entry<AbstractKeyValue, Set<Row>> entry : map.entrySet()) {
            System.out.println(String.valueOf(offset) + " KeyValue:");
            this.printCachedEntryOrList(String.valueOf(offset) + " ", entry.getValue());
        }
    }

    private void printCachedEntryOrList(String offset, Set<Row> entry) {
        System.out.println(String.valueOf(offset) + " " + entry.size() + " Rows colision candidates, same from column:");
        for (Row object : entry) {
            System.out.println(String.valueOf(offset) + "   Row:" + this.printRow(object));
        }
    }

    private String printRow(Row row) {
        int noOfColumns = row.getNoOfColumns();
        String result = " [" + row.getRowNumber() + "] ";
        int i = 0;
        while (i < noOfColumns) {
            result = String.valueOf(result) + row.getValue(i) + ", ";
            ++i;
        }
        return result.replaceAll(",$", "");
    }
}

